/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.launch;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.registry.lib.com.AbstractRegistryController;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.pattern.launch.AbstractLauncher;
import org.openbase.jul.storage.registry.RemoteRegistry;

public abstract class AbstractRegistryLauncher<L extends AbstractRegistryController>
extends AbstractLauncher<L> {
    public AbstractRegistryLauncher(Class applicationClass, Class<L> launchableClass) throws InstantiationException {
        super(applicationClass, launchableClass);
    }

    public void verify() throws VerificationFailedException, InterruptedException {
        MultiException.ExceptionStack exceptionStack = null;
        List<RemoteRegistry> remoteRegistries = ((AbstractRegistryController)this.getLaunchable()).getRemoteRegistries();
        block4: while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            for (RemoteRegistry registry : remoteRegistries) {
                if (!registry.isBusy() && !registry.isNotificationInProgess() && registry.isValueAvailable()) continue;
                try {
                    registry.waitUntilReadyFuture().get(10L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException ex) {
                    this.logger.info(registry + " still not ready yet, observation continued...");
                }
                continue block4;
            }
            break;
        }
        for (RemoteRegistry registry : remoteRegistries) {
            if (registry.isConsistent()) continue;
            exceptionStack = MultiException.push((Object)this.getLaunchable(), (Exception)new VerificationFailedException(registry.getName() + " started in read only mode!", (Throwable)new InvalidStateException("Registry not consistent!")), exceptionStack);
        }
        try {
            MultiException.checkAndThrow((String)(JPService.getApplicationName() + " started in fallback mode!"), exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            throw new VerificationFailedException((Throwable)ex);
        }
    }
}

