/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.util;

import java.util.ArrayList;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.storage.registry.ProtoBufRegistry;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.device.DeviceClassType;

public class DeviceConfigUtils {
    public static boolean checkDuplicatedUnitType(UnitConfigType.UnitConfigOrBuilder deviceUnitConfig, DeviceClassType.DeviceClassOrBuilder deviceClass, ProtoBufRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> dalUnitRegistry) throws CouldNotPerformException {
        ArrayList<UnitTemplateType.UnitTemplate.UnitType> unitTypeList = new ArrayList<UnitTemplateType.UnitTemplate.UnitType>();
        for (UnitTemplateConfigType.UnitTemplateConfig unitTemplateConfig : deviceClass.getUnitTemplateConfigList()) {
            if (unitTypeList.contains(unitTemplateConfig.getType())) {
                return true;
            }
            unitTypeList.add(unitTemplateConfig.getType());
        }
        return false;
    }

    public static boolean setupUnitLabelByDeviceConfig(UnitConfigType.UnitConfig.Builder unitConfig, UnitConfigType.UnitConfigOrBuilder deviceConfig, DeviceClassType.DeviceClassOrBuilder deviceClass, ProtoBufRegistry<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> dalUnitRegistry) throws CouldNotPerformException {
        return DeviceConfigUtils.setupUnitLabelByDeviceConfig(unitConfig, deviceConfig, deviceClass, DeviceConfigUtils.checkDuplicatedUnitType(deviceConfig, deviceClass, dalUnitRegistry));
    }

    public static boolean setupUnitLabelByDeviceConfig(UnitConfigType.UnitConfig.Builder unitConfig, UnitConfigType.UnitConfigOrBuilder deviceUnitConfig, DeviceClassType.DeviceClassOrBuilder deviceClass, boolean deviceConfigHasDuplicatedUnitType) throws CouldNotPerformException {
        try {
            if (!unitConfig.hasLabel() || unitConfig.getLabel().isEmpty() || unitConfig.getBoundToUnitHost()) {
                if (deviceConfigHasDuplicatedUnitType) {
                    if (unitConfig.hasLabel() && !unitConfig.getLabel().isEmpty()) {
                        return false;
                    }
                    if (!unitConfig.hasUnitTemplateConfigId()) {
                        throw new NotAvailableException("unitconfig.unittemplateconfigid");
                    }
                    unitConfig.setLabel(DeviceConfigUtils.generateDefaultUnitLabel(unitConfig, deviceUnitConfig, deviceClass, deviceConfigHasDuplicatedUnitType));
                    return true;
                }
                if (!deviceUnitConfig.hasLabel()) {
                    throw new NotAvailableException("deviceconfig.label");
                }
                if (!unitConfig.getLabel().equals(deviceUnitConfig.getLabel())) {
                    unitConfig.setLabel(DeviceConfigUtils.generateDefaultUnitLabel(unitConfig, deviceUnitConfig, deviceClass, deviceConfigHasDuplicatedUnitType));
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not setup UnitConfig[" + unitConfig.getId() + "] by DeviceConfig[" + deviceUnitConfig + "]!", (Throwable)ex);
        }
    }

    public static String generateDefaultUnitLabel(UnitConfigType.UnitConfig.Builder unitConfig, UnitConfigType.UnitConfigOrBuilder deviceUnitConfig, DeviceClassType.DeviceClassOrBuilder deviceClass, boolean deviceConfigHasDuplicatedUnitType) throws CouldNotPerformException {
        if (deviceConfigHasDuplicatedUnitType) {
            for (UnitTemplateConfigType.UnitTemplateConfig unitTemplateConfig : deviceClass.getUnitTemplateConfigList()) {
                if (!unitTemplateConfig.getId().equals(unitConfig.getUnitTemplateConfigId())) continue;
                if (unitTemplateConfig.getLabel().isEmpty()) {
                    throw new NotAvailableException("unitTemplateConfig.label");
                }
                return deviceUnitConfig.getLabel() + "_" + unitTemplateConfig.getLabel();
            }
            throw new CouldNotPerformException("DeviceClass[" + deviceClass.getId() + "] does not contain UnitTemplateConfig[" + unitConfig.getUnitTemplateConfigId() + "]!");
        }
        return deviceUnitConfig.getLabel();
    }
}

