/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Collection;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.AbstractFilter;
import org.openbase.jul.pattern.MockUpFilter;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRegistrySynchronizer<M extends GeneratedMessage>
implements Observer<M> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteRegistrySynchronizer.class);
    private final RemoteRegistry<?, M, ?> remoteRegistry;
    private final Descriptors.FieldDescriptor[] fieldDescriptors;
    private final AbstractFilter<M> filter;

    public RemoteRegistrySynchronizer(RemoteRegistry<?, M, ?> remoteRegistry, Descriptors.FieldDescriptor[] fieldDescriptors) {
        this(remoteRegistry, fieldDescriptors, (AbstractFilter<M>)new MockUpFilter());
    }

    public RemoteRegistrySynchronizer(RemoteRegistry<?, M, ?> remoteRegistry, Descriptors.FieldDescriptor[] fieldDescriptors, AbstractFilter<M> filter) {
        this.remoteRegistry = remoteRegistry;
        this.fieldDescriptors = fieldDescriptors;
        this.filter = filter;
    }

    public void update(Observable<M> source, M data) throws Exception {
        try {
            if (data == null) {
                throw new NotAvailableException("RegistryData");
            }
            ArrayList<GeneratedMessage> entryList = new ArrayList<GeneratedMessage>();
            for (Descriptors.FieldDescriptor fieldDescriptor : this.fieldDescriptors) {
                for (int i = 0; i < data.getRepeatedFieldCount(fieldDescriptor); ++i) {
                    entryList.add((GeneratedMessage)data.getRepeatedField(fieldDescriptor, i));
                }
            }
            this.remoteRegistry.notifyRegistryUpdate((Collection)this.filter.filter(entryList));
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)"Registry synchronization failed!", (Throwable)ex, (Logger)LOGGER);
        }
    }
}

