/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.registry.lib.com;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbase.bco.registry.lib.com.AbstractRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.extension.protobuf.processing.ProtoBufFieldProcessor;
import org.openbase.jul.extension.rsb.scope.jp.JPScope;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;

public abstract class AbstractVirtualRegistryRemote<M extends GeneratedMessage>
extends AbstractRegistryRemote<M> {
    private final Map<RemoteRegistry, Descriptors.FieldDescriptor> remoteRegistryFieldDescriptorMap;
    private final Map<RemoteRegistry, RegistryRemote<? extends GeneratedMessage>> remoteRegistrySyncMap;
    private final List<RegistryRemote<? extends GeneratedMessage>> registryRemotes;
    private final SyncObject virtualRegistrySyncLock = new SyncObject("RegistryRemoteVirtualSyncLock");
    private final Observer snchronisationObserver;

    public AbstractVirtualRegistryRemote(Class<? extends JPScope> jpScopePropery, Class<M> dataClass) {
        super(jpScopePropery, dataClass);
        this.remoteRegistryFieldDescriptorMap = new HashMap<RemoteRegistry, Descriptors.FieldDescriptor>();
        this.remoteRegistrySyncMap = new HashMap<RemoteRegistry, RegistryRemote<? extends GeneratedMessage>>();
        this.registryRemotes = new ArrayList<RegistryRemote<? extends GeneratedMessage>>();
        this.snchronisationObserver = (source, data1) -> {
            SyncObject syncObject = this.virtualRegistrySyncLock;
            synchronized (syncObject) {
                this.virtualRegistrySyncLock.notifyAll();
            }
        };
    }

    @Override
    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        this.registerRegistryRemotes();
        this.bindRegistryRemoteToRemoteRegistries();
    }

    @Override
    protected void registerRemoteRegistry(RemoteRegistry remoteRegistry) {
        super.registerRemoteRegistry(remoteRegistry);
        remoteRegistry.addObserver(this.snchronisationObserver);
    }

    protected void registerRegistryRemote(RegistryRemote<? extends GeneratedMessage> registryRemote) {
        this.registryRemotes.add(registryRemote);
    }

    protected abstract void registerRegistryRemotes() throws InitializationException, InterruptedException;

    protected void bindRegistryRemoteToRemoteRegistry(RemoteRegistry remoteRegistry, RegistryRemote<? extends GeneratedMessage> registryRemote, Integer fieldNumber) throws CouldNotPerformException {
        try {
            Descriptors.FieldDescriptor fieldDescriptor = null;
            try {
                fieldDescriptor = ProtoBufFieldProcessor.getFieldDescriptors((Class)registryRemote.getDataClass(), (int[])new int[]{fieldNumber})[0];
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Invalid field descriptor for [" + registryRemote.getDataClass().getSimpleName() + "]", (Throwable)ex);
            }
            if (!this.registryRemotes.contains(registryRemote)) {
                throw new CouldNotPerformException("Trying to bind to unregistered registryRemote");
            }
            this.remoteRegistryFieldDescriptorMap.put(remoteRegistry, fieldDescriptor);
            this.remoteRegistrySyncMap.put(remoteRegistry, registryRemote);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not bind fieldNumber[" + fieldNumber + "] of [" + registryRemote.getDataClass().getSimpleName() + "] to remoteRegistry[" + remoteRegistry + "]", (Throwable)ex);
        }
    }

    protected abstract void bindRegistryRemoteToRemoteRegistries();

    public void waitForData() throws CouldNotPerformException, InterruptedException {
        for (RegistryRemote<? extends GeneratedMessage> registryRemote : this.registryRemotes) {
            registryRemote.waitForData();
        }
        super.waitForData();
        this.waitForVirtualRegistrySync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForVirtualRegistrySync() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.virtualRegistrySyncLock;
        synchronized (syncObject) {
            while (!this.equalMessageCounts()) {
                this.virtualRegistrySyncLock.wait();
            }
        }
    }

    private boolean equalMessageCounts() throws CouldNotPerformException {
        for (RemoteRegistry remoteRegistry : this.remoteRegistrySyncMap.keySet()) {
            if (((GeneratedMessage)this.remoteRegistrySyncMap.get(remoteRegistry).getData()).getRepeatedFieldCount(this.remoteRegistryFieldDescriptorMap.get(remoteRegistry)) == remoteRegistry.getMessages().size()) continue;
            return false;
        }
        return true;
    }
}

