/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib.future;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.AuthenticationClientHandler;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.jul.exception.CouldNotPerformException;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;

public abstract class AuthenticatedFuture<RETURN, INTERNAL>
implements Future<RETURN> {
    private final Future<INTERNAL> internalFuture;
    private final SessionManager sessionManager;
    private final Class<RETURN> returnClass;
    private final TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper;

    public AuthenticatedFuture(Future<INTERNAL> internalFuture, Class<RETURN> returnClass, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper) {
        this(internalFuture, returnClass, wrapper, SessionManager.getInstance());
    }

    public AuthenticatedFuture(Future<INTERNAL> internalFuture, Class<RETURN> returnClass, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper, SessionManager sessionManager) {
        this.internalFuture = internalFuture;
        this.returnClass = returnClass;
        this.sessionManager = sessionManager;
        this.wrapper = wrapper;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.internalFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.internalFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.internalFuture.isDone();
    }

    @Override
    public RETURN get() throws InterruptedException, ExecutionException {
        INTERNAL internalResult = this.internalFuture.get();
        try {
            this.verifyResponse(this.getTicketFromInternal(internalResult));
            return this.convertFromInternal(internalResult);
        }
        catch (CouldNotPerformException ex) {
            throw new ExecutionException("Could not execute authentication", ex);
        }
    }

    @Override
    public RETURN get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        INTERNAL internalResult = this.internalFuture.get(timeout, unit);
        try {
            this.verifyResponse(this.getTicketFromInternal(internalResult));
            return this.convertFromInternal(internalResult);
        }
        catch (CouldNotPerformException ex) {
            throw new ExecutionException("Could not execute authentication", ex);
        }
    }

    private void verifyResponse(TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper) throws CouldNotPerformException {
        try {
            if (!this.sessionManager.isLoggedIn()) {
                return;
            }
            this.sessionManager.setTicketAuthenticatorWrapper(AuthenticationClientHandler.handleServiceServerResponse(this.sessionManager.getSessionKey(), this.wrapper, ticketAuthenticatorWrapper));
        }
        catch (IOException | BadPaddingException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not verify ServiceServer Response", ex);
        }
    }

    protected Class<RETURN> getReturnClass() {
        return this.returnClass;
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected abstract TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper getTicketFromInternal(INTERNAL var1);

    protected abstract RETURN convertFromInternal(INTERNAL var1) throws CouldNotPerformException;
}

