/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib.com;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.EncryptionHelper;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.extension.protobuf.processing.SimpleMessageProcessor;
import rst.domotic.authentication.AuthenticatedValueType;

public class AuthenticatedMessageProcessor<M extends GeneratedMessage>
extends SimpleMessageProcessor<M> {
    public AuthenticatedMessageProcessor(Class<M> dataClass) {
        super(dataClass);
    }

    public M process(GeneratedMessage input) throws CouldNotPerformException, InterruptedException {
        if (input instanceof AuthenticatedValueType.AuthenticatedValue) {
            AuthenticatedValueType.AuthenticatedValue authenticatedValue = (AuthenticatedValueType.AuthenticatedValue)input;
            if (SessionManager.getInstance().isLoggedIn()) {
                try {
                    return (M)super.process((GeneratedMessage)EncryptionHelper.decryptSymmetric(authenticatedValue.getValue(), SessionManager.getInstance().getSessionKey(), this.getDataClass()));
                }
                catch (IOException | BadPaddingException ex) {
                    throw new CouldNotPerformException("Decrypting result in of authenticated value failed!", (Throwable)ex);
                }
            }
            try {
                Method parseFrom = this.getDataClass().getMethod("parseFrom", ByteString.class);
                return (M)super.process((GeneratedMessage)parseFrom.invoke(null, authenticatedValue.getValue()));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new CouldNotPerformException("Could not invoke parseFrom method on [" + this.getDataClass().getSimpleName() + "]", (Throwable)ex);
            }
        }
        return (M)super.process(input);
    }
}

