/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib.com;

import com.google.protobuf.GeneratedMessage;
import java.util.concurrent.Future;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.authentication.lib.com.AuthenticatedMessageProcessor;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.protobuf.processing.MessageProcessor;
import org.openbase.jul.extension.rsb.com.RSBRemoteService;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import rsb.Event;
import rsb.Handler;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;

public abstract class AbstractAuthenticatedRemoteService<M extends GeneratedMessage>
extends RSBRemoteService<M> {
    private final Observer<String> loginObserver;

    public AbstractAuthenticatedRemoteService(Class<M> dataClass) {
        super(dataClass);
        this.setMessageProcessor((MessageProcessor)new AuthenticatedMessageProcessor<M>(dataClass));
        this.loginObserver = (source, data) -> this.requestData();
        SessionManager.getInstance().addLoginObserver(this.loginObserver);
    }

    protected Handler generateHandler() {
        return new AuthenticatedUpdateHandler();
    }

    protected Future<Event> internalRequestStatus() throws CouldNotPerformException {
        if (SessionManager.getInstance().isLoggedIn()) {
            Event event = new Event(TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.class, (Object)SessionManager.getInstance().initializeServiceServerRequest());
            return this.getRemoteServer().callAsync("requestDataAuthenticated", event);
        }
        return super.internalRequestStatus();
    }

    private class AuthenticatedUpdateHandler
    implements Handler {
        private AuthenticatedUpdateHandler() {
        }

        public void internalNotify(Event event) {
            try {
                AbstractAuthenticatedRemoteService.this.logger.debug("Internal notification while logged in[" + SessionManager.getInstance().isLoggedIn() + "]");
                if (event.getData() != null && SessionManager.getInstance().isLoggedIn()) {
                    AbstractAuthenticatedRemoteService.this.requestData();
                } else {
                    AbstractAuthenticatedRemoteService.this.applyEventUpdate(event);
                }
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Internal notification failed!", (Throwable)ex), (Logger)AbstractAuthenticatedRemoteService.this.logger);
            }
        }
    }
}

