/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib.com;

import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import org.openbase.bco.authentication.lib.AuthenticatedServerManager;
import org.openbase.bco.authentication.lib.EncryptionHelper;
import org.openbase.bco.authentication.lib.iface.AuthenticatedRequestable;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBCommunicationService;
import org.openbase.jul.extension.rsb.iface.RSBLocalServer;
import org.slf4j.Logger;
import rsb.config.ParticipantConfig;
import rst.domotic.authentication.AuthenticatedValueType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;
import rst.rsb.ScopeType;

public abstract class AbstractAuthenticatedCommunicationService<M extends GeneratedMessage, MB extends GeneratedMessage.Builder<MB>>
extends RSBCommunicationService<M, MB>
implements AuthenticatedRequestable<M> {
    public AbstractAuthenticatedCommunicationService(MB builder) throws InstantiationException {
        super(builder);
    }

    public void init(ScopeType.Scope scope, ParticipantConfig participantConfig) throws InitializationException, InterruptedException {
        super.init(scope, participantConfig);
        try {
            RPCHelper.registerInterface(AuthenticatedRequestable.class, (Object)this, (RSBLocalServer)this.server);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public M requestStatus() throws CouldNotPerformException {
        this.logger.debug("requestStatus of " + this);
        try {
            return this.updateDataToPublish(this.cloneDataBuilder());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Could not request status update.", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
        }
    }

    @Override
    public AuthenticatedValueType.AuthenticatedValue requestDataAuthenticated(TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticket) throws CouldNotPerformException {
        this.logger.debug("requestStatusAuthenticated of " + this);
        try {
            AuthenticatedServerManager.TicketEvaluationWrapper ticketEvaluationWrapper = AuthenticatedServerManager.getInstance().evaluateClientServerTicket(ticket);
            M newData = this.filterDataForUser(this.cloneDataBuilder(), ticketEvaluationWrapper.getUserId());
            AuthenticatedValueType.AuthenticatedValue.Builder response = AuthenticatedValueType.AuthenticatedValue.newBuilder();
            response.setTicketAuthenticatorWrapper(ticketEvaluationWrapper.getTicketAuthenticatorWrapper());
            response.setValue(EncryptionHelper.encryptSymmetric(newData, ticketEvaluationWrapper.getSessionKey()));
            return response.build();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CouldNotPerformException("Could not request data because interruption while validating ticket", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CouldNotPerformException("Could not request data authenticated because encryption or decryption with session key failed", (Throwable)ex);
        }
    }

    protected M updateDataToPublish(MB dataBuilder) throws CouldNotPerformException {
        try {
            return this.filterDataForUser(dataBuilder, null);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not filter data builder for rights", (Throwable)ex);
        }
    }

    protected abstract M filterDataForUser(MB var1, String var2) throws CouldNotPerformException;
}

