/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import java.util.HashMap;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.ObservableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionReporter
extends ObservableImpl<ExceptionReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionReporter.class);
    private static ExceptionReporter instance;
    private HashMap<Class<? extends Throwable>, HashMap<StackTraceElement, ExceptionReport>> reports = new HashMap();

    public static ExceptionReporter getInstance() {
        if (instance == null) {
            instance = new ExceptionReporter();
        }
        return instance;
    }

    private ExceptionReporter() {
    }

    public void report(Throwable th) {
        this.report(th, -1);
    }

    public void report(Throwable th, int limit) {
        ExceptionReport report;
        assert (th.getStackTrace().length > 0);
        StackTraceElement source = th.getStackTrace()[0];
        assert (source != null);
        HashMap<StackTraceElement, ExceptionReport> reportCollection = this.reports.get(th.getClass());
        if (reportCollection == null) {
            reportCollection = new HashMap();
            this.reports.put(th.getClass(), reportCollection);
        }
        if ((report = reportCollection.get(source)) != null) {
            report.addCount();
        } else {
            report = new ExceptionReport(th, 1, limit);
            reportCollection.put(source, report);
        }
        if (report.isOverLimit()) {
            try {
                this.notifyObservers(report);
                report.resetCount();
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER);
            }
        }
    }

    public class ExceptionReport {
        private Throwable throwable;
        private int count;
        private int limit;

        public ExceptionReport(Throwable throwable) {
            this(throwable, 1, -1);
        }

        public ExceptionReport(Throwable throwable, int count) {
            this(throwable, count, -1);
        }

        public ExceptionReport(Throwable throwable, int count, int limit) {
            this.throwable = throwable;
            this.count = count;
            this.limit = limit;
        }

        public void resetCount() {
            this.count = 0;
        }

        public void addCount() {
            ++this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        private boolean isOverLimit() {
            return this.limit >= 0 && this.count > this.limit;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public int getCount() {
            return this.count;
        }

        public int getLimit() {
            return this.limit;
        }
    }
}

