/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.openbase.jul.exception.FatalImplementationErrorException;

public class EncryptionHelper {
    private static final String ASYMMETRIC_ALGORITHM = "RSA";
    private static final String ASYMMETRIC_TRANSFORMATION = "RSA";
    private static final int ASYMMETRIC_KEY_LENGTH = 1024;
    private static final String SYMMETRIC_ALGORITHM = "AES";
    private static final String SYMMETRIC_TRANSFORMATION = "AES";
    private static final int SYMMETRIC_KEY_LENGTH = 128;
    private static final String HASH_ALGORITHM = "SHA-256";

    public static byte[] generateKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException ex) {
            new FatalImplementationErrorException("Key transformation non existent", EncryptionHelper.class, (Throwable)ex);
            return null;
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(1024);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException ex) {
            new FatalImplementationErrorException("Key transformation non existent", EncryptionHelper.class, (Throwable)ex);
            return null;
        }
    }

    public static byte[] hash(String string) {
        try {
            byte[] key = string.getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance(HASH_ALGORITHM);
            key = sha.digest(key);
            return Arrays.copyOf(key, 16);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            new FatalImplementationErrorException("Hashing[" + string + "] failed!", EncryptionHelper.class, (Throwable)ex);
            return null;
        }
    }

    public static ByteString encryptSymmetric(Serializable object, byte[] key) throws IOException {
        return ByteString.copyFrom((byte[])EncryptionHelper.encrypt(object, key, true));
    }

    public static ByteString encryptAsymmetric(Serializable object, byte[] key) throws IOException {
        return ByteString.copyFrom((byte[])EncryptionHelper.encrypt(object, key, false));
    }

    /*
     * Exception decompiling
     */
    public static byte[] encrypt(Serializable object, byte[] key, boolean symmetric) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T> T decryptSymmetric(ByteString encryptedObject, byte[] key, Class<T> encryptedClass) throws IOException, BadPaddingException {
        return EncryptionHelper.decrypt(encryptedObject, key, encryptedClass, true);
    }

    public static <T> T decryptAsymmetric(ByteString encryptedObject, byte[] key, Class<T> encryptedClass) throws IOException, BadPaddingException {
        return EncryptionHelper.decrypt(encryptedObject, key, encryptedClass, false);
    }

    public static <T> T decrypt(ByteString encryptedObject, byte[] key, Class<T> encryptedClass, boolean symmetric) throws IOException, BadPaddingException, ClassCastException {
        return EncryptionHelper.decrypt(encryptedObject.toByteArray(), key, encryptedClass, symmetric);
    }

    /*
     * Exception decompiling
     */
    public static <T> T decrypt(byte[] encryptedObject, byte[] key, Class<T> encryptedClass, boolean symmetric) throws IOException, BadPaddingException, ClassCastException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] createCipherBlockChainingVector() {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        return iv;
    }
}

