/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import com.google.protobuf.GeneratedMessage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import org.openbase.bco.authentication.lib.jp.JPCredentialsDirectory;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.processing.ProtoBufFileProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.authentication.LoginCredentialsCollectionType;
import rst.domotic.authentication.LoginCredentialsType;

public class CredentialStore {
    public static final String SERVICE_SERVER_ID = "serviceServer";
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialStore.class);
    protected final HashMap<String, LoginCredentialsType.LoginCredentials> credentials;
    private final String filename;
    private final File credentialFile;
    private final Base64.Encoder encoder;
    private final Base64.Decoder decoder;
    private final ProtoBufFileProcessor<LoginCredentialsCollectionType.LoginCredentialsCollection, LoginCredentialsCollectionType.LoginCredentialsCollection, LoginCredentialsCollectionType.LoginCredentialsCollection.Builder> fileProcessor;

    public CredentialStore(String filename) throws InitializationException {
        try {
            this.filename = filename;
            this.credentialFile = new File((File)((JPCredentialsDirectory)JPService.getProperty(JPCredentialsDirectory.class)).getValue(), filename);
            this.credentials = new HashMap();
            this.fileProcessor = new ProtoBufFileProcessor((GeneratedMessage.Builder)LoginCredentialsCollectionType.LoginCredentialsCollection.newBuilder());
            this.encoder = Base64.getEncoder();
            this.decoder = Base64.getDecoder();
        }
        catch (JPNotAvailableException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void init() throws InitializationException {
        try {
            this.loadStore();
            this.setStorePermissions();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException(CredentialStore.class, (Throwable)ex);
        }
    }

    private void loadStore() throws CouldNotPerformException {
        if (!this.credentialFile.exists()) {
            this.saveStore();
        }
        this.credentials.clear();
        LoginCredentialsCollectionType.LoginCredentialsCollection collection = (LoginCredentialsCollectionType.LoginCredentialsCollection)this.fileProcessor.deserialize(this.credentialFile);
        collection.getElementList().forEach(entry -> this.credentials.put(entry.getId(), (LoginCredentialsType.LoginCredentials)entry));
    }

    protected void saveStore() {
        try {
            LoginCredentialsCollectionType.LoginCredentialsCollection collection = LoginCredentialsCollectionType.LoginCredentialsCollection.newBuilder().addAllElement(this.credentials.values()).build();
            this.fileProcessor.serialize((Object)collection, this.credentialFile);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
    }

    private void setStorePermissions() throws CouldNotPerformException {
        CredentialStore.protectFile(this.credentialFile);
    }

    public static void protectFile(File file) throws CouldNotPerformException {
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            try {
                Files.setPosixFilePermissions(file.toPath(), perms);
            }
            catch (UnsupportedOperationException ex) {
                file.setReadable(true, true);
                file.setWritable(true, true);
                file.setExecutable(true, true);
            }
        }
        catch (IOException ex) {
            throw new CouldNotPerformException("Could not protect " + file.getAbsolutePath(), (Throwable)ex);
        }
    }

    public boolean isEmpty() {
        return this.credentials.isEmpty();
    }

    public boolean hasOnlyServiceServer() {
        return this.credentials.size() == 1 && this.credentials.containsKey(SERVICE_SERVER_ID);
    }

    public boolean hasEntry(String id) {
        return this.credentials.containsKey(id);
    }

    public AbstractMap.SimpleEntry<String, LoginCredentialsType.LoginCredentials> getFirstEntry() {
        if (!this.credentials.isEmpty()) {
            String firstKey = new ArrayList<String>(this.credentials.keySet()).get(0);
            return new AbstractMap.SimpleEntry<String, LoginCredentialsType.LoginCredentials>(firstKey, this.credentials.get(firstKey));
        }
        return null;
    }

    public void removeEntry(String id) {
        if (this.hasEntry(id)) {
            this.credentials.remove(id);
        }
        this.saveStore();
    }

    public byte[] getCredentials(String userId) throws NotAvailableException {
        if (!this.credentials.containsKey(userId)) {
            throw new NotAvailableException(userId);
        }
        return this.decoder.decode(this.credentials.get(userId).getCredentials());
    }

    public void setCredentials(String userId, byte[] credentials) {
        if (!this.credentials.containsKey(userId)) {
            this.addCredentials(userId, credentials, false);
        } else {
            this.addCredentials(userId, credentials, this.credentials.get(userId).getAdmin());
        }
    }

    public void addCredentials(String id, byte[] credentials, boolean admin) {
        LoginCredentialsType.LoginCredentials loginCredentials = LoginCredentialsType.LoginCredentials.newBuilder().setId(id).setCredentials(this.encoder.encodeToString(credentials)).setAdmin(admin).build();
        this.credentials.put(id, loginCredentials);
        this.saveStore();
    }

    public boolean isAdmin(String userId) throws NotAvailableException {
        if (!this.credentials.containsKey(userId)) {
            return false;
        }
        return this.credentials.get(userId).getAdmin();
    }

    public void setAdmin(String userId, boolean isAdmin) throws NotAvailableException {
        if (!this.credentials.containsKey(userId)) {
            throw new NotAvailableException(userId);
        }
        LoginCredentialsType.LoginCredentials loginCredentials = LoginCredentialsType.LoginCredentials.newBuilder((LoginCredentialsType.LoginCredentials)this.credentials.get(userId)).setAdmin(isAdmin).build();
        this.credentials.put(userId, loginCredentials);
        this.saveStore();
    }

    public void shutdown() {
        if (JPService.testMode()) {
            this.credentials.clear();
        }
        this.saveStore();
    }
}

