/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import com.google.protobuf.ProtocolStringList;
import java.util.Map;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.processing.StringProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.authentication.PermissionConfigType;
import rst.domotic.authentication.PermissionType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.rsb.ScopeType;

public class AuthorizationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationHelper.class);

    public static boolean canRead(UnitConfigType.UnitConfig unitConfig, String userId, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> groups, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) {
        return AuthorizationHelper.canDo(unitConfig, userId, groups, locations, Type.READ);
    }

    public static boolean canWrite(UnitConfigType.UnitConfig unitConfig, String userId, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> groups, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) {
        return AuthorizationHelper.canDo(unitConfig, userId, groups, locations, Type.WRITE);
    }

    public static boolean canAccess(UnitConfigType.UnitConfig unitConfig, String userId, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> groups, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) {
        return AuthorizationHelper.canDo(unitConfig, userId, groups, locations, Type.ACCESS);
    }

    public static PermissionType.Permission getPermission(UnitConfigType.UnitConfig unitConfig, String userId, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> groups, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) throws CouldNotPerformException {
        return PermissionType.Permission.newBuilder().setAccess(AuthorizationHelper.canAccess(unitConfig, userId, groups, locations)).setRead(AuthorizationHelper.canRead(unitConfig, userId, groups, locations)).setWrite(AuthorizationHelper.canWrite(unitConfig, userId, groups, locations)).build();
    }

    private static boolean canDo(UnitConfigType.UnitConfig unitConfig, String userId, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> groups, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations, Type type) {
        if (unitConfig.getType() == UnitTemplateType.UnitTemplate.UnitType.UNKNOWN) {
            return true;
        }
        if (!AuthorizationHelper.isAuthenticationUnit(unitConfig) && !AuthorizationHelper.isRootLocation(unitConfig, locations)) {
            try {
                if (!AuthorizationHelper.canRead(AuthorizationHelper.getLocationUnitConfig(unitConfig.getPlacementConfig().getLocationId(), locations), userId, groups, locations)) {
                    return false;
                }
            }
            catch (NotAvailableException ex) {
                String scope;
                try {
                    scope = ScopeGenerator.generateStringRep((ScopeType.Scope)unitConfig.getScope());
                }
                catch (CouldNotPerformException exx) {
                    scope = "?";
                }
                LOGGER.warn("PermissionConfig of Unit[" + scope + "] is denied!", (Throwable)ex);
                return false;
            }
        }
        try {
            return AuthorizationHelper.canDo(AuthorizationHelper.getPermissionConfig(unitConfig, locations), userId, groups, locations, type);
        }
        catch (CouldNotPerformException ex) {
            LOGGER.warn("can not perform the canDo check! Permission will be denied!", (Throwable)ex);
            return false;
        }
    }

    private static boolean canDo(PermissionConfigType.PermissionConfig permissionConfig, String userId, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> groups, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations, Type type) {
        if (AuthorizationHelper.permitted(permissionConfig.getOtherPermission(), type)) {
            return true;
        }
        if (userId == null) {
            return false;
        }
        String[] split = userId.split("@", 2);
        if (split.length > 1) {
            return AuthorizationHelper.canDo(permissionConfig, split[0], groups, locations, type) || AuthorizationHelper.canDo(permissionConfig, split[1], groups, locations, type);
        }
        if (permissionConfig.getOwnerId().equals(userId) && AuthorizationHelper.permitted(permissionConfig.getOwnerPermission(), type)) {
            return true;
        }
        if (groups == null) {
            return false;
        }
        for (PermissionConfigType.PermissionConfig.MapFieldEntry entry : permissionConfig.getGroupPermissionList()) {
            if (groups.get(entry.getGroupId()) == null) {
                LOGGER.warn("No Group for id[" + entry.getGroupId() + "] available");
                continue;
            }
            ProtocolStringList groupMembers = ((UnitConfigType.UnitConfig)groups.get(entry.getGroupId()).getMessage()).getAuthorizationGroupConfig().getMemberIdList();
            if (!groupMembers.contains((Object)userId) || !AuthorizationHelper.permitted(entry.getPermission(), type)) continue;
            return true;
        }
        return false;
    }

    private static boolean permitted(PermissionType.Permission permission, Type type) {
        switch (type) {
            case READ: {
                return permission.getRead();
            }
            case WRITE: {
                return permission.getWrite();
            }
            case ACCESS: {
                return permission.getAccess();
            }
        }
        return false;
    }

    private static PermissionConfigType.PermissionConfig getPermissionConfig(UnitConfigType.UnitConfig unitConfig, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) throws NotAvailableException {
        try {
            PermissionConfigType.PermissionConfig unitPermissionConfig;
            if (unitConfig == null) {
                throw new NotAvailableException("UnitConfig");
            }
            if (AuthorizationHelper.isRootLocation(unitConfig, locations)) {
                if (!unitConfig.hasPermissionConfig()) {
                    throw new InvalidStateException("The root location does not provide a permission config!");
                }
                return unitConfig.getPermissionConfig();
            }
            if (AuthorizationHelper.isAuthenticationUnit(unitConfig)) {
                if (!unitConfig.hasPermissionConfig()) {
                    throw new InvalidStateException(StringProcessor.transformUpperCaseToCamelCase((String)unitConfig.getType().name()) + " should always provide a permission config!");
                }
                return unitConfig.getPermissionConfig();
            }
            if (locations == null || locations.isEmpty()) {
                throw new InvalidStateException("No location information available for permission resolution!");
            }
            try {
                UnitConfigType.UnitConfig locationUnitConfig = AuthorizationHelper.getLocationUnitConfig(unitConfig.getPlacementConfig().getLocationId(), locations);
                unitPermissionConfig = AuthorizationHelper.getPermissionConfig(locationUnitConfig, locations);
            }
            catch (NotAvailableException ex) {
                throw new InvalidStateException("Parent location does not provide a permission config!", (Throwable)ex);
            }
            if (unitConfig.hasPermissionConfig()) {
                unitPermissionConfig = AuthorizationHelper.mergePermissionConfigs(unitConfig.getPermissionConfig(), unitPermissionConfig);
            }
            return unitPermissionConfig;
        }
        catch (CouldNotPerformException ex) {
            String scope;
            try {
                scope = ScopeGenerator.generateStringRep((ScopeType.Scope)unitConfig.getScope());
            }
            catch (CouldNotPerformException exx) {
                scope = "?";
            }
            throw new NotAvailableException("PermissionConfig of Unit[" + scope + "]", (Throwable)ex);
        }
    }

    private static boolean isRootLocation(UnitConfigType.UnitConfig unitConfig, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) {
        if (unitConfig.getType() != UnitTemplateType.UnitTemplate.UnitType.LOCATION) {
            return false;
        }
        if (locations.isEmpty()) {
            return true;
        }
        return unitConfig.getLocationConfig().hasRoot() && unitConfig.getLocationConfig().getRoot();
    }

    private static UnitConfigType.UnitConfig getRootLocationUnitConfig(Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) throws NotAvailableException {
        try {
            for (IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> locationUnitConfig : locations.values()) {
                if (!AuthorizationHelper.isRootLocation((UnitConfigType.UnitConfig)locationUnitConfig.getMessage(), locations)) continue;
                return (UnitConfigType.UnitConfig)locationUnitConfig.getMessage();
            }
            throw new InvalidStateException("Registry does not provide a root location!");
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("RootLocation", (Throwable)ex);
        }
    }

    private static boolean isAuthenticationUnit(UnitConfigType.UnitConfig unitConfig) {
        switch (unitConfig.getType()) {
            case USER: 
            case AUTHORIZATION_GROUP: {
                return true;
            }
        }
        return false;
    }

    private static UnitConfigType.UnitConfig getLocationUnitConfig(String locationId, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) throws NotAvailableException {
        try {
            if (locationId.isEmpty()) {
                throw new NotAvailableException("locationId");
            }
            if (!locations.containsKey(locationId)) {
                LOGGER.warn("Registry does not contains requested location Entry[" + locationId + "] use root location as fallback to compute permissions.");
                return AuthorizationHelper.getRootLocationUnitConfig(locations);
            }
            return (UnitConfigType.UnitConfig)locations.get(locationId).getMessage();
        }
        catch (NullPointerException | CouldNotPerformException ex) {
            throw new NotAvailableException("LocationConfig[" + locationId + "]", ex);
        }
    }

    private static PermissionConfigType.PermissionConfig mergePermissionConfigs(PermissionConfigType.PermissionConfig unitPermissionConfig, PermissionConfigType.PermissionConfig parentLocationPermissionConfig) throws CouldNotPerformException {
        if (unitPermissionConfig == null) {
            throw new NotAvailableException("UserPermissionConfig");
        }
        if (parentLocationPermissionConfig == null) {
            throw new NotAvailableException("ParentLocationPermissionConfig");
        }
        PermissionConfigType.PermissionConfig.Builder builder = PermissionConfigType.PermissionConfig.newBuilder((PermissionConfigType.PermissionConfig)unitPermissionConfig);
        if (!(unitPermissionConfig.hasOtherPermission() && unitPermissionConfig.getOtherPermission().hasAccess() && unitPermissionConfig.getOtherPermission().hasRead() && unitPermissionConfig.getOtherPermission().hasWrite())) {
            builder.setOtherPermission(parentLocationPermissionConfig.getOtherPermission());
        }
        if (!(unitPermissionConfig.hasOwnerPermission() && unitPermissionConfig.getOwnerPermission().hasAccess() && unitPermissionConfig.getOwnerPermission().hasRead() && unitPermissionConfig.getOwnerPermission().hasWrite())) {
            builder.setOwnerPermission(parentLocationPermissionConfig.getOwnerPermission());
        }
        boolean found = false;
        for (PermissionConfigType.PermissionConfig.MapFieldEntry locationEntry : parentLocationPermissionConfig.getGroupPermissionList()) {
            for (PermissionConfigType.PermissionConfig.MapFieldEntry unitEntry : unitPermissionConfig.getGroupPermissionList()) {
                if (!locationEntry.getGroupId().equals(unitEntry.getGroupId())) continue;
                found = true;
            }
            if (!found) {
                builder.addGroupPermission(locationEntry);
            }
            found = false;
        }
        return builder.build();
    }

    private static enum Type {
        READ,
        WRITE,
        ACCESS;

    }
}

