/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import java.util.Map;
import org.openbase.bco.authentication.lib.AuthorizationHelper;
import org.openbase.bco.authentication.lib.CachedAuthenticationRemote;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.authentication.lib.jp.JPAuthentication;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.pattern.AbstractFilter;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class AuthorizationFilter
extends AbstractFilter<UnitConfigType.UnitConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationFilter.class);
    private final SessionManager sessionManager;
    private Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> authorizationGroups;
    private Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations;

    public AuthorizationFilter() {
        this(SessionManager.getInstance());
    }

    public AuthorizationFilter(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setAuthorizationGroups(Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> authorizationGroups) {
        this.authorizationGroups = authorizationGroups;
    }

    public void setLocations(Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locations) {
        this.locations = locations;
    }

    public void beforeFilter() throws CouldNotPerformException {
        try {
            if (!((Boolean)((JPAuthentication)JPService.getProperty(JPAuthentication.class)).getValue()).booleanValue()) {
                return;
            }
        }
        catch (JPNotAvailableException ex) {
            throw new CouldNotPerformException("Could not check JPEnableAuthenticationProperty", (Throwable)ex);
        }
        try {
            CachedAuthenticationRemote.getRemote();
            this.sessionManager.isAuthenticated();
        }
        catch (CouldNotPerformException ex) {
            if (ex.getCause() instanceof InvalidStateException) {
                System.out.println("Could not check authenticated because in shutdown");
            }
            throw new CouldNotPerformException("Authentication failed", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean filter(UnitConfigType.UnitConfig unitConfig) throws CouldNotPerformException {
        try {
            if (!((Boolean)((JPAuthentication)JPService.getProperty(JPAuthentication.class)).getValue()).booleanValue()) {
                return true;
            }
        }
        catch (JPNotAvailableException ex) {
            return false;
        }
        return AuthorizationHelper.canRead(unitConfig, this.sessionManager.getUserAtClientId(), this.authorizationGroups, this.locations);
    }

    public void addObserver(Observer observer) {
        this.sessionManager.addLoginObserver((Observer<String>)observer);
    }

    public void removeObserver(Observer observer) {
        this.sessionManager.removeLoginObserver((Observer<String>)observer);
    }
}

