/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import com.google.protobuf.Message;
import java.util.concurrent.Future;
import org.openbase.bco.authentication.lib.AuthenticationService;
import org.openbase.bco.authentication.lib.jp.JPAuthenticationScope;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.com.NotInitializedRSBRemoteServer;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.com.RSBFactoryImpl;
import org.openbase.jul.extension.rsb.com.RSBSharedConnectionConfig;
import org.openbase.jul.extension.rsb.iface.RSBRemoteServer;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Manageable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.schedule.WatchDog;
import rsb.Scope;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.authentication.AuthenticatedValueType;
import rst.domotic.authentication.LoginCredentialsChangeType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;
import rst.domotic.authentication.TicketSessionKeyWrapperType;

public class AuthenticationRemote
implements AuthenticationService,
Manageable<Void>,
VoidInitializable {
    private RSBRemoteServer remoteServer = new NotInitializedRSBRemoteServer();
    private WatchDog serverWatchDog;

    public void init() throws InitializationException, InterruptedException {
        try {
            this.remoteServer = RSBFactoryImpl.getInstance().createSynchronizedRemoteServer((Scope)((JPAuthenticationScope)JPService.getProperty(JPAuthenticationScope.class)).getValue(), RSBSharedConnectionConfig.getParticipantConfig());
            this.serverWatchDog = new WatchDog((Activatable)this.remoteServer, "AuthenticatorWatchDog");
        }
        catch (JPNotAvailableException | CouldNotPerformException ex) {
            throw new InitializationException((Object)this, ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.serverWatchDog.activate();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.serverWatchDog.deactivate();
    }

    public boolean isActive() {
        return this.remoteServer.isActive();
    }

    public void waitForActivation() throws CouldNotPerformException, InterruptedException {
        try {
            this.serverWatchDog.waitForServiceActivation();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not wait for activation!", (Throwable)ex);
        }
    }

    @Override
    public Future<TicketSessionKeyWrapperType.TicketSessionKeyWrapper> requestTicketGrantingTicket(String clientId) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)clientId, (RSBRemoteServer)this.remoteServer, TicketSessionKeyWrapperType.TicketSessionKeyWrapper.class);
    }

    @Override
    public Future<TicketSessionKeyWrapperType.TicketSessionKeyWrapper> requestClientServerTicket(TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)ticketAuthenticatorWrapper, (RSBRemoteServer)this.remoteServer, TicketSessionKeyWrapperType.TicketSessionKeyWrapper.class);
    }

    @Override
    public Future<TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper> validateClientServerTicket(TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)ticketAuthenticatorWrapper, (RSBRemoteServer)this.remoteServer, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.class);
    }

    @Override
    public Future<TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper> changeCredentials(LoginCredentialsChangeType.LoginCredentialsChange loginCredentialsChange) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)loginCredentialsChange, (RSBRemoteServer)this.remoteServer, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.class);
    }

    @Override
    public Future<TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper> register(LoginCredentialsChangeType.LoginCredentialsChange loginCredentialsChange) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)loginCredentialsChange, (RSBRemoteServer)this.remoteServer, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.class);
    }

    @Override
    public Future<TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper> removeUser(LoginCredentialsChangeType.LoginCredentialsChange loginCredentialsChange) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)loginCredentialsChange, (RSBRemoteServer)this.remoteServer, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.class);
    }

    @Override
    public Future<TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper> setAdministrator(LoginCredentialsChangeType.LoginCredentialsChange loginCredentialsChange) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)loginCredentialsChange, (RSBRemoteServer)this.remoteServer, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.class);
    }

    @Override
    public Future<AuthenticatedValueType.AuthenticatedValue> requestServiceServerSecretKey(TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)ticketAuthenticatorWrapper, (RSBRemoteServer)this.remoteServer, AuthenticatedValueType.AuthenticatedValue.class);
    }

    @Override
    public Future<Boolean> isAdmin(String userId) throws NotAvailableException, CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)userId, (RSBRemoteServer)this.remoteServer, Boolean.class);
    }

    @Override
    public Future<Boolean> hasUser(String userId) throws CouldNotPerformException {
        return RPCHelper.callRemoteServerMethod((Object)userId, (RSBRemoteServer)this.remoteServer, Boolean.class);
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)TicketSessionKeyWrapperType.TicketSessionKeyWrapper.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)LoginCredentialsChangeType.LoginCredentialsChange.getDefaultInstance()));
    }
}

