/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.EncryptionHelper;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import rst.domotic.authentication.AuthenticatorType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;
import rst.domotic.authentication.TicketSessionKeyWrapperType;
import rst.timing.TimestampType;

public class AuthenticationClientHandler {
    public static List<Object> handleKeyDistributionCenterResponse(String id, byte[] userKey, byte[] clientKey, TicketSessionKeyWrapperType.TicketSessionKeyWrapper wrapper) throws IOException, BadPaddingException {
        byte[] ticketGrantingServiceSessionKey = wrapper.getSessionKey().toByteArray();
        if (clientKey != null) {
            ticketGrantingServiceSessionKey = EncryptionHelper.decrypt(ticketGrantingServiceSessionKey, clientKey, byte[].class, false);
        }
        if (userKey != null) {
            ticketGrantingServiceSessionKey = EncryptionHelper.decrypt(ticketGrantingServiceSessionKey, userKey, byte[].class, true);
        }
        AuthenticatorType.Authenticator.Builder authenticator = AuthenticatorType.Authenticator.newBuilder();
        authenticator.setClientId(id);
        authenticator.setTimestamp(TimestampProcessor.getCurrentTimestamp());
        TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.Builder ticketAuthenticatorWrapper = TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.newBuilder();
        ticketAuthenticatorWrapper.setAuthenticator(EncryptionHelper.encryptSymmetric((Serializable)authenticator.build(), ticketGrantingServiceSessionKey));
        ticketAuthenticatorWrapper.setTicket(wrapper.getTicket());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(ticketAuthenticatorWrapper.build());
        list.add(ticketGrantingServiceSessionKey);
        return list;
    }

    public static List<Object> handleKeyDistributionCenterResponse(String id, byte[] key, boolean isUser, TicketSessionKeyWrapperType.TicketSessionKeyWrapper wrapper) throws IOException, BadPaddingException {
        if (isUser) {
            return AuthenticationClientHandler.handleKeyDistributionCenterResponse(id, key, null, wrapper);
        }
        return AuthenticationClientHandler.handleKeyDistributionCenterResponse(id, null, key, wrapper);
    }

    public static List<Object> handleTicketGrantingServiceResponse(String clientID, byte[] ticketGrantingServiceSessionKey, TicketSessionKeyWrapperType.TicketSessionKeyWrapper wrapper) throws IOException, BadPaddingException {
        byte[] SSSessionKey = EncryptionHelper.decryptSymmetric(wrapper.getSessionKey(), ticketGrantingServiceSessionKey, byte[].class);
        AuthenticatorType.Authenticator.Builder authenticator = AuthenticatorType.Authenticator.newBuilder();
        authenticator.setClientId(clientID);
        TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.Builder ticketAuthenticatorWrapper = TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.newBuilder();
        ticketAuthenticatorWrapper.setAuthenticator(EncryptionHelper.encryptSymmetric((Serializable)authenticator.build(), SSSessionKey));
        ticketAuthenticatorWrapper.setTicket(wrapper.getTicket());
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(ticketAuthenticatorWrapper.build());
        list.add(SSSessionKey);
        return list;
    }

    public static TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper initServiceServerRequest(byte[] serviceServerSessionKey, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper) throws IOException, BadPaddingException {
        AuthenticatorType.Authenticator.Builder authenticator = EncryptionHelper.decryptSymmetric(wrapper.getAuthenticator(), serviceServerSessionKey, AuthenticatorType.Authenticator.class).toBuilder();
        authenticator.setTimestamp(TimestampProcessor.getCurrentTimestamp());
        TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.Builder ticketAuthenticatorWrapper = wrapper.toBuilder();
        ticketAuthenticatorWrapper.setAuthenticator(EncryptionHelper.encryptSymmetric((Serializable)authenticator.build(), serviceServerSessionKey));
        return ticketAuthenticatorWrapper.build();
    }

    public static TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper handleServiceServerResponse(byte[] serviceServerSessionKey, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper lastWrapper, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper currentWrapper) throws RejectedException, IOException, BadPaddingException {
        AuthenticatorType.Authenticator lastAuthenticator = EncryptionHelper.decryptSymmetric(lastWrapper.getAuthenticator(), serviceServerSessionKey, AuthenticatorType.Authenticator.class);
        AuthenticatorType.Authenticator currentAuthenticator = EncryptionHelper.decryptSymmetric(currentWrapper.getAuthenticator(), serviceServerSessionKey, AuthenticatorType.Authenticator.class);
        AuthenticationClientHandler.validateTimestamp(lastAuthenticator.getTimestamp(), currentAuthenticator.getTimestamp());
        return currentWrapper;
    }

    public static void validateTimestamp(TimestampType.Timestamp now, TimestampType.Timestamp then) throws RejectedException {
        if (now.getTime() + 1L != then.getTime()) {
            throw new RejectedException("Timestamps do not match");
        }
    }
}

