/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.AuthenticatedServerManager;
import org.openbase.bco.authentication.lib.AuthenticationClientHandler;
import org.openbase.bco.authentication.lib.AuthorizationHelper;
import org.openbase.bco.authentication.lib.EncryptionHelper;
import org.openbase.bco.authentication.lib.SessionManager;
import org.openbase.bco.authentication.lib.future.AuthenticatedValueFuture;
import org.openbase.bco.authentication.lib.jp.JPAuthentication;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.PermissionDeniedException;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.authentication.AuthenticatedValueType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;
import rst.domotic.unit.UnitConfigType;

public class AuthenticatedServiceProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatedServiceProcessor.class);

    public static <RECEIVE extends GeneratedMessage, RETURN extends GeneratedMessage> AuthenticatedValueType.AuthenticatedValue authenticatedAction(AuthenticatedValueType.AuthenticatedValue authenticatedValue, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> authorizationGroupMap, Map<String, IdentifiableMessage<String, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>> locationMap, Class<RECEIVE> internalClass, InternalProcessable<RECEIVE, RETURN> executable, ConfigRetrieval<RECEIVE> configRetrieval) throws CouldNotPerformException, InterruptedException {
        try {
            AuthenticatedValueType.AuthenticatedValue.Builder response = AuthenticatedValueType.AuthenticatedValue.newBuilder();
            if (authenticatedValue.hasTicketAuthenticatorWrapper()) {
                try {
                    if (!((Boolean)((JPAuthentication)JPService.getProperty(JPAuthentication.class)).getValue()).booleanValue()) {
                        throw new CouldNotPerformException("Cannot execute authenticated action because authentication is disabled");
                    }
                }
                catch (JPNotAvailableException ex) {
                    throw new CouldNotPerformException("Could not check JPEnableAuthentication property", (Throwable)ex);
                }
                try {
                    AuthenticatedServerManager.TicketEvaluationWrapper ticketEvaluationWrapper = AuthenticatedServerManager.getInstance().evaluateClientServerTicket(authenticatedValue.getTicketAuthenticatorWrapper());
                    GeneratedMessage decrypted = (GeneratedMessage)EncryptionHelper.decryptSymmetric(authenticatedValue.getValue(), ticketEvaluationWrapper.getSessionKey(), internalClass);
                    UnitConfigType.UnitConfig unitConfig = configRetrieval.retrieve(decrypted);
                    if (!AuthorizationHelper.canWrite(unitConfig, ticketEvaluationWrapper.getUserId(), authorizationGroupMap, locationMap)) {
                        throw new PermissionDeniedException("User[" + ticketEvaluationWrapper.getUserId() + "] has not rights to register a unitConfig");
                    }
                    RETURN result = executable.process(decrypted);
                    response.setValue(EncryptionHelper.encryptSymmetric(result, ticketEvaluationWrapper.getSessionKey()));
                    response.setTicketAuthenticatorWrapper(ticketEvaluationWrapper.getTicketAuthenticatorWrapper());
                }
                catch (IOException | BadPaddingException ex) {
                    throw new CouldNotPerformException("Encryption/Decryption of internal value has failed", (Throwable)ex);
                }
            }
            try {
                Method parseFrom = internalClass.getMethod("parseFrom", ByteString.class);
                GeneratedMessage message = (GeneratedMessage)parseFrom.invoke(null, authenticatedValue.getValue());
                UnitConfigType.UnitConfig unitConfig = configRetrieval.retrieve(message);
                try {
                    if (((Boolean)((JPAuthentication)JPService.getProperty(JPAuthentication.class)).getValue()).booleanValue() && !AuthorizationHelper.canWrite(unitConfig, null, null, locationMap)) {
                        throw new PermissionDeniedException("Other has not rights to perform this action");
                    }
                }
                catch (JPNotAvailableException ex) {
                    throw new CouldNotPerformException("Could not check JPEnableAuthentication property", (Throwable)ex);
                }
                RETURN result = executable.process(message);
                response.setValue(result.toByteString());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new CouldNotPerformException("Could not invoke parseFrom method on [" + internalClass.getSimpleName() + "]", (Throwable)ex);
            }
            return response.build();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not execute authenticated action", (Throwable)ex);
        }
    }

    public static <SEND extends GeneratedMessage, RESPONSE extends GeneratedMessage> Future<RESPONSE> requestAuthenticatedAction(SEND message, Class<RESPONSE> responseClass, SessionManager sessionManager, InternalRequestable internalRequestable) throws CouldNotPerformException {
        if (sessionManager.isLoggedIn()) {
            sessionManager.isAuthenticated();
            try {
                try {
                    TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper = AuthenticationClientHandler.initServiceServerRequest(sessionManager.getSessionKey(), sessionManager.getTicketAuthenticatorWrapper());
                    AuthenticatedValueType.AuthenticatedValue.Builder authenticatedValue = AuthenticatedValueType.AuthenticatedValue.newBuilder();
                    authenticatedValue.setTicketAuthenticatorWrapper(ticketAuthenticatorWrapper);
                    try {
                        authenticatedValue.setValue(EncryptionHelper.encryptSymmetric(message, sessionManager.getSessionKey()));
                    }
                    catch (IOException ex) {
                        throw new CouldNotPerformException("Could not encrypt userConfig", (Throwable)ex);
                    }
                    Future<AuthenticatedValueType.AuthenticatedValue> future = internalRequestable.request(authenticatedValue.build());
                    return new AuthenticatedValueFuture<RESPONSE>(future, responseClass, ticketAuthenticatorWrapper, sessionManager);
                }
                catch (IOException | BadPaddingException ex) {
                    throw new CouldNotPerformException("Could not initialize service server request", (Throwable)ex);
                }
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Could not request authenticated Action!", (Throwable)ex);
            }
        }
        AuthenticatedValueType.AuthenticatedValue.Builder authenticateValue = AuthenticatedValueType.AuthenticatedValue.newBuilder();
        authenticateValue.setValue(message.toByteString());
        Future<AuthenticatedValueType.AuthenticatedValue> future = internalRequestable.request(authenticateValue.build());
        return new AuthenticatedValueFuture<RESPONSE>(future, responseClass, null, sessionManager);
    }

    public static interface ConfigRetrieval<M extends GeneratedMessage> {
        public UnitConfigType.UnitConfig retrieve(M var1) throws CouldNotPerformException;
    }

    public static interface InternalRequestable {
        public Future<AuthenticatedValueType.AuthenticatedValue> request(AuthenticatedValueType.AuthenticatedValue var1) throws CouldNotPerformException;
    }

    public static interface InternalProcessable<RECEIVE extends GeneratedMessage, RETURN extends GeneratedMessage> {
        public RETURN process(RECEIVE var1) throws CouldNotPerformException;
    }
}

