/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.authentication.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.crypto.BadPaddingException;
import org.openbase.bco.authentication.lib.AuthenticationClientHandler;
import org.openbase.bco.authentication.lib.AuthenticationServerHandler;
import org.openbase.bco.authentication.lib.CachedAuthenticationRemote;
import org.openbase.bco.authentication.lib.EncryptionHelper;
import org.openbase.bco.authentication.lib.jp.JPAuthentication;
import org.openbase.bco.authentication.lib.jp.JPCredentialsDirectory;
import org.openbase.bco.authentication.lib.jp.JPSessionTimeout;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.authentication.AuthenticatedValueType;
import rst.domotic.authentication.AuthenticatorType;
import rst.domotic.authentication.TicketAuthenticatorWrapperType;
import rst.domotic.authentication.TicketSessionKeyWrapperType;
import rst.domotic.authentication.TicketType;

public class AuthenticatedServerManager {
    public static final String SERVICE_SERVER_PRIVATE_KEY_FILENAME = "service_server_private_key";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatedServerManager.class);
    private byte[] serviceServerSecretKey;
    private static AuthenticatedServerManager instance;
    private TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper;
    private byte[] sessionKey;
    private final long ticketValidityTime;

    private AuthenticatedServerManager() throws CouldNotPerformException, InterruptedException {
        try {
            this.ticketValidityTime = (Long)((JPSessionTimeout)JPService.getProperty(JPSessionTimeout.class)).getValue();
            if (((Boolean)((JPAuthentication)JPService.getProperty(JPAuthentication.class)).getValue()).booleanValue()) {
                this.login();
                this.requestServiceServerSecretKey();
            }
        }
        catch (JPNotAvailableException ex) {
            throw new CouldNotPerformException("Could not check JPProperty", (Throwable)ex);
        }
    }

    public static synchronized AuthenticatedServerManager getInstance() throws CouldNotPerformException, InterruptedException {
        if (instance == null) {
            instance = new AuthenticatedServerManager();
        }
        return instance;
    }

    public static synchronized void shutdown() {
        instance = null;
    }

    public TicketEvaluationWrapper evaluateClientServerTicket(TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper wrapper) throws IOException, RejectedException {
        try {
            TicketType.Ticket clientServerTicket = EncryptionHelper.decryptSymmetric(wrapper.getTicket(), this.serviceServerSecretKey, TicketType.Ticket.class);
            AuthenticatorType.Authenticator authenticator = EncryptionHelper.decryptSymmetric(wrapper.getAuthenticator(), clientServerTicket.getSessionKeyBytes().toByteArray(), AuthenticatorType.Authenticator.class);
            AuthenticationServerHandler.validateTicket(clientServerTicket, authenticator);
            clientServerTicket = clientServerTicket.toBuilder().setValidityPeriod(AuthenticationServerHandler.getValidityInterval(this.ticketValidityTime)).build();
            AuthenticatorType.Authenticator.Builder authenticatorBuilder = authenticator.toBuilder();
            authenticatorBuilder.setTimestamp(authenticator.getTimestamp().toBuilder().setTime(authenticator.getTimestamp().getTime() + 1L));
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper.Builder response = wrapper.toBuilder();
            response.setTicket(EncryptionHelper.encryptSymmetric((Serializable)clientServerTicket, this.serviceServerSecretKey));
            response.setAuthenticator(EncryptionHelper.encryptSymmetric((Serializable)authenticatorBuilder.build(), clientServerTicket.getSessionKeyBytes().toByteArray()));
            return new TicketEvaluationWrapper(authenticator.getClientId(), clientServerTicket.getSessionKeyBytes().toByteArray(), response.build());
        }
        catch (IOException ex) {
            throw (IOException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
        catch (BadPaddingException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new RejectedException((Throwable)ex);
        }
        catch (RejectedException ex) {
            throw (RejectedException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
        }
    }

    private void login() throws CouldNotPerformException {
        try {
            byte[] key;
            File privateKeyFile = new File((File)((JPCredentialsDirectory)JPService.getProperty(JPCredentialsDirectory.class)).getValue(), SERVICE_SERVER_PRIVATE_KEY_FILENAME);
            try (FileInputStream inputStream = new FileInputStream(privateKeyFile);){
                key = new byte[(int)privateKeyFile.length()];
                inputStream.read(key);
            }
            String id = "@serviceServer";
            TicketSessionKeyWrapperType.TicketSessionKeyWrapper ticketSessionKeyWrapper = CachedAuthenticationRemote.getRemote().requestTicketGrantingTicket(id).get();
            List<Object> list = AuthenticationClientHandler.handleKeyDistributionCenterResponse(id, key, false, ticketSessionKeyWrapper);
            TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper taw = (TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper)list.get(0);
            byte[] ticketGrantingServiceSessionKey = (byte[])list.get(1);
            ticketSessionKeyWrapper = CachedAuthenticationRemote.getRemote().requestClientServerTicket(taw).get();
            list = AuthenticationClientHandler.handleTicketGrantingServiceResponse(id, ticketGrantingServiceSessionKey, ticketSessionKeyWrapper);
            this.ticketAuthenticatorWrapper = (TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper)list.get(0);
            this.sessionKey = (byte[])list.get(1);
        }
        catch (BadPaddingException ex) {
            throw new CouldNotPerformException("The local private key is wrong.");
        }
        catch (IOException | InterruptedException | ExecutionException | JPNotAvailableException | CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Login failed!", ex);
        }
    }

    private void requestServiceServerSecretKey() throws CouldNotPerformException, InterruptedException {
        try {
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.initServiceServerRequest(this.sessionKey, this.ticketAuthenticatorWrapper);
            AuthenticatedValueType.AuthenticatedValue value = CachedAuthenticationRemote.getRemote().requestServiceServerSecretKey(this.ticketAuthenticatorWrapper).get();
            this.ticketAuthenticatorWrapper = AuthenticationClientHandler.handleServiceServerResponse(this.sessionKey, this.ticketAuthenticatorWrapper, value.getTicketAuthenticatorWrapper());
            this.serviceServerSecretKey = EncryptionHelper.decryptSymmetric(value.getValue(), this.sessionKey, byte[].class);
        }
        catch (IOException | ExecutionException | BadPaddingException | RejectedException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)LOGGER, (LogLevel)LogLevel.ERROR);
            throw new CouldNotPerformException("Could not get the service server secret key.", ex);
        }
    }

    public byte[] getServiceServerSecretKey() {
        if (JPService.testMode()) {
            return this.serviceServerSecretKey;
        }
        return null;
    }

    public class TicketEvaluationWrapper {
        private final String userId;
        private final byte[] sessionKey;
        private final TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper;

        public TicketEvaluationWrapper(String userId, byte[] sessionKey, TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper ticketAuthenticatorWrapper) {
            this.userId = userId;
            this.sessionKey = sessionKey;
            this.ticketAuthenticatorWrapper = ticketAuthenticatorWrapper;
        }

        public String getUserId() {
            return this.userId;
        }

        public byte[] getSessionKey() {
            return this.sessionKey;
        }

        public TicketAuthenticatorWrapperType.TicketAuthenticatorWrapper getTicketAuthenticatorWrapper() {
            return this.ticketAuthenticatorWrapper;
        }
    }
}

