/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.templating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Jackson2Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.io.AbstractTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.api.AbstractTemplatingEngineAdapter;
import org.openapitools.codegen.api.TemplatingExecutor;
import org.openapitools.codegen.templating.TemplateNotFoundException;
import org.openapitools.codegen.templating.handlebars.StringHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlebarsEngineAdapter
extends AbstractTemplatingEngineAdapter {
    static final Logger LOGGER = LoggerFactory.getLogger(HandlebarsEngineAdapter.class);
    private final String[] extensions = new String[]{"handlebars", "hbs"};
    private final String[] canCompileFromExtensions = new String[]{".handlebars", ".hbs", ".mustache"};

    public String getIdentifier() {
        return "handlebars";
    }

    public String compileTemplate(final TemplatingExecutor executor, Map<String, Object> bundle, String templateFile) throws IOException {
        AbstractTemplateLoader loader = new AbstractTemplateLoader(){

            public TemplateSource sourceAt(String location) {
                return HandlebarsEngineAdapter.this.findTemplate(executor, location);
            }
        };
        Context context = Context.newBuilder(bundle).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE}).build();
        Handlebars handlebars = new Handlebars((TemplateLoader)loader);
        handlebars.registerHelperMissing((obj, options) -> {
            LOGGER.warn(String.format(Locale.ROOT, "Unregistered helper name '%s', processing template:%n%s", options.helperName, options.fn.text()));
            return "";
        });
        handlebars.registerHelper("json", Jackson2Helper.INSTANCE);
        com.github.jknack.handlebars.helper.StringHelpers.register((Handlebars)handlebars);
        handlebars.registerHelpers(ConditionalHelpers.class);
        handlebars.registerHelpers(StringHelpers.class);
        Template tmpl = handlebars.compile(templateFile);
        return tmpl.apply(context);
    }

    public TemplateSource findTemplate(TemplatingExecutor generator, String templateFile) {
        CharSequence[] possibilities;
        for (String string : possibilities = this.getModifiedFileLocation(templateFile)) {
            try {
                return new StringTemplateSource(string, generator.getFullTemplateContents(string));
            }
            catch (Exception exception) {
            }
        }
        try {
            return new StringTemplateSource(templateFile, generator.getFullTemplateContents(templateFile));
        }
        catch (Exception exception) {
            throw new TemplateNotFoundException(String.join((CharSequence)", ", possibilities));
        }
    }

    public String[] getFileExtensions() {
        return this.extensions;
    }

    public boolean handlesFile(String filename) {
        return Arrays.stream(this.canCompileFromExtensions).anyMatch(suffix -> !suffix.equalsIgnoreCase(filename) && filename.endsWith((String)suffix));
    }
}

