/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;

class DryRunStatus {
    private Path path;
    private State state;
    private String reason;

    public DryRunStatus(Path path) {
        this(path, State.Write);
    }

    public DryRunStatus(Path path, State state) {
        this.path = path;
        this.setState(state);
    }

    public DryRunStatus(Path path, State state, String reason) {
        this.path = path;
        this.state = state;
        this.reason = reason;
    }

    public void appendTo(Appendable appendable) throws IOException {
        appendable.append(String.format(Locale.ROOT, "%s %s", this.state.getShortDisplay(), this.path.toAbsolutePath()));
    }

    public Path getPath() {
        return this.path;
    }

    public String getReason() {
        return this.reason;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (state != this.state) {
            switch (state) {
                case Write: {
                    this.reason = "File will be written.";
                    break;
                }
                case WriteIfNewer: {
                    this.reason = "File will be written only if it is new or if contents differ from an existing file.";
                    break;
                }
                case Ignored: {
                    this.reason = "Ignored via rules defined in codegen ignore file.";
                    break;
                }
                case SkippedOverwrite: {
                    this.reason = "File is configured not to overwrite an existing file of the same name.";
                    break;
                }
                case Error: {
                    this.reason = "File error: template does not exist, or file is not accessible.";
                }
            }
        }
        this.state = state;
    }

    static enum State {
        Write("w", "Write"),
        WriteIfNewer("n", "Write if New/Updated"),
        Ignored("i", "Ignored"),
        SkippedOverwrite("s", "Skipped Overwrite"),
        Skipped("k", "Skipped by user option(s)"),
        Error("e", "Error evaluating file write state");

        private final String shortDisplay;
        private final String description;

        private State(String shortDisplay, String description) {
            this.shortDisplay = shortDisplay;
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String getShortDisplay() {
            return this.shortDisplay;
        }
    }
}

