/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaJAXRSServerCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures {
    public static final String SERVER_PORT = "serverPort";
    protected static final String JAXRS_TEMPLATE_DIRECTORY_NAME = "JavaJaxRS";
    protected String implFolder = "src/main/java";
    protected String testResourcesFolder = "src/test/resources";
    protected String title = "OpenAPI Server";
    protected String serverPort = "8080";
    protected boolean useBeanValidation = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJavaJAXRSServerCodegen.class);

    public AbstractJavaJAXRSServerCodegen() {
        this.sourceFolder = "src/gen/java";
        this.invokerPackage = "org.openapitools.api";
        this.artifactId = "openapi-jaxrs-server";
        this.dateLibrary = "legacy";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.updateOption("dateLibrary", this.getDateLibrary());
        this.additionalProperties.put("title", this.title);
        this.additionalProperties.put("jackson", "true");
        this.cliOptions.add(new CliOption("implFolder", "folder for generated implementation code").defaultValue(this.implFolder));
        this.cliOptions.add(new CliOption("title", "a title describing the application").defaultValue(this.title));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations", this.useBeanValidation));
        this.cliOptions.add(new CliOption(SERVER_PORT, "The port on which the server should be started").defaultValue(this.serverPort));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("implFolder")) {
            this.implFolder = (String)this.additionalProperties.get("implFolder");
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(SERVER_PORT)) {
            URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
            this.additionalProperties.put(SERVER_PORT, URLPathUtils.getPort(url, this.serverPort));
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem path = (PathItem)openAPI.getPaths().get((Object)pathname);
                if (path.readOperations() == null) continue;
                for (Operation operation : path.readOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        value.put("hasMore", "true");
                        tags.add(value);
                    }
                    if (tags.size() > 0) {
                        ((Map)tags.get(tags.size() - 1)).remove("hasMore");
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.addExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        return AbstractJavaJAXRSServerCodegen.jaxrsPostProcessOperations(objs);
    }

    static Map<String, Object> jaxrsPostProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            String commonBaseName = null;
            boolean baseNameEquals = true;
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                Map<String, String> firstType;
                if (operation.hasConsumes == Boolean.TRUE && (firstType = operation.consumes.get(0)) != null && "multipart/form-data".equals(firstType.get("mediaType"))) {
                    operation.isMultipart = Boolean.TRUE;
                }
                boolean isMultipartPost = false;
                List<Map<String, String>> consumes = operation.consumes;
                if (consumes != null) {
                    for (Map map : consumes) {
                        String mt = (String)map.get("mediaType");
                        if (mt == null || !mt.startsWith("multipart/form-data")) continue;
                        isMultipartPost = true;
                    }
                }
                for (CodegenParameter codegenParameter : operation.allParams) {
                    if (!isMultipartPost) continue;
                    codegenParameter.vendorExtensions.put("x-multipart", "true");
                }
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (CodegenResponse resp : responses) {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        if (resp.baseType == null) {
                            resp.dataType = "void";
                            resp.baseType = "Void";
                            resp.vendorExtensions.put("x-java-is-response-void", true);
                        }
                        if ("array".equals(resp.containerType)) {
                            resp.containerType = "List";
                            continue;
                        }
                        if ("set".equals(resp.containerType)) {
                            resp.containerType = "Set";
                            continue;
                        }
                        if (!"map".equals(resp.containerType)) continue;
                        resp.containerType = "Map";
                    }
                }
                if (operation.returnBaseType == null) {
                    operation.returnType = "void";
                    operation.returnBaseType = "Void";
                    operation.vendorExtensions.put("x-java-is-response-void", true);
                }
                if ("array".equals(operation.returnContainer)) {
                    operation.returnContainer = "List";
                } else if ("set".equals(operation.returnContainer)) {
                    operation.returnContainer = "Set";
                } else if ("map".equals(operation.returnContainer)) {
                    operation.returnContainer = "Map";
                }
                if (commonBaseName == null) {
                    commonBaseName = operation.baseName;
                    continue;
                }
                if (commonBaseName.equals(operation.baseName)) continue;
                baseNameEquals = false;
            }
            if (baseNameEquals) {
                objs.put("commonPath", commonBaseName);
            } else {
                for (CodegenOperation operation : ops) {
                    if (operation.baseName == null) continue;
                    operation.path = "/" + operation.baseName + operation.path;
                    operation.baseName = null;
                }
                objs.put("commonPath", null);
            }
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        String computed = name;
        if (computed.length() > 0) {
            computed = this.sanitizeName(computed);
        }
        return super.toApiName(computed);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("Impl.mustache")) {
            int ix = result.lastIndexOf(File.separator);
            result = result.substring(0, ix) + "/impl" + result.substring(ix, result.length() - 5) + "ServiceImpl.java";
            result = result.replace(this.apiFileFolder(), this.implFileFolder(this.implFolder));
        } else if (templateName.endsWith("Factory.mustache")) {
            int ix = result.lastIndexOf(File.separator);
            result = result.substring(0, ix) + "/factories" + result.substring(ix, result.length() - 5) + "ServiceFactory.java";
            result = result.replace(this.apiFileFolder(), this.implFileFolder(this.implFolder));
        } else if (templateName.endsWith("Service.mustache")) {
            int ix = result.lastIndexOf(46);
            result = result.substring(0, ix) + "Service.java";
        }
        return result;
    }

    private String implFileFolder(String output) {
        return this.outputFolder + "/" + output + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }
}

