/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;

public class ClojureClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final String PROJECT_NAME = "projectName";
    private static final String PROJECT_DESCRIPTION = "projectDescription";
    private static final String PROJECT_VERSION = "projectVersion";
    private static final String PROJECT_URL = "projectUrl";
    private static final String PROJECT_LICENSE_NAME = "projectLicenseName";
    private static final String PROJECT_LICENSE_URL = "projectLicenseUrl";
    private static final String BASE_NAMESPACE = "baseNamespace";
    static final String X_BASE_SPEC = "x-baseSpec";
    static final String X_MODELS = "x-models";
    protected String projectName;
    protected String projectDescription;
    protected String projectVersion;
    protected String baseNamespace;
    protected Set<String> baseSpecs;
    protected Set<String> models = new HashSet<String>();
    protected String sourceFolder = "src";

    public ClojureClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "clojure";
        this.modelTemplateFiles.put("spec.mustache", ".clj");
        this.apiTemplateFiles.put("api.mustache", ".clj");
        this.templateDir = "clojure";
        this.embeddedTemplateDir = "clojure";
        this.cliOptions.add(new CliOption(PROJECT_NAME, "name of the project (Default: generated from info.title or \"openapi-clj-client\")"));
        this.cliOptions.add(new CliOption(PROJECT_DESCRIPTION, "description of the project (Default: using info.description or \"Client library of <projectName>\")"));
        this.cliOptions.add(new CliOption(PROJECT_VERSION, "version of the project (Default: using info.version or \"1.0.0\")"));
        this.cliOptions.add(new CliOption(PROJECT_URL, "URL of the project (Default: using info.contact.url or not included in project.clj)"));
        this.cliOptions.add(new CliOption(PROJECT_LICENSE_NAME, "name of the license the project uses (Default: using info.license.name or not included in project.clj)"));
        this.cliOptions.add(new CliOption(PROJECT_LICENSE_URL, "URL of the license the project uses (Default: using info.license.url or not included in project.clj)"));
        this.cliOptions.add(new CliOption(BASE_NAMESPACE, "the base/top namespace (Default: generated from projectName)"));
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int?");
        this.typeMapping.put("long", "int?");
        this.typeMapping.put("short", "int?");
        this.typeMapping.put("number", "float?");
        this.typeMapping.put("float", "float?");
        this.typeMapping.put("double", "float?");
        this.typeMapping.put("array", "list?");
        this.typeMapping.put("map", "map?");
        this.typeMapping.put("boolean", "boolean?");
        this.typeMapping.put("string", "string?");
        this.typeMapping.put("char", "char?");
        this.typeMapping.put("date", "inst?");
        this.typeMapping.put("DateTime", "inst?");
        this.typeMapping.put("UUID", "uuid?");
        this.typeMapping.put("URI", "string?");
        this.typeMapping.put("object", "any?");
        this.typeMapping.put("file", "any?");
        this.typeMapping.put("binary", "any?");
        this.typeMapping.put("ByteArray", "any?");
        this.baseSpecs = new HashSet<String>(Arrays.asList("int?", "float?", "list?", "map?", "boolean?", "string?", "char?", "inst?", "uuid?", "any?"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "clojure";
    }

    @Override
    public String getHelp() {
        return "Generates a Clojure client library.";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (p instanceof ArraySchema) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "(s/coll-of " + this.getTypeDeclaration(inner) + ")";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return "(s/map-of string? " + this.getTypeDeclaration(inner) + ")";
        }
        if (!this.typeMapping.containsKey(super.getSchemaType(p))) {
            return super.getTypeDeclaration(p) + "-spec";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.dashize(name);
    }

    @Override
    public CodegenModel fromModel(String name, Schema mod) {
        CodegenModel model = super.fromModel(name, mod);
        for (CodegenProperty var : model.vars) {
            if (this.baseSpecs.contains(var.complexType)) {
                var.vendorExtensions.put(X_BASE_SPEC, true);
            } else {
                var.vendorExtensions.put(X_BASE_SPEC, false);
            }
            if (var.items == null) continue;
            if (this.baseSpecs.contains(var.items.complexType)) {
                var.items.vendorExtensions.put(X_BASE_SPEC, true);
                continue;
            }
            var.items.vendorExtensions.put(X_BASE_SPEC, false);
        }
        this.models.add(model.classname);
        return model;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (this.additionalProperties.containsKey(PROJECT_NAME)) {
            this.projectName = (String)this.additionalProperties.get(PROJECT_NAME);
        }
        if (this.additionalProperties.containsKey(PROJECT_DESCRIPTION)) {
            this.projectDescription = (String)this.additionalProperties.get(PROJECT_DESCRIPTION);
        }
        if (this.additionalProperties.containsKey(PROJECT_VERSION)) {
            this.projectVersion = (String)this.additionalProperties.get(PROJECT_VERSION);
        }
        if (this.additionalProperties.containsKey(BASE_NAMESPACE)) {
            this.baseNamespace = (String)this.additionalProperties.get(BASE_NAMESPACE);
        }
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (this.projectName == null && info.getTitle() != null) {
                this.projectName = StringUtils.dashize(info.getTitle());
            }
            if (this.projectVersion == null) {
                this.projectVersion = info.getVersion();
            }
            if (this.projectDescription == null) {
                this.projectDescription = info.getDescription();
            }
            if (info.getContact() != null) {
                Contact contact = info.getContact();
                if (this.additionalProperties.get(PROJECT_URL) == null) {
                    this.additionalProperties.put(PROJECT_URL, contact.getUrl());
                }
            }
            if (info.getLicense() != null) {
                License license = info.getLicense();
                if (this.additionalProperties.get(PROJECT_LICENSE_NAME) == null) {
                    this.additionalProperties.put(PROJECT_LICENSE_NAME, license.getName());
                }
                if (this.additionalProperties.get(PROJECT_LICENSE_URL) == null) {
                    this.additionalProperties.put(PROJECT_LICENSE_URL, license.getUrl());
                }
            }
        }
        if (this.projectName == null) {
            this.projectName = "openapi-clj-client";
        }
        if (this.projectVersion == null) {
            this.projectVersion = "1.0.0";
        }
        if (this.projectDescription == null) {
            this.projectDescription = "Client library of " + this.projectName;
        }
        if (this.baseNamespace == null) {
            this.baseNamespace = StringUtils.dashize(this.projectName);
        }
        this.apiPackage = this.baseNamespace + ".api";
        this.modelPackage = this.baseNamespace + ".specs";
        this.additionalProperties.put(PROJECT_NAME, this.projectName);
        this.additionalProperties.put(PROJECT_DESCRIPTION, this.escapeText(this.projectDescription));
        this.additionalProperties.put(PROJECT_VERSION, this.projectVersion);
        this.additionalProperties.put(BASE_NAMESPACE, this.baseNamespace);
        this.additionalProperties.put("apiPackage", this.apiPackage);
        this.additionalProperties.put("modelPackage", this.modelPackage);
        String baseNamespaceFolder = this.sourceFolder + File.separator + this.namespaceToFolder(this.baseNamespace);
        this.supportingFiles.add(new SupportingFile("project.mustache", "", "project.clj"));
        this.supportingFiles.add(new SupportingFile("core.mustache", baseNamespaceFolder, "core.clj"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
    }

    @Override
    public String sanitizeTag(String tag) {
        return tag.replaceAll("[^a-zA-Z_]+", "_");
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.namespaceToFolder(this.apiPackage);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.namespaceToFolder(this.modelPackage);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method/operation name (operationId) not allowed");
        }
        return StringUtils.dashize(this.sanitizeName(operationId));
    }

    @Override
    public String toApiFilename(String name) {
        return StringUtils.underscore(this.toApiName(name));
    }

    @Override
    public String toModelFilename(String name) {
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toApiName(String name) {
        return StringUtils.dashize(name);
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        name = name.replaceAll("[^a-zA-Z0-9_-]+", "");
        return name;
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return null;
        }
        return input.trim().replace("\\", "\\\\").replace("\"", "\\\"");
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> allModels) {
        Map objs = (Map)operations.get("operations");
        List ops = (List)objs.get("operation");
        for (CodegenOperation op : ops) {
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
            op.vendorExtensions.put(X_MODELS, this.models);
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
        }
        return operations;
    }

    protected String namespaceToFolder(String ns) {
        return ns.replace(".", File.separator).replace("-", "_");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("(comment", "(_comment");
    }
}

