/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.templating.mustache.IndentedLambda;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCppCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCppCodegen.class);

    public AbstractCppCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("alignas", "alignof", "and", "and_eq", "asm", "auto", "bitand", "bitor", "bool", "break", "case", "catch", "char", "char16_t", "char32_t", "class", "compl", "concept", "const", "constexpr", "const_cast", "continue", "decltype", "default", "delete", "do", "double", "dynamic_cast", "else", "enum", "explicit", "export", "extern", "false", "float", "for", "friend", "goto", "if", "inline", "int", "linux", "long", "mutable", "namespace", "new", "noexcept", "not", "not_eq", "nullptr", "operator", "or", "or_eq", "private", "protected", "public", "register", "reinterpret_cast", "requires", "return", "short", "signed", "sizeof", "static", "static_assert", "static_cast", "struct", "switch", "template", "this", "thread_local", "throw", "true", "try", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "void", "volatile", "wchar_t", "while", "xor", "xor_eq"));
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String toApiName(String type) {
        return this.sanitizeName(this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api");
    }

    @Override
    public String toModelName(String type) {
        if (type == null) {
            LOGGER.warn("Model name can't be null. Default to 'UnknownModel'.");
            type = "UnknownModel";
        }
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return this.sanitizeName(this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1));
    }

    @Override
    public String toVarName(String name) {
        if (this.typeMapping.keySet().contains(name) || this.typeMapping.values().contains(name) || this.importMapping.values().contains(name) || this.defaultIncludes.contains(name) || this.languageSpecificPrimitives.contains(name)) {
            return this.sanitizeName(name);
        }
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            return this.escapeReservedWord(name);
        }
        if (name.length() > 1) {
            return this.sanitizeName(Character.toUpperCase(name.charAt(0)) + name.substring(1));
        }
        return this.sanitizeName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return this.sanitizeName("_" + name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + this.escapeReservedWord(operationId));
            return this.escapeReservedWord(operationId);
        }
        return this.sanitizeName(super.toOperationId(operationId));
    }

    @Override
    public String toParamName(String name) {
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            return this.escapeReservedWord(name);
        }
        return this.sanitizeName(super.toParamName(name));
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty property = super.fromProperty(name, p);
        String nameInCamelCase = property.nameInCamelCase;
        nameInCamelCase = nameInCamelCase.length() > 1 ? this.sanitizeName(Character.toLowerCase(nameInCamelCase.charAt(0)) + nameInCamelCase.substring(1)) : this.sanitizeName(nameInCamelCase);
        if (this.isReservedWord(nameInCamelCase) || nameInCamelCase.matches("^\\d.*")) {
            nameInCamelCase = this.escapeReservedWord(nameInCamelCase);
        }
        property.nameInCamelCase = nameInCamelCase;
        return property;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "is" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String getTypeDeclaration(String str) {
        return "std::shared_ptr<" + this.toModelName(str) + ">";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isEmpty((CharSequence)System.getenv("CPP_POST_PROCESS_FILE"))) {
            LOGGER.info("Environment variable CPP_POST_PROCESS_FILE not defined so the C++ code may not be properly formatted. To define it, try 'export CPP_POST_PROCESS_FILE=\"/usr/local/bin/clang-format -i\"' (Linux/Mac)");
            LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        this.addMustacheLambdas(this.additionalProperties);
    }

    private void addMustacheLambdas(Map<String, Object> objs) {
        ImmutableMap lambdas = new ImmutableMap.Builder().put((Object)"multiline_comment_4", (Object)new IndentedLambda(4, " ", "///")).build();
        if (objs.containsKey("lambda")) {
            LOGGER.warn("A property named 'lambda' already exists. Mustache lambdas renamed from 'lambda' to '_lambda'.");
            objs.put("_lambda", lambdas);
        } else {
            objs.put("lambda", lambdas);
        }
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String cppPostProcessFile = System.getenv("CPP_POST_PROCESS_FILE");
        if (StringUtils.isEmpty((CharSequence)cppPostProcessFile)) {
            return;
        }
        if ("cpp".equals(FilenameUtils.getExtension((String)file.toString())) || "h".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = cppPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                p.waitFor();
                int exitValue = p.exitValue();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        URL url = URLPathUtils.getServerURL(openAPI);
        String port = URLPathUtils.getPort(url, "");
        String host = url.getHost();
        if (!port.isEmpty()) {
            this.additionalProperties.put("serverPort", port);
        }
        if (!host.isEmpty()) {
            this.additionalProperties.put("serverHost", host);
        }
    }
}

