/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;

public class JavaJerseyServerCodegen
extends AbstractJavaJAXRSServerCodegen {
    protected static final String LIBRARY_JERSEY1 = "jersey1";
    protected static final String LIBRARY_JERSEY2 = "jersey2";
    public static final String DEFAULT_JERSEY_LIBRARY = "jersey2";
    public static final String USE_TAGS = "useTags";
    protected boolean useTags = false;

    public JavaJerseyServerCodegen() {
        this.outputFolder = "generated-code/JavaJaxRS-Jersey";
        this.apiTemplateFiles.put("apiService.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.apiTemplateFiles.put("apiServiceFactory.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.templateDir = "JavaJaxRS";
        this.embeddedTemplateDir = "JavaJaxRS";
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        this.supportedLibraries.put(LIBRARY_JERSEY1, "Jersey core 1.x");
        this.supportedLibraries.put("jersey2", "Jersey core 2.x");
        library.setEnum(this.supportedLibraries);
        library.setDefault("jersey2");
        this.cliOptions.add(library);
        this.cliOptions.add(CliOption.newBoolean("supportJava6", "Whether to support Java6 with the Jersey1/2 library."));
        this.cliOptions.add(CliOption.newBoolean(USE_TAGS, "use tags for creating interface and controller classnames"));
    }

    @Override
    public String getName() {
        return "jaxrs-jersey";
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS Server application based on Jersey framework.";
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!BooleanUtils.toBoolean((Boolean)model.isEnum)) {
            model.imports.add("JsonProperty");
            if (BooleanUtils.toBoolean((Boolean)model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (StringUtils.isEmpty((CharSequence)this.library)) {
            this.setLibrary("jersey2");
        }
        if (this.additionalProperties.containsKey("implFolder")) {
            this.implFolder = (String)this.additionalProperties.get("implFolder");
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(Boolean.valueOf(this.additionalProperties.get(USE_TAGS).toString()));
        }
        if ("joda".equals(this.dateLibrary)) {
            this.supportingFiles.add(new SupportingFile("JodaDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("JodaLocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JodaLocalDateProvider.java"));
        } else if (this.dateLibrary.startsWith("java8")) {
            this.supportingFiles.add(new SupportingFile("OffsetDateTimeProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "OffsetDateTimeProvider.java"));
            this.supportingFiles.add(new SupportingFile("LocalDateProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "LocalDateProvider.java"));
        }
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiException.java"));
        this.supportingFiles.add(new SupportingFile("ApiOriginFilter.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiOriginFilter.java"));
        this.supportingFiles.add(new SupportingFile("ApiResponseMessage.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "ApiResponseMessage.java"));
        this.supportingFiles.add(new SupportingFile("NotFoundException.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "NotFoundException.java"));
        this.supportingFiles.add(new SupportingFile("jacksonJsonProvider.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "JacksonJsonProvider.java"));
        this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "RFC3339DateFormat.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("bootstrap.mustache", (this.implFolder + '/' + this.apiPackage).replace(".", "/"), "Bootstrap.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        this.supportingFiles.add(new SupportingFile("StringUtil.mustache", (this.sourceFolder + '/' + this.apiPackage).replace(".", "/"), "StringUtil.java"));
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List imports = (List)objs.get("imports");
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.useTags) {
            boolean pathStartsWithBasePath;
            int pos;
            String basePath = tag.toLowerCase(Locale.ROOT);
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (pathStartsWithBasePath = co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
            super.addOperationToGroup(tag, resourcePath, operation, co, operations);
            co.baseName = pathStartsWithBasePath ? basePath : null;
        } else {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (StringUtils.isEmpty((CharSequence)basePath)) {
                basePath = "default";
            } else {
                if (co.path.startsWith("/" + basePath)) {
                    co.path = co.path.substring(("/" + basePath).length());
                }
                co.subresourceOperation = !co.path.isEmpty();
            }
            List<CodegenOperation> opList = operations.get(basePath);
            if (opList == null || opList.isEmpty()) {
                opList = new ArrayList<CodegenOperation>();
                operations.put(basePath, opList);
            }
            opList.add(co);
            co.baseName = basePath;
        }
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }
}

