/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen;

import java.util.Set;

public class SpecValidationException
extends RuntimeException {
    private Set<String> errors;
    private Set<String> warnings;

    public SpecValidationException() {
    }

    public SpecValidationException(String message) {
        super(message);
    }

    public SpecValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public SpecValidationException(Throwable cause) {
        super(cause);
    }

    public SpecValidationException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public Set<String> getErrors() {
        return this.errors;
    }

    public Set<String> getWarnings() {
        return this.warnings;
    }

    public void setErrors(Set<String> errors) {
        this.errors = errors;
    }

    public void setWarnings(Set<String> warnings) {
        this.warnings = warnings;
    }

    @Override
    public String getMessage() {
        int errorCount = 0;
        if (this.errors != null) {
            errorCount = this.errors.size();
        }
        int warningCount = 0;
        if (this.warnings != null) {
            warningCount = this.warnings.size();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator()).append("Errors: ").append(System.lineSeparator());
        this.errors.forEach(msg -> sb.append("\t-").append((String)msg).append(System.lineSeparator()));
        if (!this.warnings.isEmpty()) {
            sb.append("Warnings: ").append(System.lineSeparator());
            this.warnings.forEach(msg -> sb.append("\t-").append((String)msg).append(System.lineSeparator()));
        }
        return super.getMessage() + " | Error count: " + errorCount + ", Warning count: " + warningCount + sb.toString();
    }
}

