/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;

public class PhpLumenServerCodegen
extends AbstractPhpCodegen {
    protected String apiVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-lumen";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Lumen server library.";
    }

    public PhpLumenServerCodegen() {
        this.templateDir = "lumen";
        this.embeddedTemplateDir = "lumen";
        this.invokerPackage = "lumen";
        this.apiPackage = "app.Http.Controllers";
        this.modelPackage = "models";
        this.modelTemplateFiles.clear();
        this.apiTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("composer.mustache", this.srcBasePath, "composer.json"));
        this.supportingFiles.add(new SupportingFile("readme.md", this.srcBasePath, "readme.md"));
        this.supportingFiles.add(new SupportingFile("app.php", this.srcBasePath + File.separator + "bootstrap", "app.php"));
        this.supportingFiles.add(new SupportingFile("index.php", this.srcBasePath + File.separator + "public", "index.php"));
        this.supportingFiles.add(new SupportingFile("User.php", this.srcBasePath + File.separator + "app", "User.php"));
        this.supportingFiles.add(new SupportingFile("Kernel.php", this.srcBasePath + File.separator + "app" + File.separator + "Console", "Kernel.php"));
        this.supportingFiles.add(new SupportingFile("Handler.php", this.srcBasePath + File.separator + "app" + File.separator + "Exceptions", "Handler.php"));
        this.supportingFiles.add(new SupportingFile("routes.mustache", this.srcBasePath + File.separator + "app" + File.separator + "Http", "routes.php"));
        this.supportingFiles.add(new SupportingFile("Controller.php", this.srcBasePath + File.separator + "app" + File.separator + "Http" + File.separator + "Controllers" + File.separator, "Controller.php"));
        this.supportingFiles.add(new SupportingFile("Authenticate.php", this.srcBasePath + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware" + File.separator, "Authenticate.php"));
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation op : operations) {
            op.httpMethod = op.httpMethod.toLowerCase();
            if (op.path == null || !op.path.contains(".")) continue;
            throw new IllegalArgumentException("'.' (dot) is not supported by PHP Lumen.");
        }
        Collections.sort(operations, new Comparator<CodegenOperation>(){

            @Override
            public int compare(CodegenOperation lhs, CodegenOperation rhs) {
                return lhs.path.compareTo(rhs.path);
            }
        });
        this.escapeMediaType(operations);
        return objs;
    }
}

