/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.online.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Date;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class OpenAPIDocumentationConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(OpenAPIDocumentationConfig.class);

    ApiInfo apiInfo() {
        Properties properties = new Properties();
        try (InputStream stream2 = this.getClass().getResourceAsStream("/version.properties");){
            if (stream2 != null) {
                properties.load(stream2);
            }
        }
        catch (IOException stream2) {
            // empty catch block
        }
        String version = properties.getProperty("version", "unknown");
        return new ApiInfoBuilder().title("OpenAPI Generator Online").description("This is an online openapi generator server.  You can find out more at https://github.com/OpenAPITools/openapi-generator.").license("Apache 2.0").licenseUrl("https://www.apache.org/licenses/LICENSE-2.0.html").termsOfServiceUrl("").version(version).contact(new Contact("", "", "")).build();
    }

    @Bean
    public Docket customImplementation() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.basePackage((String)"org.openapitools.codegen.online.api")).build().forCodeGeneration(true).directModelSubstitute(LocalDate.class, Date.class).directModelSubstitute(OffsetDateTime.class, java.util.Date.class).directModelSubstitute(JsonNode.class, Object.class).ignoredParameterTypes(new Class[]{Resource.class}).ignoredParameterTypes(new Class[]{InputStream.class}).apiInfo(this.apiInfo());
        String hostString = System.getenv("GENERATOR_HOST");
        if (!StringUtils.isBlank((CharSequence)hostString)) {
            try {
                String authority;
                URI hostURI = new URI(hostString);
                String scheme = hostURI.getScheme();
                if (scheme != null) {
                    HashSet<String> protocols = new HashSet<String>();
                    protocols.add(scheme);
                    docket.protocols(protocols);
                }
                if ((authority = hostURI.getAuthority()) != null) {
                    docket.host(authority);
                }
                docket.pathMapping(hostURI.getPath());
            }
            catch (URISyntaxException e) {
                this.LOGGER.warn("Could not parse configured GENERATOR_HOST '" + hostString + "': " + e.getMessage());
            }
        }
        return docket;
    }
}

