/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MinItemsValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1016), "Min items is '%s', found '%s'.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("minItems", true);
    private final Integer min;

    MinItemsValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.min = schemaNode.isIntegralNumber() ? Integer.valueOf(schemaNode.intValue()) : null;
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (this.min == null || !valueNode.isArray()) {
            return false;
        }
        if (valueNode.size() < this.min) {
            validation.add(CRUMB_INFO, ERR, this.min, valueNode.size());
        }
        return false;
    }
}

