/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MaxLengthValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1012), "Max length is '%s', found '%s'.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("maxLength", true);
    private final Integer maxLength;

    MaxLengthValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.maxLength = schemaNode.isIntegralNumber() ? Integer.valueOf(schemaNode.intValue()) : null;
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (this.maxLength == null || !valueNode.isTextual()) {
            return false;
        }
        String value = valueNode.textValue();
        int length = value.codePointCount(0, value.length());
        if (length > this.maxLength) {
            validation.add(CRUMB_INFO, ERR, this.maxLength, length);
        }
        return false;
    }
}

