/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.validation;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.operation.validator.model.Request;
import org.openapi4j.operation.validator.model.impl.Body;
import org.openapi4j.operation.validator.model.impl.MediaTypeContainer;
import org.openapi4j.operation.validator.util.PathResolver;
import org.openapi4j.operation.validator.util.convert.ParameterConverter;
import org.openapi4j.operation.validator.validation.BodyValidator;
import org.openapi4j.operation.validator.validation.ParameterValidator;
import org.openapi4j.parser.model.AbsRefOpenApiSchema;
import org.openapi4j.parser.model.v3.Callback;
import org.openapi4j.parser.model.v3.Header;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.parser.model.v3.RequestBody;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;

public class OperationValidator {
    private static final String VALIDATION_CTX_REQUIRED_ERR_MSG = "Validation context is required.";
    private static final String PATH_REQUIRED_ERR_MSG = "Path is required.";
    private static final String OPERATION_REQUIRED_ERR_MSG = "Operation is required.";
    private static final ValidationResult BODY_REQUIRED_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(200), "Body is required but none provided.");
    private static final ValidationResult BODY_CONTENT_TYPE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(202), "Body content type cannot be determined. No 'Content-Type' header available.");
    private static final ValidationResult BODY_WRONG_CONTENT_TYPE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(203), "Content type '%s' is not allowed for body content.");
    private static final ValidationResult PATH_NOT_FOUND_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(205), "Path template '%s' has not been found from value '%s'.");
    private static final String IN_PATH = "path";
    private static final String IN_QUERY = "query";
    private static final String IN_HEADER = "header";
    private static final String IN_COOKIE = "cookie";
    private static final String DEFAULT_RESPONSE_CODE = "default";
    private static final ValidationResults.CrumbInfo CRUMB_PATH = new ValidationResults.CrumbInfo("path", true);
    private final ParameterValidator<Parameter> specRequestPathValidator;
    private final ParameterValidator<Parameter> specRequestQueryValidator;
    private final ParameterValidator<Parameter> specRequestHeaderValidator;
    private final ParameterValidator<Parameter> specRequestCookieValidator;
    private final Map<MediaTypeContainer, BodyValidator> specRequestBodyValidators;
    private final Map<String, Map<MediaTypeContainer, BodyValidator>> specResponseBodyValidators;
    private final Map<String, ParameterValidator<Header>> specResponseHeaderValidators;
    private final ValidationContext<OAI3> context;
    private final Operation operation;
    private final String templatePath;
    private final List<Pattern> pathPatterns;

    public OperationValidator(OpenApi3 openApi, Path path, Operation operation) {
        this((ValidationContext<OAI3>)new ValidationContext(openApi.getContext()), openApi, path, operation);
    }

    public OperationValidator(ValidationContext<OAI3> context, OpenApi3 openApi, Path path, Operation operation) {
        this(context, null, openApi, path, operation);
    }

    OperationValidator(ValidationContext<OAI3> context, List<Pattern> pathPatterns, OpenApi3 openApi, Path path, Operation operation) {
        this.context = Objects.requireNonNull(context, VALIDATION_CTX_REQUIRED_ERR_MSG);
        Objects.requireNonNull(operation, OPERATION_REQUIRED_ERR_MSG);
        this.templatePath = openApi.getPathFrom(Objects.requireNonNull(path, PATH_REQUIRED_ERR_MSG));
        this.operation = this.buildFlatOperation(operation);
        this.mergePathToOperationParameters(path);
        this.specRequestPathValidator = this.createParameterValidator(IN_PATH);
        this.pathPatterns = pathPatterns == null ? PathResolver.instance().buildPathPatterns(openApi.getContext(), openApi.getServers(), this.templatePath) : pathPatterns;
        this.specRequestQueryValidator = this.createParameterValidator(IN_QUERY);
        this.specRequestHeaderValidator = this.createParameterValidator(IN_HEADER);
        this.specRequestCookieValidator = this.createParameterValidator(IN_COOKIE);
        this.specRequestBodyValidators = this.createRequestBodyValidators();
        this.specResponseHeaderValidators = this.createResponseHeaderValidators();
        this.specResponseBodyValidators = this.createResponseBodyValidators();
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Map<String, JsonNode> validatePath(Request request, ValidationData<?> validation) {
        Pattern pathPattern = PathResolver.instance().findPathPattern(this.pathPatterns, request.getPath());
        if (pathPattern == null) {
            validation.add(CRUMB_PATH, PATH_NOT_FOUND_ERR, new Object[]{this.templatePath, request.getPath()});
            return null;
        }
        return this.validatePath(request, pathPattern, validation);
    }

    Map<String, JsonNode> validatePath(Request request, Pattern pathPattern, ValidationData<?> validation) {
        if (this.specRequestPathValidator == null) {
            return null;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.pathToNode(this.context.getContext(), this.specRequestPathValidator.getParameters(), pathPattern, request.getPath());
        this.specRequestPathValidator.validate(mappedValues, validation);
        return mappedValues;
    }

    public Map<String, JsonNode> validateQuery(Request request, ValidationData<?> validation) {
        if (this.specRequestQueryValidator == null) {
            return null;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.queryToNode(this.context.getContext(), this.specRequestQueryValidator.getParameters(), request.getQuery(), "UTF-8");
        this.specRequestQueryValidator.validate(mappedValues, validation);
        return mappedValues;
    }

    public Map<String, JsonNode> validateHeaders(Request request, ValidationData<?> validation) {
        if (this.specRequestHeaderValidator == null) {
            return null;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.headersToNode(this.context.getContext(), this.specRequestHeaderValidator.getParameters(), request.getHeaders());
        this.specRequestHeaderValidator.validate(mappedValues, validation);
        return mappedValues;
    }

    public Map<String, JsonNode> validateCookies(Request request, ValidationData<?> validation) {
        if (this.specRequestCookieValidator == null) {
            return null;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.cookiesToNode(this.context.getContext(), this.specRequestCookieValidator.getParameters(), request.getCookies());
        this.specRequestCookieValidator.validate(mappedValues, validation);
        return mappedValues;
    }

    public void validateBody(Request request, ValidationData<?> validation) {
        if (this.specRequestBodyValidators == null) {
            return;
        }
        if (this.operation.getRequestBody().isRequired()) {
            if (request.getContentType() == null) {
                validation.add(BODY_CONTENT_TYPE_ERR, new Object[0]);
                return;
            }
            if (request.getBody() == null) {
                validation.add(BODY_REQUIRED_ERR, new Object[0]);
                return;
            }
        }
        this.validateBodyWithContentType(this.specRequestBodyValidators, request.getContentType(), request.getBody(), validation);
    }

    public void validateResponse(org.openapi4j.operation.validator.model.Response response, ValidationData<?> validation) {
        this.validateHeaders(response, validation);
        this.validateBody(response, validation);
    }

    public void validateBody(org.openapi4j.operation.validator.model.Response response, ValidationData<?> validation) {
        Map<MediaTypeContainer, BodyValidator> validators = this.getResponseValidator(this.specResponseBodyValidators, response);
        if (validators == null) {
            return;
        }
        this.validateBodyWithContentType(validators, response.getContentType(), response.getBody(), validation);
    }

    private void validateBodyWithContentType(Map<MediaTypeContainer, BodyValidator> validators, String rawContentType, Body body, ValidationData<?> validation) {
        MediaTypeContainer contentType = MediaTypeContainer.create(rawContentType);
        BodyValidator validator = null;
        for (Map.Entry<MediaTypeContainer, BodyValidator> mediaType : validators.entrySet()) {
            if (!mediaType.getKey().match(contentType)) continue;
            validator = mediaType.getValue();
            break;
        }
        if (validator == null) {
            validation.add(BODY_WRONG_CONTENT_TYPE_ERR, new Object[]{rawContentType});
            return;
        }
        validator.validate(body, rawContentType, validation);
    }

    public void validateHeaders(org.openapi4j.operation.validator.model.Response response, ValidationData<?> validation) {
        ParameterValidator<Header> validator = this.getResponseValidator(this.specResponseHeaderValidators, response);
        if (validator == null) {
            return;
        }
        Map<String, JsonNode> mappedValues = ParameterConverter.headersToNode(this.context.getContext(), validator.getParameters(), response.getHeaders());
        validator.validate(mappedValues, validation);
    }

    private ParameterValidator<Parameter> createParameterValidator(String in) {
        List specParameters = this.operation.getParametersIn(this.context.getContext(), in);
        Map parameters = specParameters.stream().collect(Collectors.toMap(Parameter::getName, parameter -> parameter));
        return parameters.size() != 0 ? new ParameterValidator(this.context, parameters) : null;
    }

    private Map<MediaTypeContainer, BodyValidator> createRequestBodyValidators() {
        if (this.operation.getRequestBody() == null) {
            return null;
        }
        return this.createBodyValidators(this.operation.getRequestBody().getContentMediaTypes());
    }

    private Map<String, Map<MediaTypeContainer, BodyValidator>> createResponseBodyValidators() {
        if (this.operation.getResponses() == null) {
            return null;
        }
        TreeMap<String, Map<MediaTypeContainer, BodyValidator>> validators = new TreeMap<String, Map<MediaTypeContainer, BodyValidator>>(String.CASE_INSENSITIVE_ORDER);
        Map responses = this.operation.getResponses();
        for (Map.Entry entryStatusCode : responses.entrySet()) {
            String statusCode = (String)entryStatusCode.getKey();
            Response response = (Response)entryStatusCode.getValue();
            validators.put(statusCode, this.createBodyValidators(response.getContentMediaTypes()));
        }
        return validators;
    }

    private Map<MediaTypeContainer, BodyValidator> createBodyValidators(Map<String, MediaType> mediaTypes) {
        HashMap<MediaTypeContainer, BodyValidator> validators = new HashMap<MediaTypeContainer, BodyValidator>();
        if (mediaTypes == null) {
            validators.put(MediaTypeContainer.create(null), new BodyValidator(this.context, null));
        } else {
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                validators.put(MediaTypeContainer.create(entry.getKey()), new BodyValidator(this.context, entry.getValue()));
            }
        }
        return validators;
    }

    private Map<String, ParameterValidator<Header>> createResponseHeaderValidators() {
        TreeMap<String, ParameterValidator<Header>> validators = new TreeMap<String, ParameterValidator<Header>>(String.CASE_INSENSITIVE_ORDER);
        Map responses = this.operation.getResponses();
        if (responses != null) {
            for (Map.Entry entryStatusCode : responses.entrySet()) {
                String statusCode = (String)entryStatusCode.getKey();
                Response response = (Response)entryStatusCode.getValue();
                if (response.getHeaders() == null) continue;
                TreeMap headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                headers.putAll(response.getHeaders());
                validators.put(statusCode, new ParameterValidator(this.context, headers));
            }
        }
        return validators.size() != 0 ? validators : null;
    }

    private <T> T getResponseValidator(Map<String, T> validators, org.openapi4j.operation.validator.model.Response response) {
        if (validators == null) {
            return null;
        }
        String statusCode = String.valueOf(response.getStatus());
        T validator = validators.get(statusCode);
        if (validator == null) {
            validator = validators.get(statusCode.charAt(0) + "XX");
        }
        if (validator == null) {
            validator = validators.get(DEFAULT_RESPONSE_CODE);
        }
        return validator;
    }

    private void mergePathToOperationParameters(Path path) {
        if (path.getParameters() == null) {
            return;
        }
        ArrayList<Parameter> parentParameters = new ArrayList<Parameter>(path.getParameters().size());
        for (Parameter parentParam : path.getParameters()) {
            if (parentParam.isRef()) {
                parentParameters.add(parentParam.copy());
                continue;
            }
            parentParameters.add(parentParam);
        }
        if (this.operation.getParameters() == null) {
            this.operation.setParameters(parentParameters);
        } else {
            List result = Stream.concat(this.operation.getParameters().stream(), parentParameters.stream()).distinct().collect(Collectors.toList());
            this.operation.setParameters(result);
        }
    }

    private Operation buildFlatOperation(Operation operation) {
        Map responses;
        RequestBody rqBody;
        Operation result = new Operation();
        if (operation.hasParameters()) {
            for (Parameter parameter : operation.getParameters()) {
                Parameter flatParam = this.getFlatModel(parameter, Parameter.class);
                flatParam.setSchema(this.getFlatSchema(flatParam.getSchema()));
                this.getFlatMediaTypes(flatParam.getContentMediaTypes());
                result.addParameter(flatParam);
            }
        }
        if ((rqBody = operation.getRequestBody()) != null) {
            RequestBody flatBody = this.getFlatModel(rqBody, RequestBody.class);
            this.getFlatMediaTypes(flatBody.getContentMediaTypes());
            result.setRequestBody(flatBody);
        }
        if ((responses = operation.getResponses()) != null) {
            for (Map.Entry entry : responses.entrySet()) {
                Response flatResponse = this.getFlatModel((Response)entry.getValue(), Response.class);
                if (flatResponse.getHeaders() != null) {
                    for (Map.Entry entryHeader : flatResponse.getHeaders().entrySet()) {
                        Header flatHeader = this.getFlatModel((Header)entryHeader.getValue(), Header.class);
                        flatHeader.setSchema(this.getFlatSchema(flatHeader.getSchema()));
                        flatResponse.setHeader((String)entryHeader.getKey(), flatHeader);
                        this.getFlatMediaTypes(((Header)entryHeader.getValue()).getContentMediaTypes());
                    }
                }
                this.getFlatMediaTypes(flatResponse.getContentMediaTypes());
                result.setResponse((String)entry.getKey(), flatResponse);
            }
        }
        if (operation.getCallbacks() != null) {
            for (Map.Entry entry : operation.getCallbacks().entrySet()) {
                Callback flatCallback = this.getFlatModel((Callback)entry.getValue(), Callback.class);
                result.setCallback((String)entry.getKey(), flatCallback);
            }
        }
        result.setOperationId(operation.getOperationId());
        result.setSecurityRequirements(operation.getSecurityRequirements());
        result.setExtensions(operation.getExtensions());
        result.setTags(operation.getTags());
        result.setDescription(operation.getDescription());
        result.setExternalDocs(operation.getExternalDocs());
        result.setDeprecated(operation.getDeprecated());
        result.setServers(operation.getServers());
        return result;
    }

    private Schema getFlatSchema(Schema schema) {
        if (schema != null) {
            return this.getFlatModel(schema, Schema.class);
        }
        return null;
    }

    private <M extends AbsRefOpenApiSchema<M>> M getFlatModel(M model, Class<M> clazz) {
        try {
            if (model.isRef()) {
                return (M)((AbsRefOpenApiSchema)model.getReference(this.context.getContext()).getMappedContent(clazz));
            }
        }
        catch (DecodeException decodeException) {
            // empty catch block
        }
        return (M)((AbsRefOpenApiSchema)model.copy());
    }

    private void getFlatMediaTypes(Map<String, MediaType> mediaTypes) {
        if (mediaTypes != null) {
            for (Map.Entry<String, MediaType> entry : mediaTypes.entrySet()) {
                MediaType mediaType = entry.getValue();
                if (mediaType.getSchema() == null) continue;
                mediaType.setSchema(this.getFlatModel(mediaType.getSchema(), Schema.class));
            }
        }
    }
}

