/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.operation.validator.model.impl.Body;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class BodyValidator {
    private static final ValidationResult BODY_CONTENT_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(201), "An error occurred when getting the body content from type '%s'.%n%s");
    private static final String BODY = "body";
    private final ValidationContext<OAI3> context;
    private final MediaType mediaType;
    private final JsonValidator validator;

    BodyValidator(ValidationContext<OAI3> context, MediaType mediaType) {
        this.context = context;
        this.mediaType = mediaType;
        this.validator = this.initValidator();
    }

    void validate(Body body, String rawContentType, ValidationData<?> validation) {
        if (this.validator == null) {
            return;
        }
        if (body == null) {
            this.validator.validate((JsonNode)JsonNodeFactory.instance.nullNode(), validation);
            return;
        }
        try {
            JsonNode jsonBody = body.getContentAsNode(this.context.getContext(), this.mediaType, rawContentType);
            this.validator.validate(jsonBody, validation);
        }
        catch (IOException ex) {
            validation.add(BODY_CONTENT_ERR, new Object[]{rawContentType, ex});
        }
    }

    private JsonValidator initValidator() {
        if (this.mediaType == null || this.mediaType.getSchema() == null) {
            return null;
        }
        return new SchemaValidator(this.context, BODY, (JsonNode)TreeUtil.json.convertValue((Object)this.mediaType.getSchema().copy(), JsonNode.class));
    }
}

