/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.json.XML;
import org.json.XMLParserConfiguration;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.operation.validator.util.convert.TypeConverter;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.model.v3.Xml;

class XmlConverter {
    private static final XmlConverter INSTANCE = new XmlConverter();
    private static final Pattern nsPattern = Pattern.compile("<(/)*\\w+:(\\w+)((?:\\s+\\w+=\".+?\")*)(?:\\s+\\w+:\\w+=\".+?\")?((?:\\s+\\w+=\".+?\")*)(\\s*/?)>");
    private static final String nsReplace = "<$1$2$3$4$5>";

    private XmlConverter() {
    }

    static XmlConverter instance() {
        return INSTANCE;
    }

    JsonNode convert(OAIContext context, Schema schema, String body) {
        return this.convert(context, schema, XML.toJSONObject((String)nsPattern.matcher(body).replaceAll(nsReplace), (XMLParserConfiguration)XMLParserConfiguration.KEEP_STRINGS));
    }

    private JsonNode convert(OAIContext context, Schema schema, JSONObject xml) {
        JsonNode content;
        if (xml.isEmpty()) {
            return JsonNodeFactory.instance.nullNode();
        }
        try {
            content = TreeUtil.json.readTree(xml.toString());
        }
        catch (IOException e) {
            return JsonNodeFactory.instance.nullNode();
        }
        Schema flatSchema = schema.getFlatSchema(context);
        if ("object".equals(flatSchema.getSupposedType(context))) {
            content = (JsonNode)((Map.Entry)content.fields().next()).getValue();
        }
        return this.processNode(context, flatSchema, content);
    }

    private JsonNode processNode(OAIContext context, Schema schema, JsonNode node) {
        JsonNode content = this.unwrap(context, schema, node, null);
        if (content == null) {
            return null;
        }
        Schema flatSchema = schema.getFlatSchema(context);
        if ("array".equals(flatSchema.getSupposedType(context))) {
            return this.parseArray(context, flatSchema, content);
        }
        if ("object".equals(flatSchema.getSupposedType(context))) {
            return this.parseObject(context, flatSchema, content);
        }
        return TypeConverter.instance().convertPrimitive(context, flatSchema, content.asText());
    }

    private JsonNode parseArray(OAIContext context, Schema schema, JsonNode node) {
        if (!node.isArray()) {
            return JsonNodeFactory.instance.nullNode();
        }
        ArrayNode resultNode = JsonNodeFactory.instance.arrayNode();
        for (JsonNode arrayItem : node) {
            resultNode.add(this.processNode(context, schema.getItemsSchema(), arrayItem));
        }
        return resultNode;
    }

    private JsonNode parseObject(OAIContext context, Schema schema, JsonNode node) {
        if (!node.isObject()) {
            return JsonNodeFactory.instance.nullNode();
        }
        ObjectNode resultNode = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : schema.getProperties().entrySet()) {
            String entryKey = (String)entry.getKey();
            Schema propSchema = (Schema)entry.getValue();
            JsonNode value = this.processNode(context, propSchema, this.unwrap(context, schema, node, entryKey));
            if (value == null) continue;
            resultNode.set(entryKey, value);
        }
        return resultNode;
    }

    private JsonNode unwrap(OAIContext context, Schema schema, JsonNode content, String defaultKey) {
        Xml xmlConf = schema.getXml();
        Schema flatSchema = schema.getFlatSchema(context);
        if ("array".equals(flatSchema.getSupposedType(context))) {
            if (xmlConf != null && xmlConf.isWrapped()) {
                if (xmlConf.getName() != null) {
                    return this.getRenamedNode(xmlConf, content.get(xmlConf.getName()), xmlConf.getName());
                }
                if (content.size() == 1) {
                    return (JsonNode)((Map.Entry)content.fields().next()).getValue();
                }
                return JsonNodeFactory.instance.nullNode();
            }
            xmlConf = flatSchema.getItemsSchema().getXml();
            if (xmlConf != null) {
                return this.getRenamedNode(xmlConf, content, xmlConf.getName());
            }
        } else if ("object".equals(flatSchema.getSupposedType(context))) {
            return this.getRenamedNode(xmlConf, content, defaultKey);
        }
        return content;
    }

    private JsonNode getRenamedNode(Xml xmlConf, JsonNode content, String defaultKey) {
        if (xmlConf != null && xmlConf.getName() != null) {
            return content.get(xmlConf.getName());
        }
        if (defaultKey != null) {
            return content.get(defaultKey);
        }
        return content;
    }
}

