/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.IOUtil;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.operation.validator.util.ContentType;
import org.openapi4j.operation.validator.util.convert.FormUrlConverter;
import org.openapi4j.operation.validator.util.convert.MultipartConverter;
import org.openapi4j.operation.validator.util.convert.XmlConverter;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.Schema;

public final class ContentConverter {
    private ContentConverter() {
    }

    public static JsonNode convert(OAIContext context, MediaType mediaType, String rawContentType, InputStream is, String str) throws IOException {
        String contentType = ContentType.getTypeOnly(rawContentType);
        if (ContentType.isJson(contentType)) {
            return is != null ? ContentConverter.jsonToNode(is) : ContentConverter.jsonToNode(str);
        }
        if (ContentType.isXml(contentType)) {
            return is != null ? ContentConverter.xmlToNode(context, mediaType.getSchema(), is) : ContentConverter.xmlToNode(context, mediaType.getSchema(), str);
        }
        if (ContentType.isFormUrlEncoded(contentType)) {
            return is != null ? ContentConverter.formUrlEncodedToNode(context, mediaType, rawContentType, is) : ContentConverter.formUrlEncodedToNode(context, mediaType, rawContentType, str);
        }
        if (ContentType.isMultipartFormData(contentType)) {
            return is != null ? ContentConverter.multipartToNode(context, mediaType, rawContentType, is) : ContentConverter.multipartToNode(context, mediaType, rawContentType, str);
        }
        return is != null ? ContentConverter.textToNode(is) : ContentConverter.textToNode(str);
    }

    private static JsonNode formUrlEncodedToNode(OAIContext context, MediaType mediaType, String rawContentType, InputStream content) throws IOException {
        String encoding = ContentType.getCharSet(rawContentType);
        return FormUrlConverter.instance().convert(context, mediaType, content, encoding);
    }

    private static JsonNode formUrlEncodedToNode(OAIContext context, MediaType mediaType, String rawContentType, String content) {
        String encoding = ContentType.getCharSet(rawContentType);
        return FormUrlConverter.instance().convert(context, mediaType, content, encoding);
    }

    private static JsonNode multipartToNode(OAIContext context, MediaType mediaType, String rawContentType, InputStream content) throws IOException {
        String encoding = ContentType.getCharSet(rawContentType);
        return MultipartConverter.instance().convert(context, mediaType, content, rawContentType, encoding);
    }

    private static JsonNode multipartToNode(OAIContext context, MediaType mediaType, String rawContentType, String content) throws IOException {
        String encoding = ContentType.getCharSet(rawContentType);
        return MultipartConverter.instance().convert(context, mediaType, content, rawContentType, encoding);
    }

    private static JsonNode jsonToNode(InputStream content) throws IOException {
        return TreeUtil.json.readTree(content);
    }

    private static JsonNode jsonToNode(String content) throws IOException {
        return TreeUtil.json.readTree(content);
    }

    private static JsonNode xmlToNode(OAIContext context, Schema schema, InputStream content) throws IOException {
        return XmlConverter.instance().convert(context, schema, IOUtil.toString((InputStream)content, (String)StandardCharsets.UTF_8.name()));
    }

    private static JsonNode xmlToNode(OAIContext context, Schema schema, String content) {
        return XmlConverter.instance().convert(context, schema, content);
    }

    private static JsonNode textToNode(InputStream content) throws IOException {
        return JsonNodeFactory.instance.textNode(IOUtil.toString((InputStream)content, (String)StandardCharsets.UTF_8.name()));
    }

    private static JsonNode textToNode(String content) {
        return JsonNodeFactory.instance.textNode(content);
    }
}

