/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.model.impl;

import java.util.Objects;
import java.util.regex.Pattern;
import org.openapi4j.operation.validator.util.ContentType;

public class MediaTypeContainer {
    private static final String TEXT_TYPE = "text";
    private static final Pattern PLACEHOLDER_TYPE = Pattern.compile("^.+/\\*");
    private final String contentType;
    private final String charset;
    private final boolean hasPlaceholder;

    public static MediaTypeContainer create(String rawContentType) {
        String contentType = ContentType.getTypeOnly(rawContentType);
        if (contentType == null) {
            contentType = "";
        }
        String charset = ContentType.getCharSetOrNull(rawContentType);
        return new MediaTypeContainer(contentType, charset);
    }

    private MediaTypeContainer(String contentType, String charset) {
        this.contentType = contentType;
        this.charset = charset;
        this.hasPlaceholder = PLACEHOLDER_TYPE.matcher(contentType).matches();
    }

    public boolean match(MediaTypeContainer mediaTypeContainer) {
        if (this == mediaTypeContainer) {
            return true;
        }
        if (this.contentType.equalsIgnoreCase(mediaTypeContainer.contentType)) {
            if (this.contentType.startsWith(TEXT_TYPE)) {
                return this.charset == null || this.charset.equalsIgnoreCase(mediaTypeContainer.charset);
            }
            return true;
        }
        if (this.hasPlaceholder) {
            String definitionType = this.contentType.substring(0, this.contentType.indexOf(47));
            int endIndex = mediaTypeContainer.contentType.indexOf(47);
            if (endIndex != -1) {
                String valueType = mediaTypeContainer.contentType.substring(0, endIndex);
                return definitionType.equalsIgnoreCase(valueType);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaTypeContainer that = (MediaTypeContainer)o;
        if (!this.contentType.equalsIgnoreCase(that.contentType)) {
            return false;
        }
        return Objects.equals(this.charset, that.charset);
    }

    public int hashCode() {
        int result = this.contentType.hashCode();
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        return result;
    }

    public String toString() {
        String str = "Content-Type: " + this.contentType;
        return this.charset != null ? str + "; charset=" + this.charset : str;
    }
}

