/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import java.net.URI;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgDescElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgTitleElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.type.Color;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.draw.FrameContainer;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.draw.FrameStyleHandler;
import org.odftoolkit.simple.draw.Image;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Frame
extends Component {
    protected DrawFrameElement mElement;
    protected Document mOwnerDocument;
    protected FrameContainer mFrameContainer;
    protected FrameStyleHandler mStyleHandler;

    protected Frame(DrawFrameElement element) {
        this.mElement = element;
        this.mOwnerDocument = (Document)((OdfFileDom)this.mElement.getOwnerDocument()).getDocument();
        this.mFrameContainer = null;
    }

    protected static Frame getInstanceof(DrawFrameElement element) {
        Frame frame = null;
        frame = (Frame)Component.getComponentByElement((OdfElement)element);
        if (frame != null) {
            return frame;
        }
        frame = new Frame(element);
        return frame;
    }

    protected static Frame newFrame(FrameContainer container) {
        Frame frame = null;
        OdfElement parent = container.getFrameContainerElement();
        OdfFileDom ownerDom = (OdfFileDom)parent.getOwnerDocument();
        DrawFrameElement fElement = (DrawFrameElement)ownerDom.newOdfElement(DrawFrameElement.class);
        parent.appendChild((Node)fElement);
        frame = new Frame(fElement);
        frame.mFrameContainer = container;
        return frame;
    }

    public void setName(String name) {
        this.mElement.setDrawNameAttribute(name);
    }

    public String getName() {
        return this.mElement.getDrawNameAttribute();
    }

    public OdfElement getOdfElement() {
        return this.mElement;
    }

    public DrawFrameElement getDrawFrameElement() {
        return this.mElement;
    }

    public void setRectangle(FrameRectangle rectangle) {
        String linemeasure = rectangle.getLinearMeasure().toString();
        if (rectangle.getWidth() > 0.0) {
            this.mElement.setSvgWidthAttribute(rectangle.getWidth() + linemeasure);
        }
        if (rectangle.getHeight() > 0.0) {
            this.mElement.setSvgHeightAttribute(rectangle.getHeight() + linemeasure);
        }
        if (rectangle.getX() > 0.0) {
            this.mElement.setSvgXAttribute(rectangle.getX() + linemeasure);
        }
        if (rectangle.getY() > 0.0) {
            this.mElement.setSvgYAttribute(rectangle.getY() + linemeasure);
        }
    }

    public FrameRectangle getRectangle() {
        try {
            FrameRectangle rectange = new FrameRectangle(this.mElement.getSvgXAttribute(), this.mElement.getSvgYAttribute(), this.mElement.getSvgWidthAttribute(), this.mElement.getSvgHeightAttribute());
            return rectange;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setTitle(String title) {
        SvgTitleElement titleElement = (SvgTitleElement)OdfElement.findFirstChildNode(SvgTitleElement.class, (Node)this.mElement);
        if (titleElement == null) {
            titleElement = this.mElement.newSvgTitleElement();
        }
        titleElement.setTextContent(title);
    }

    public String getTitle() {
        SvgTitleElement titleElement = (SvgTitleElement)OdfElement.findFirstChildNode(SvgTitleElement.class, (Node)this.mElement);
        if (titleElement == null) {
            return null;
        }
        return titleElement.getTextContent();
    }

    public String getDesciption() {
        SvgDescElement descElement = (SvgDescElement)OdfElement.findFirstChildNode(SvgDescElement.class, (Node)this.mElement);
        if (descElement == null) {
            return null;
        }
        return descElement.getTextContent();
    }

    public void setDescription(String description) {
        SvgDescElement descElement = (SvgDescElement)OdfElement.findFirstChildNode(SvgDescElement.class, (Node)this.mElement);
        if (descElement == null) {
            descElement = this.mElement.newSvgDescElement();
        }
        descElement.setTextContent(description);
    }

    public FrameStyleHandler getStyleHandler() {
        if (this.mStyleHandler == null) {
            this.mStyleHandler = new FrameStyleHandler(this);
        }
        return this.mStyleHandler;
    }

    public void setBackgroundColor(Color color) {
        this.getStyleHandler().setBackgroundColor(color);
    }

    private void removeContent() {
        NodeList nodeList = this.mElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                this.mElement.removeChild(node);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            this.mElement.removeChild(node);
        }
        this.mElement.removeAttributeNS(OdfDocumentNamespace.PRESENTATION.getUri(), "placeholder");
    }

    public Image setImage(URI uri) {
        this.removeContent();
        Image image = Image.newImage(this, uri);
        return image;
    }
}

