/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElementBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowGroupElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowsElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfTableRowProperties;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfXMLFactory;
import org.odftoolkit.odfdom.type.Length;
import org.odftoolkit.odfdom.type.PositiveLength;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.CellCoverInfo;
import org.odftoolkit.simple.table.DomNodeList;
import org.odftoolkit.simple.table.Table;
import org.w3c.dom.Node;

public class Row {
    TableTableRowElement maRowElement;
    int mnRepeatedIndex;
    int mRowsRepeatedNumber = -1;
    private static final String DEFAULT_HEIGHT = "0.30in";
    private Document mDocument;

    Row(TableTableRowElement rowElement, int repeatedIndex) {
        this.maRowElement = rowElement;
        this.mnRepeatedIndex = repeatedIndex;
        this.mDocument = (Document)((OdfFileDom)this.maRowElement.getOwnerDocument()).getDocument();
    }

    public static Row getInstance(TableTableRowElement rowElement) {
        TableTableElement tableElement = null;
        for (Node node = rowElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            tableElement = (TableTableElement)node;
        }
        Table table = null;
        if (tableElement == null) {
            throw new IllegalArgumentException("the rowElement is not in the table dom tree");
        }
        table = Table.getInstance(tableElement);
        Row row = table.getRowInstance(rowElement, 0);
        if (row.getRowsRepeatedNumber() > 1) {
            Logger.getLogger(Row.class.getName()).log(Level.WARNING, "the row has the repeated row number, and puzzled about get which repeated index of the row,here just return the first row of the repeated rows.");
        }
        return row;
    }

    private TableTableElement getTableElement() {
        for (Node node = this.maRowElement.getParentNode(); node != null; node = node.getParentNode()) {
            if (!(node instanceof TableTableElement)) continue;
            return (TableTableElement)node;
        }
        return null;
    }

    public Table getTable() {
        TableTableElement tableElement = this.getTableElement();
        if (tableElement != null) {
            return Table.getInstance(tableElement);
        }
        return null;
    }

    public long getHeight() {
        String sHeight = this.maRowElement.getProperty(OdfTableRowProperties.RowHeight);
        if (sHeight == null) {
            sHeight = this.maRowElement.getProperty(OdfTableRowProperties.MinRowHeight);
        }
        if (sHeight == null) {
            sHeight = DEFAULT_HEIGHT;
        }
        return PositiveLength.parseLong((String)sHeight, (Length.Unit)Length.Unit.MILLIMETER);
    }

    public void setHeight(long height, boolean isMinHeight) {
        String sHeightMM = String.valueOf(height) + Length.Unit.MILLIMETER.abbr();
        String sHeightIN = PositiveLength.mapToUnit((String)sHeightMM, (Length.Unit)Length.Unit.INCH);
        this.splitRepeatedRows();
        this.maRowElement.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
        this.maRowElement.setProperty(OdfTableRowProperties.RowHeight, sHeightIN);
    }

    void splitRepeatedRows() {
        int repeateNum = this.getRowsRepeatedNumber();
        if (repeateNum > 1) {
            int i;
            int columnsRepeatedNumber;
            Node rowOwnerElement = this.maRowElement.getParentNode();
            Table table = this.getTable();
            IdentityHashMap<TableTableRowElement, Vector<Row>> rowRepository = table.mRowRepository;
            IdentityHashMap<TableTableCellElementBase, Vector<Cell>> cellRepository = table.mCellRepository;
            String tableNameSpaceURI = OdfDocumentNamespace.TABLE.getUri();
            Vector oldList = null;
            if (rowRepository.containsKey(this.maRowElement)) {
                oldList = (Vector)rowRepository.remove(this.maRowElement);
            }
            int offetAfterCurrentRow = repeateNum - this.mnRepeatedIndex - 1;
            TableTableRowElement currentRowElement = null;
            TableTableRowElement newBeforeRowElement = null;
            TableTableRowElement newAfterRowElement = null;
            ArrayList<TableTableCellElementBase> newBeforeCellElements = new ArrayList<TableTableCellElementBase>();
            ArrayList<TableTableCellElementBase> newCurrentCellElements = new ArrayList<TableTableCellElementBase>();
            ArrayList<TableTableCellElementBase> newAfterCellElements = new ArrayList<TableTableCellElementBase>();
            if (this.mnRepeatedIndex > 0) {
                newBeforeRowElement = (TableTableRowElement)this.maRowElement.cloneNode(true);
                if (this.mnRepeatedIndex > 1) {
                    newBeforeRowElement.setTableNumberRowsRepeatedAttribute(Integer.valueOf(this.mnRepeatedIndex));
                } else {
                    newBeforeRowElement.removeAttributeNS(tableNameSpaceURI, "number-rows-repeated");
                }
                rowOwnerElement.insertBefore((Node)newBeforeRowElement, (Node)this.maRowElement);
                if (oldList != null) {
                    Vector<Row> newBeforeList = new Vector<Row>(this.mnRepeatedIndex);
                    for (int i2 = 0; i2 < this.mnRepeatedIndex && i2 < oldList.size(); ++i2) {
                        Row beforeRow = (Row)oldList.get(i2);
                        if (beforeRow == null) continue;
                        beforeRow.maRowElement = newBeforeRowElement;
                        beforeRow.mRowsRepeatedNumber = -1;
                        newBeforeList.add(i2, beforeRow);
                    }
                    rowRepository.put(newBeforeRowElement, newBeforeList);
                    for (Node n : new DomNodeList(newBeforeRowElement.getChildNodes())) {
                        columnsRepeatedNumber = ((TableTableCellElementBase)n).getTableNumberColumnsRepeatedAttribute();
                        for (i = 0; i < columnsRepeatedNumber; ++i) {
                            newBeforeCellElements.add((TableTableCellElementBase)n);
                        }
                    }
                }
            }
            currentRowElement = (TableTableRowElement)this.maRowElement.cloneNode(true);
            currentRowElement.removeAttributeNS(tableNameSpaceURI, "number-rows-repeated");
            rowOwnerElement.insertBefore((Node)currentRowElement, (Node)this.maRowElement);
            for (Node n : new DomNodeList(currentRowElement.getChildNodes())) {
                int columnsRepeatedNumber2 = ((TableTableCellElementBase)n).getTableNumberColumnsRepeatedAttribute();
                for (int i3 = 0; i3 < columnsRepeatedNumber2; ++i3) {
                    newCurrentCellElements.add((TableTableCellElementBase)n);
                }
            }
            if (offetAfterCurrentRow > 0) {
                newAfterRowElement = (TableTableRowElement)this.maRowElement.cloneNode(true);
                if (offetAfterCurrentRow > 1) {
                    newAfterRowElement.setTableNumberRowsRepeatedAttribute(Integer.valueOf(offetAfterCurrentRow));
                } else {
                    newAfterRowElement.removeAttributeNS(tableNameSpaceURI, "number-rows-repeated");
                }
                rowOwnerElement.insertBefore((Node)newAfterRowElement, (Node)this.maRowElement);
                if (oldList != null) {
                    Vector<Row> newAfterList = new Vector<Row>(offetAfterCurrentRow);
                    for (int i4 = this.mnRepeatedIndex + 1; i4 < repeateNum && i4 < oldList.size(); ++i4) {
                        Row afterRow = (Row)oldList.get(i4);
                        if (afterRow == null) continue;
                        afterRow.maRowElement = newAfterRowElement;
                        afterRow.mnRepeatedIndex = i4 - this.mnRepeatedIndex - 1;
                        afterRow.mRowsRepeatedNumber = -1;
                        newAfterList.add(afterRow.mnRepeatedIndex, afterRow);
                    }
                    rowRepository.put(newAfterRowElement, newAfterList);
                    for (Node n : new DomNodeList(newAfterRowElement.getChildNodes())) {
                        columnsRepeatedNumber = ((TableTableCellElementBase)n).getTableNumberColumnsRepeatedAttribute();
                        for (i = 0; i < columnsRepeatedNumber; ++i) {
                            newAfterCellElements.add((TableTableCellElementBase)n);
                        }
                    }
                }
            }
            int cellColumnIndexBase = 0;
            for (Node n : new DomNodeList(this.maRowElement.getChildNodes())) {
                if (cellRepository.containsKey(n)) {
                    Vector cellList = (Vector)cellRepository.get(n);
                    for (Cell cell : cellList) {
                        if (cell == null) continue;
                        int oldColumnIndex = cellColumnIndexBase + cell.mnRepeatedColIndex;
                        if (cell.mnRepeatedRowIndex > this.mnRepeatedIndex) {
                            cell.mnRepeatedRowIndex = cell.mnRepeatedRowIndex - this.mnRepeatedIndex - 1;
                            cell.mCellElement = (TableTableCellElementBase)newAfterCellElements.get(oldColumnIndex);
                            continue;
                        }
                        if (cell.mnRepeatedRowIndex == this.mnRepeatedIndex) {
                            cell.mnRepeatedRowIndex = 0;
                            cell.mCellElement = (TableTableCellElementBase)newCurrentCellElements.get(oldColumnIndex);
                            continue;
                        }
                        cell.mCellElement = (TableTableCellElementBase)newBeforeCellElements.get(oldColumnIndex);
                    }
                }
                cellColumnIndexBase += ((TableTableCellElementBase)n).getTableNumberColumnsRepeatedAttribute().intValue();
            }
            Vector<Row> currentList = new Vector<Row>(1);
            currentList.add(0, this);
            rowRepository.put(currentRowElement, currentList);
            this.mRowsRepeatedNumber = -1;
            this.mnRepeatedIndex = 0;
            rowOwnerElement.removeChild((Node)this.maRowElement);
            this.maRowElement = currentRowElement;
        }
    }

    public boolean isOptimalHeight() {
        return Boolean.parseBoolean(this.maRowElement.getProperty(OdfTableRowProperties.UseOptimalRowHeight));
    }

    public void setUseOptimalHeight(boolean isUseOptimalHeight) {
        this.maRowElement.setProperty(OdfTableRowProperties.UseOptimalRowHeight, String.valueOf(isUseOptimalHeight));
    }

    public TableTableRowElement getOdfElement() {
        return this.maRowElement;
    }

    public Cell getCellByIndex(int index) {
        Table table = this.getTable();
        if (index < 0) {
            throw new IllegalArgumentException("index should be nonnegative integer.");
        }
        int lastColumnIndex = table.getColumnCount() - 1;
        if (index > lastColumnIndex) {
            table.appendColumns(index - lastColumnIndex, true);
        }
        for (Node n : new DomNodeList(this.maRowElement.getChildNodes())) {
            if (!(n instanceof TableTableCellElementBase)) continue;
            if (index == 0) {
                return table.getCellInstance((TableTableCellElementBase)n, 0, this.mnRepeatedIndex);
            }
            int nextIndex = index - ((TableTableCellElementBase)n).getTableNumberColumnsRepeatedAttribute();
            if (nextIndex < 0) {
                Cell cell = table.getCellInstance((TableTableCellElementBase)n, index, this.mnRepeatedIndex);
                return cell;
            }
            index = nextIndex;
        }
        return null;
    }

    public int getCellCount() {
        Table table = this.getTable();
        HashSet<Cell> realCells = new HashSet<Cell>();
        List<CellCoverInfo> coverList = table.getCellCoverInfos(0, 0, table.getColumnCount() - 1, table.getRowCount() - 1);
        int rowIndex = this.getRowIndex();
        for (int i = 0; i < table.getColumnCount(); ++i) {
            Cell cell = table.getOwnerCellByPosition(coverList, i, rowIndex);
            realCells.add(cell);
        }
        return realCells.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getPreviousRow() {
        Table table = this.getTable();
        if (this.getRowsRepeatedNumber() > 1 && this.mnRepeatedIndex > 0) {
            return table.getRowInstance(this.maRowElement, this.mnRepeatedIndex - 1);
        }
        Node aPrevNode = this.maRowElement.getPreviousSibling();
        Object aCurNode = this.maRowElement;
        while (true) {
            if (aPrevNode == null) {
                Node parentNode = aCurNode.getParentNode();
                if (parentNode instanceof TableTableElement) {
                    return null;
                }
                aPrevNode = parentNode.getPreviousSibling();
            }
            if (aPrevNode == null) continue;
            try {
                if (aPrevNode instanceof TableTableRowElement) {
                    return table.getRowInstance((TableTableRowElement)aPrevNode, ((TableTableRowElement)aPrevNode).getTableNumberRowsRepeatedAttribute() - 1);
                }
                if (aPrevNode instanceof TableTableRowsElement || aPrevNode instanceof TableTableHeaderRowsElement || aPrevNode instanceof TableTableRowGroupElement) {
                    TableTableRowElement lastRow;
                    XPath xpath = ((OdfContentDom)aPrevNode.getOwnerDocument()).getXPath();
                    Document document = this.mDocument;
                    synchronized (document) {
                        lastRow = (TableTableRowElement)xpath.evaluate(".//table:table-row[last()]", aPrevNode, XPathConstants.NODE);
                    }
                    if (lastRow == null) continue;
                    return table.getRowInstance(lastRow, lastRow.getTableNumberRowsRepeatedAttribute() - 1);
                }
                aCurNode = aPrevNode;
                aPrevNode = aPrevNode.getPreviousSibling();
                continue;
            }
            catch (XPathExpressionException e) {
                Logger.getLogger(Row.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getNextRow() {
        Table table = this.getTable();
        if (this.getRowsRepeatedNumber() > 1 && this.mnRepeatedIndex < this.getRowsRepeatedNumber() - 1) {
            return table.getRowInstance(this.maRowElement, this.mnRepeatedIndex + 1);
        }
        Node aNextNode = this.maRowElement.getNextSibling();
        Object aCurNode = this.maRowElement;
        while (true) {
            if (aNextNode == null) {
                Node parentNode = aCurNode.getParentNode();
                if (parentNode instanceof TableTableElement) {
                    return null;
                }
                aNextNode = parentNode.getNextSibling();
            }
            if (aNextNode == null) continue;
            try {
                if (aNextNode instanceof TableTableRowElement) {
                    return table.getRowInstance((TableTableRowElement)aNextNode, 0);
                }
                if (aNextNode instanceof TableTableRowsElement || aNextNode instanceof TableTableHeaderRowsElement || aNextNode instanceof TableTableRowGroupElement) {
                    TableTableRowElement firstRow;
                    XPath xpath = ((OdfContentDom)aNextNode.getOwnerDocument()).getXPath();
                    Document document = this.mDocument;
                    synchronized (document) {
                        firstRow = (TableTableRowElement)xpath.evaluate(".//table:table-row[first()]", aNextNode, XPathConstants.NODE);
                    }
                    if (firstRow == null) continue;
                    return table.getRowInstance(firstRow, 0);
                }
                aCurNode = aNextNode;
                aNextNode = aNextNode.getNextSibling();
                continue;
            }
            catch (XPathExpressionException e) {
                Logger.getLogger(Row.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    public void setDefaultCellStyle(OdfStyle style) {
        this.splitRepeatedRows();
        OdfStyle defaultStyle = this.getDefaultCellStyle();
        if (defaultStyle != null) {
            defaultStyle.removeStyleUser((OdfStylableElement)this.maRowElement);
        }
        if (style != null) {
            style.addStyleUser((OdfStylableElement)this.maRowElement);
            this.maRowElement.setTableDefaultCellStyleNameAttribute(style.getStyleNameAttribute());
        }
    }

    public OdfStyle getDefaultCellStyle() {
        String styleName = this.maRowElement.getTableDefaultCellStyleNameAttribute();
        OdfStyle style = this.maRowElement.getAutomaticStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        if (style == null) {
            style = this.mDocument.getDocumentStyles().getStyle(styleName, OdfStyleFamily.TableCell);
        }
        return style;
    }

    public int getRowIndex() {
        int result = 0;
        TableTableElement mTableElement = this.getTableElement();
        TableTableRowElement rowEle = null;
        for (Node n : new DomNodeList(mTableElement.getChildNodes())) {
            if (n instanceof TableTableHeaderRowsElement) {
                TableTableHeaderRowsElement headers = (TableTableHeaderRowsElement)n;
                for (Node m : new DomNodeList(headers.getChildNodes())) {
                    if (!(m instanceof TableTableRowElement)) continue;
                    rowEle = (TableTableRowElement)m;
                    if (rowEle == this.getOdfElement()) {
                        return result + this.mnRepeatedIndex;
                    }
                    result += rowEle.getTableNumberRowsRepeatedAttribute().intValue();
                }
            }
            if (!(n instanceof TableTableRowElement)) continue;
            rowEle = (TableTableRowElement)n;
            if (rowEle == this.getOdfElement()) break;
            result += ((TableTableRowElement)n).getTableNumberRowsRepeatedAttribute().intValue();
        }
        return result + this.mnRepeatedIndex;
    }

    void insertCellByIndex(int index, int count) {
        this.splitRepeatedRows();
        Table table = this.getTable();
        List<CellCoverInfo> coverList = table.getCellCoverInfos(0, 0, table.getColumnCount() - 1, table.getRowCount() - 1);
        int rowIndex = this.getRowIndex();
        Cell preCell = index == 0 ? table.getOwnerCellByPosition(coverList, 0, rowIndex) : table.getOwnerCellByPosition(coverList, index - 1, rowIndex);
        Cell nextCell = this.getCellByIndex(index);
        if (nextCell == null) {
            nextCell = this.getCellByIndex(this.getCellCount() - 1);
        }
        OdfName tableCellNameSpace = OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"table-cell");
        if (table.isUseRepeat()) {
            TableTableCellElement newCell = (TableTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)((OdfFileDom)this.maRowElement.getOwnerDocument()), (OdfName)tableCellNameSpace);
            newCell.setTableStyleNameAttribute(preCell.getStyleName());
            if (count > 1) {
                newCell.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(count));
            }
            this.maRowElement.insertBefore((Node)newCell, (Node)nextCell.getOdfElement());
        } else {
            for (int i = index + count; i > index; --i) {
                TableTableCellElement newCell = (TableTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)((OdfFileDom)this.maRowElement.getOwnerDocument()), (OdfName)tableCellNameSpace);
                newCell.setTableStyleNameAttribute(preCell.getStyleName());
                this.maRowElement.insertBefore((Node)newCell, (Node)nextCell.getOdfElement());
            }
        }
    }

    void setRowsRepeatedNumber(int num) {
        this.mRowsRepeatedNumber = num;
        this.maRowElement.setTableNumberRowsRepeatedAttribute(Integer.valueOf(num));
    }

    int getRowsRepeatedNumber() {
        if (this.mRowsRepeatedNumber < 0) {
            Integer count = this.maRowElement.getTableNumberRowsRepeatedAttribute();
            this.mRowsRepeatedNumber = count == null ? 1 : count;
        }
        return this.mRowsRepeatedNumber;
    }

    private void insertCellElementBefore(OdfElement parentEle, TableTableCellElementBase positionEle, TableTableCellElementBase cellEle, int count) {
        boolean isDescribedBySingleElement = this.getTable().isUseRepeat();
        if (positionEle == null) {
            parentEle.appendChild((Node)cellEle);
            if (isDescribedBySingleElement && count > 1) {
                cellEle.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(count));
            } else {
                for (int i = 1; i < count; ++i) {
                    parentEle.appendChild(cellEle.cloneNode(true));
                }
            }
        } else {
            parentEle.insertBefore((Node)cellEle, (Node)positionEle);
            if (isDescribedBySingleElement && count > 1) {
                cellEle.setTableNumberColumnsRepeatedAttribute(Integer.valueOf(count));
            } else {
                for (int i = 1; i < count; ++i) {
                    parentEle.insertBefore(cellEle.cloneNode(true), (Node)positionEle);
                }
            }
        }
    }

    void insertCellBefore(Cell refCell, Cell positionCell, int count) {
        this.splitRepeatedRows();
        Table ownerTable = this.getTable();
        if (positionCell == null) {
            if (refCell.isCoveredElement()) {
                TableTableCellElement coverCellEle = (TableTableCellElement)refCell.getCoverCell().getOdfElement();
                TableTableCellElement newCellEle = (TableTableCellElement)coverCellEle.cloneNode(true);
                this.cleanCell(newCellEle);
                this.insertCellElementBefore((OdfElement)this.getOdfElement(), null, (TableTableCellElementBase)newCellEle, count);
            } else {
                TableTableCellElement endCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                this.cleanCell(endCellEle);
                this.getOdfElement().appendChild((Node)endCellEle);
                this.reviseStyleFromLastColumnToMedium(refCell);
                if (count > 1) {
                    TableTableCellElement newCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                    this.cleanCell(newCellEle);
                    this.insertCellElementBefore((OdfElement)this.getOdfElement(), (TableTableCellElementBase)endCellEle, (TableTableCellElementBase)newCellEle, count - 1);
                }
            }
        } else {
            TableTableCellElement coverRefCellEle = null;
            TableTableCellElement coverPosCellEle = null;
            Cell coverRefCell = null;
            if (refCell.isCoveredElement()) {
                coverRefCell = refCell.getCoverCell();
                coverRefCellEle = (TableTableCellElement)coverRefCell.getOdfElement();
            }
            if (positionCell.isCoveredElement()) {
                coverPosCellEle = (TableTableCellElement)positionCell.getCoverCell().getOdfElement();
            }
            if (coverRefCellEle != null && coverRefCellEle == coverPosCellEle || coverPosCellEle != null && refCell.getOdfElement() == coverPosCellEle) {
                if (coverRefCellEle == null) {
                    coverRefCellEle = (TableTableCellElement)refCell.getOdfElement();
                    coverRefCell = refCell;
                }
                TableCoveredTableCellElement newCellEle = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)((OdfFileDom)ownerTable.getOdfElement().getOwnerDocument()), (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"covered-table-cell"));
                this.insertCellElementBefore((OdfElement)this.getOdfElement(), positionCell.getOdfElement(), (TableTableCellElementBase)newCellEle, count);
                if (refCell.getRowIndex() == coverRefCell.getRowIndex()) {
                    coverRefCell.setColumnSpannedNumber(coverRefCell.getColumnSpannedNumber() + count);
                }
            } else if (coverRefCellEle != null) {
                if (refCell.getRowIndex() == coverRefCell.getRowIndex()) {
                    TableTableCellElement newCellEle = (TableTableCellElement)coverRefCellEle.cloneNode(true);
                    this.cleanCell(newCellEle);
                    this.insertCellElementBefore((OdfElement)this.getOdfElement(), positionCell.getOdfElement(), (TableTableCellElementBase)newCellEle, count);
                } else {
                    TableCoveredTableCellElement newCellEle = (TableCoveredTableCellElement)refCell.getOdfElement().cloneNode(true);
                    newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                    this.insertCellElementBefore((OdfElement)this.getOdfElement(), positionCell.getOdfElement(), (TableTableCellElementBase)newCellEle, count);
                }
            } else if (refCell.getOdfElement() == positionCell.getOdfElement() && refCell.getColumnsRepeatedNumber() > 1) {
                int repeatNum = refCell.getColumnsRepeatedNumber();
                for (int i = repeatNum - 1; i > refCell.mnRepeatedColIndex; --i) {
                    ownerTable.updateCellRepository(refCell.getOdfElement(), i, refCell.mnRepeatedRowIndex, refCell.getOdfElement(), i + count, refCell.mnRepeatedRowIndex);
                }
                refCell.getOdfElement().setTableNumberColumnsRepeatedAttribute(Integer.valueOf(repeatNum + count));
            } else {
                TableTableCellElement newCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                this.cleanCell(newCellEle);
                this.insertCellElementBefore((OdfElement)this.getOdfElement(), positionCell.getOdfElement(), (TableTableCellElementBase)newCellEle, count);
            }
        }
    }

    Cell insertCellBefore(Cell refCell, Cell positionCell) {
        this.splitRepeatedRows();
        Cell newCell = null;
        Table ownerTable = this.getTable();
        if (positionCell == null) {
            if (refCell.isCoveredElement()) {
                TableTableCellElement coverCellEle = (TableTableCellElement)refCell.getCoverCell().getOdfElement();
                TableTableCellElement newCellEle = (TableTableCellElement)coverCellEle.cloneNode(true);
                this.cleanCell(newCellEle);
                this.getOdfElement().appendChild((Node)newCellEle);
                newCell = ownerTable.getCellInstance((TableTableCellElementBase)newCellEle, 0, 0);
            } else {
                TableTableCellElement newCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                this.cleanCell(newCellEle);
                this.getOdfElement().appendChild((Node)newCellEle);
                newCell = ownerTable.getCellInstance((TableTableCellElementBase)newCellEle, 0, 0);
                this.reviseStyleFromLastColumnToMedium(refCell);
            }
        } else {
            TableTableCellElement coverRefCellEle = null;
            TableTableCellElement coverPosCellEle = null;
            Cell coverRefCell = null;
            if (refCell.isCoveredElement()) {
                coverRefCell = refCell.getCoverCell();
                coverRefCellEle = (TableTableCellElement)coverRefCell.getOdfElement();
            }
            if (positionCell.isCoveredElement()) {
                coverPosCellEle = (TableTableCellElement)positionCell.getCoverCell().getOdfElement();
            }
            if (coverRefCellEle != null && coverRefCellEle == coverPosCellEle || coverPosCellEle != null && refCell.getOdfElement() == coverPosCellEle) {
                if (coverRefCellEle == null) {
                    coverRefCellEle = (TableTableCellElement)refCell.getOdfElement();
                    coverRefCell = refCell;
                }
                TableCoveredTableCellElement newCellEle = (TableCoveredTableCellElement)OdfXMLFactory.newOdfElement((OdfFileDom)((OdfFileDom)ownerTable.getOdfElement().getOwnerDocument()), (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.TABLE, (String)"covered-table-cell"));
                this.getOdfElement().insertBefore((Node)newCellEle, (Node)positionCell.getOdfElement());
                if (refCell.getRowIndex() == coverRefCell.getRowIndex()) {
                    coverRefCell.setColumnSpannedNumber(coverRefCell.getColumnSpannedNumber() + 1);
                }
                newCell = ownerTable.getCellInstance((TableTableCellElementBase)newCellEle, 0, 0);
            } else if (coverRefCellEle != null) {
                if (refCell.getRowIndex() == coverRefCell.getRowIndex()) {
                    TableTableCellElement newCellEle = (TableTableCellElement)coverRefCellEle.cloneNode(true);
                    this.cleanCell(newCellEle);
                    this.getOdfElement().insertBefore((Node)newCellEle, (Node)positionCell.getOdfElement());
                    newCell = ownerTable.getCellInstance((TableTableCellElementBase)newCellEle, 0, 0);
                } else {
                    TableCoveredTableCellElement newCellEle = (TableCoveredTableCellElement)refCell.getOdfElement().cloneNode(true);
                    newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
                    this.getOdfElement().insertBefore((Node)newCellEle, (Node)positionCell.getOdfElement());
                    newCell = ownerTable.getCellInstance((TableTableCellElementBase)newCellEle, 0, 0);
                }
            } else if (refCell.getOdfElement() == positionCell.getOdfElement() && refCell.getColumnsRepeatedNumber() > 1) {
                int repeatNum = refCell.getColumnsRepeatedNumber();
                for (int i = repeatNum - 1; i > refCell.mnRepeatedColIndex; --i) {
                    ownerTable.updateCellRepository(refCell.getOdfElement(), i, refCell.mnRepeatedRowIndex, refCell.getOdfElement(), i + 1, refCell.mnRepeatedRowIndex);
                }
                refCell.getOdfElement().setTableNumberColumnsRepeatedAttribute(Integer.valueOf(repeatNum + 1));
                newCell = ownerTable.getCellInstance(refCell.getOdfElement(), refCell.mnRepeatedColIndex + 1, refCell.mnRepeatedRowIndex);
            } else {
                TableTableCellElement newCellEle = (TableTableCellElement)refCell.getOdfElement().cloneNode(true);
                this.cleanCell(newCellEle);
                this.getOdfElement().insertBefore((Node)newCellEle, (Node)positionCell.getOdfElement());
                newCell = ownerTable.getCellInstance((TableTableCellElementBase)newCellEle, 0, 0);
            }
        }
        return newCell;
    }

    private void cleanCell(TableTableCellElement newCellEle) {
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "date-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "time-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "boolean-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.OFFICE.getUri(), "string-value");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "formula");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-repeated");
        newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "number-columns-spanned");
        if (!this.getTable().isCellStyleInheritance()) {
            newCellEle.removeAttributeNS(OdfDocumentNamespace.TABLE.getUri(), "style-name");
        }
        Node n = newCellEle.getFirstChild();
        while (n != null) {
            Node m = n.getNextSibling();
            if (n instanceof TextPElement || n instanceof TextHElement || n instanceof TextListElement) {
                newCellEle.removeChild(n);
            }
            n = m;
        }
    }

    private void reviseStyleFromLastColumnToMedium(Cell oldLastCell) {
        if (this.getTable().mIsSpreadsheet) {
            return;
        }
        OdfStyle styleEle = oldLastCell.getStyleHandler().getCellStyleElementForWrite();
        if (styleEle != null) {
            if (oldLastCell.getRowIndex() == 0) {
                Table.setLeftTopBorderStyleProperties(styleEle);
            } else {
                Table.setLeftBottomBorderStylesProperties(styleEle);
            }
        }
    }

    private void reviseStyleFromMediumColumnToLast(Cell newLastCell) {
        if (this.getTable().mIsSpreadsheet) {
            return;
        }
        OdfStyle styleEle = newLastCell.getStyleHandler().getCellStyleElementForWrite();
        if (styleEle != null) {
            if (newLastCell.getRowIndex() == 0) {
                Table.setRightTopBorderStyleProperties(styleEle);
            } else {
                Table.setRightBottomBorderStylesProperties(styleEle);
            }
        }
    }

    void removeCellByIndex(int nStart, int nCount) {
        Cell cell;
        this.splitRepeatedRows();
        Cell startCell = this.getCellByIndex(nStart);
        Cell coverCell = null;
        if (startCell.isCoveredElement()) {
            coverCell = startCell.getCoverCellInSameRow();
        }
        int index = nStart;
        for (int i = 0; i < nCount; ++i) {
            cell = this.getCellByIndex(index);
            cell.splitRepeatedCells();
            if (cell.isCoveredElement() && coverCell != null) {
                coverCell.setColumnSpannedNumber(coverCell.getColumnSpannedNumber() - cell.getColumnsRepeatedNumber());
                this.maRowElement.removeChild((Node)cell.getOdfElement());
                i += cell.getColumnsRepeatedNumber() - 1;
                continue;
            }
            if (cell.isCoveredElement()) {
                this.maRowElement.removeChild((Node)cell.getOdfElement());
                i += cell.getColumnsRepeatedNumber() - 1;
                continue;
            }
            if (cell.isCoveredElement()) continue;
            if (i + cell.getColumnSpannedNumber() <= nCount) {
                this.maRowElement.removeChild((Node)cell.getOdfElement());
                i += cell.getColumnSpannedNumber() - 1;
                continue;
            }
            this.removeCellByIndex(index + 1, nCount - i);
        }
        int clmnum = this.getTable().getColumnCount();
        if (nStart + nCount >= clmnum) {
            cell = this.getCellByIndex(nStart - 1);
            this.reviseStyleFromMediumColumnToLast(cell);
        }
    }

    void removeAllCellsRelationship() {
        Cell cell;
        Table table = this.getTable();
        for (int i = 0; i < table.getColumnCount(); i += cell.getColumnSpannedNumber()) {
            Cell coveredCell;
            cell = this.getCellByIndex(i);
            if (cell.isCoveredElement()) {
                Cell coverCell = cell.getCoverCellInSameColumn();
                if (coverCell != null) {
                    coverCell.setRowSpannedNumber(coverCell.getRowSpannedNumber() - this.getRowsRepeatedNumber());
                }
                this.getOdfElement().removeChild((Node)cell.getOdfElement());
                continue;
            }
            if (cell.getRowSpannedNumber() <= 1) continue;
            Row nextRow = table.getRowByIndex(this.getRowIndex() + 1);
            if (nextRow.getRowsRepeatedNumber() > 1) {
                nextRow.splitRepeatedRows();
            }
            if ((coveredCell = table.getCellByPosition(cell.getColumnIndex(), this.getRowIndex() + 1)).getColumnsRepeatedNumber() > 1) {
                coveredCell.splitRepeatedCells();
                coveredCell = table.getCellByPosition(cell.getColumnIndex(), this.getRowIndex() + 1);
            }
            TableTableCellElement newCellEle = (TableTableCellElement)cell.getOdfElement().cloneNode(true);
            newCellEle.setTableNumberRowsSpannedAttribute(Integer.valueOf(cell.getRowSpannedNumber() - this.getRowsRepeatedNumber()));
            int startRow = coveredCell.getRowIndex();
            int endRow = coveredCell.getRowIndex() + newCellEle.getTableNumberRowsSpannedAttribute();
            int startClm = coveredCell.getColumnIndex();
            int endClm = coveredCell.getColumnIndex() + newCellEle.getTableNumberColumnsSpannedAttribute() * newCellEle.getTableNumberColumnsRepeatedAttribute();
            coveredCell.getOdfElement().getParentNode().replaceChild((Node)newCellEle, (Node)coveredCell.getOdfElement());
            table.updateRepositoryWhenCellElementChanged(startRow, endRow, startClm, endClm, newCellEle);
        }
    }
}

