/*
 * Decompiled with CFR 0.152.
 */
package schema2template.model;

import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitor;
import com.sun.msv.grammar.NameClassAndExpression;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLIo;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import schema2template.model.PuzzlePiece;

class GraphSupport {
    public GraphSupport(Expression exp, String schemaFileName) {
        Graph g = GraphSupport.buildGraph(exp);
        if (exp instanceof ElementExp && schemaFileName != null) {
            String elementName = PuzzlePiece.getName((NameClassAndExpression)exp);
            GraphSupport.saveGraph(g, elementName, schemaFileName);
        }
    }

    private static void saveGraph(Graph g, String elementName, String schemaFileName) {
        String fileName = elementName.equals("*") ? "ALL_ELEMENTS" : elementName.replace(" | ", "_").replace(":", "_");
        try {
            String directoryName = schemaFileName.replace(".", "_");
            File f = new File("target" + File.separator + "graphML" + File.separator + directoryName);
            f.mkdirs();
            ((GraphMLIo)g.io(IoCore.graphml())).writeGraph("target" + File.separator + "graphML" + File.separator + directoryName + File.separator + fileName + ".graphml");
        }
        catch (IOException ex) {
            Logger.getLogger(GraphSupport.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static Graph buildGraph(Expression exp) {
        return GraphSupport.buildGraph(null, null, null, exp, null);
    }

    private static Graph buildGraph(Graph g, Vertex v, Vertex parentV, Expression exp, Expression parentExp) {
        if (g == null) {
            g = TinkerGraph.open();
            v = GraphSupport.createVertex(g, exp);
        }
        GraphSupport.addGraphProperties(g, v, parentV, exp, parentExp);
        if (!(exp instanceof NameClassAndExpression) || parentExp == null) {
            List children = (List)exp.visit((ExpressionVisitor)PuzzlePiece.CHILD_VISITOR);
            Integer newChildNo = 0;
            for (Expression newChildExp : children) {
                Vertex newChildV = GraphSupport.createVertex(g, newChildExp);
                if (exp instanceof SequenceExp && parentV != null) {
                    Integer n = newChildNo;
                    newChildNo = newChildNo + 1;
                    v.addEdge("has", newChildV, new Object[]{"order", newChildNo.toString(), "color", "#00ee00"});
                }
                g = GraphSupport.buildGraph(g, newChildV, v, newChildExp, exp);
            }
        }
        return g;
    }

    private static Vertex createVertex(Graph g, Expression exp) {
        Vertex v = null;
        String type = PuzzlePiece.getType(exp).toString();
        if (type != null && !type.isEmpty()) {
            v = g.addVertex(type);
        }
        return v;
    }

    private static Vertex addGraphProperties(Graph g, Vertex v, Vertex parentVertex, Expression exp, Expression parentExp) {
        if (v == null) {
            v = GraphSupport.createVertex(g, exp);
        }
        String type = PuzzlePiece.getType(exp).toString();
        if (exp instanceof NameClassAndExpression) {
            String name = PuzzlePiece.getName((NameClassAndExpression)exp);
            v.property("label", (Object)name);
            if (exp instanceof ElementExp) {
                v.property("color", (Object)"#6495ed");
            } else {
                v.property("color", (Object)"#ee0000");
            }
        } else if (exp instanceof ReferenceExp) {
            String refName = ((ReferenceExp)exp).name;
            if (refName == null) {
                refName = "NONAME";
            }
            v.property("label", (Object)refName);
            v.property("color", (Object)"#ffd700");
        } else {
            v.property("label", (Object)type);
            v.property("type", (Object)type);
        }
        if (parentVertex != null && !(parentExp instanceof SequenceExp)) {
            parentVertex.addEdge("has", v, new Object[0]);
        }
        return v;
    }
}

