/*
 * Decompiled with CFR 0.152.
 */
package schema2template.example.odf;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import schema2template.example.odf.OdfModel;
import schema2template.example.odf.SourceCodeBaseClass;
import schema2template.model.PuzzleComponent;
import schema2template.model.PuzzlePiece;
import schema2template.model.QNamed;
import schema2template.model.QNamedPuzzleComponent;
import schema2template.model.XMLModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeModel {
    Map<String, SourceCodeBaseClass> mElementBaseMap;
    SortedSet<SourceCodeBaseClass> mBaseclasses;
    Map<String, SourceCodeBaseClass> mBasenameToBaseclass;
    Map<String, String[]> mDatatypeValueAndConversionMap;

    public SourceCodeModel(XMLModel model, OdfModel odfmodel, Map<String, String> elementnameBasenameMap, Map<String, String[]> datatypeValueAndConversionMap) {
        String basename;
        this.mDatatypeValueAndConversionMap = datatypeValueAndConversionMap;
        TreeSet<String> basenames = new TreeSet<String>(elementnameBasenameMap.values());
        HashMap basenameElementsMap = new HashMap(basenames.size());
        for (String elementname : elementnameBasenameMap.keySet()) {
            QNamedPuzzleComponent subelement;
            basename = elementnameBasenameMap.get(elementname);
            TreeSet<PuzzlePiece> elements = (TreeSet<PuzzlePiece>)basenameElementsMap.get(basename);
            if (elements == null) {
                elements = new TreeSet<PuzzlePiece>();
                basenameElementsMap.put(basename, elements);
            }
            if ((subelement = model.getElement(elementname)) != null) {
                if (subelement instanceof Collection) {
                    elements.addAll((Collection)((Object)subelement));
                    continue;
                }
                elements.add((PuzzlePiece)subelement);
                continue;
            }
            System.err.println("Warning: Baseclass definition for unknown element " + elementname);
        }
        this.mBasenameToBaseclass = new HashMap<String, SourceCodeBaseClass>(basenames.size());
        this.mBaseclasses = new TreeSet<SourceCodeBaseClass>();
        for (String basename2 : basenames) {
            SourceCodeBaseClass javabaseclass = new SourceCodeBaseClass(odfmodel, basename2, (SortedSet)basenameElementsMap.get(basename2));
            this.mBaseclasses.add(javabaseclass);
            this.mBasenameToBaseclass.put(basename2, javabaseclass);
        }
        this.mElementBaseMap = new HashMap<String, SourceCodeBaseClass>(elementnameBasenameMap.size());
        for (String elementname : elementnameBasenameMap.keySet()) {
            basename = elementnameBasenameMap.get(elementname);
            SourceCodeBaseClass baseclass = this.mBasenameToBaseclass.get(basename);
            this.mElementBaseMap.put(elementname, baseclass);
        }
    }

    public SourceCodeBaseClass getBaseclassOf(QNamed subelement) {
        return this.mElementBaseMap.get(subelement.getQName());
    }

    public SortedSet<SourceCodeBaseClass> getBaseclasses() {
        return this.mBaseclasses;
    }

    public SourceCodeBaseClass getBaseclass(String basename) {
        return this.mBasenameToBaseclass.get(basename);
    }

    public SourceCodeBaseClass getBaseclass(QNamed base) {
        return this.getBaseclass(base.getQName());
    }

    public String getValuetype(QNamed datatype) {
        String datatypename = datatype.getQName();
        String[] tuple = this.mDatatypeValueAndConversionMap.get(datatypename);
        if (tuple == null) {
            return "";
        }
        String retval = tuple[0];
        return retval == null ? "" : retval;
    }

    public SortedSet<String> getValuetypes(PuzzleComponent datatypes) {
        TreeSet<String> retval = new TreeSet<String>();
        for (PuzzlePiece datatype : datatypes.getCollection()) {
            String valuetype;
            String datatypename = datatype.getQName();
            String[] tuple = this.mDatatypeValueAndConversionMap.get(datatypename);
            if (tuple == null || (valuetype = tuple[0]) == null) continue;
            retval.add(valuetype);
        }
        return retval;
    }

    public String getPrimitiveType(String objectType) {
        if (objectType.equals("Boolean")) {
            return "boolean";
        }
        if (objectType.equals("Integer")) {
            return "int";
        }
        if (objectType.equals("Double")) {
            return "double";
        }
        return null;
    }

    public String getConversiontype(QNamed datatype) {
        String datatypename = datatype.getQName();
        String[] tuple = this.mDatatypeValueAndConversionMap.get(datatypename);
        if (tuple == null) {
            return "";
        }
        String retval = tuple[1];
        return retval == null ? "" : retval;
    }

    public String getConversiontype(String datatypename) {
        String[] tuple = this.mDatatypeValueAndConversionMap.get(datatypename);
        if (tuple == null) {
            return "";
        }
        String retval = tuple[1];
        return retval == null ? "" : retval;
    }
}

