/*
 * Decompiled with CFR 0.152.
 */
package schema2template;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.xml.sax.SAXException;
import schema2template.GenerationParameters;
import schema2template.grammar.OdfModel;
import schema2template.grammar.XMLModel;
import schema2template.template.FileCreationListEntry;
import schema2template.template.FileCreationListHandler;
import schema2template.template.GrammarAdditionsFileHandler;
import schema2template.template.SourceCodeModel;

public class SchemaToTemplate {
    private static final Logger LOG = Logger.getLogger(SchemaToTemplate.class.getName());
    public static final Boolean DEBUG = Boolean.FALSE;
    private static final String VELOCITY_MACRO_FILE = "velocity-macros.vm";

    private SchemaToTemplate() {
    }

    public static void run(List<GenerationParameters> generations) throws ParserConfigurationException, IOException, SAXException {
        generations.sort(Comparator.comparing(GenerationParameters::getGrammarVersion));
        HashMap modelHistories = new HashMap();
        for (GenerationParameters generation : generations) {
            List modelHistory;
            String grammarVersion = generation.getGrammarVersion();
            String grammarID = generation.getGrammarID();
            String grammarFilePath = generation.getGrammarPath();
            String grammarAdditionsFilePath = generation.getGrammarAdditionsPath();
            String mainTemplateFilePath = generation.getMainTemplatePath();
            String mainTemplateFileName = Paths.get(mainTemplateFilePath, new String[0]).getFileName().toString();
            String templateBaseDir = mainTemplateFilePath.substring(0, mainTemplateFilePath.lastIndexOf(mainTemplateFileName));
            Object targetDirPath = generation.getTargetDir();
            targetDirPath = (String)targetDirPath + File.separator + grammarID + "-" + grammarVersion;
            new File((String)targetDirPath).mkdirs();
            XMLModel currentModel = new XMLModel(new File(grammarFilePath), grammarVersion, grammarID);
            currentModel.getAttributes().withoutMultiples();
            if (modelHistories.containsKey(grammarID)) {
                modelHistory = (List)modelHistories.get(grammarID);
                modelHistory = modelHistory.stream().sorted(Comparator.comparing(XMLModel::getGrammarVersion).reversed()).collect(Collectors.toList());
            } else {
                modelHistory = null;
            }
            SchemaToTemplate.startGeneration(templateBaseDir, mainTemplateFileName, (String)targetDirPath, "file-creation-list_" + grammarID + "-" + grammarVersion + ".xml", SchemaToTemplate.initVelocityContext(currentModel, modelHistory, grammarAdditionsFilePath));
            if (modelHistory == null) {
                modelHistory = new ArrayList();
            }
            modelHistory.add(currentModel);
            modelHistories.put(grammarID, modelHistory);
        }
    }

    private static VelocityContext initVelocityContext(XMLModel xmlModel, List<XMLModel> xmlModelHistory, String grammarAdditionsFilePath) throws ParserConfigurationException, IOException, SAXException {
        LOG.info("Starting initilization of Velocity context..");
        VelocityContext context = new VelocityContext();
        if (grammarAdditionsFilePath != null && !grammarAdditionsFilePath.isBlank()) {
            HashMap<String, String> elementToBaseNameMap = new HashMap<String, String>();
            HashMap<String, String> elementSuperClassNameMap = new HashMap<String, String>();
            HashMap<String, String> componentRootElementNames = new HashMap<String, String>();
            HashSet<String> repetitionAttributeNames = new HashSet<String>();
            HashMap<String, List<String>> elementNameToFamilyMap = new HashMap<String, List<String>>();
            HashMap<String, String[]> datatypeValueAndConversionMap = new HashMap<String, String[]>();
            HashMap<String, Map<String, String>> attributeDefaultMap = new HashMap<String, Map<String, String>>();
            GrammarAdditionsFileHandler.readGrammarAdditionsFile(new File(grammarAdditionsFilePath), elementToBaseNameMap, elementSuperClassNameMap, componentRootElementNames, repetitionAttributeNames, attributeDefaultMap, elementNameToFamilyMap, datatypeValueAndConversionMap);
            OdfModel odfModel = new OdfModel(elementNameToFamilyMap, componentRootElementNames, repetitionAttributeNames, attributeDefaultMap, xmlModel);
            context.put("odfModel", (Object)odfModel);
            SourceCodeModel sourceCodeModel = new SourceCodeModel(xmlModel, elementToBaseNameMap, elementSuperClassNameMap, datatypeValueAndConversionMap);
            context.put("codeModel", (Object)sourceCodeModel);
        }
        context.put("xmlModel", (Object)xmlModel);
        context.put("xmlModelHistory", xmlModelHistory);
        LOG.info("Finished initialization..");
        return context;
    }

    private static void startGeneration(String templateBaseDir, String templateFileName, String targetDirPath, String targetFileName, VelocityContext context) throws ParserConfigurationException, IOException, SAXException {
        LOG.info("Starting code generation:");
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.loader", (Object)"file");
        ve.setProperty("resource.loader.file.path", (Object)Paths.get(templateBaseDir, new String[0]).normalize().toString());
        ve.setProperty("parser.space_gobbling", (Object)"bc");
        ve.setProperty("runtime.strict_mode.enable", (Object)"true");
        if (VELOCITY_MACRO_FILE != null && !VELOCITY_MACRO_FILE.isEmpty() && Paths.get(templateBaseDir + File.separator + VELOCITY_MACRO_FILE, new String[0]).toFile().exists()) {
            ve.setProperty("velocimacro.library.path", (Object)VELOCITY_MACRO_FILE);
        }
        ve.init();
        SchemaToTemplate.generateFileCreationList(ve, templateFileName, targetDirPath, targetFileName, context);
        LOG.info("file-creation-list.xml has been created!");
        LOG.fine("Processing output files... ");
        SchemaToTemplate.processFileCreationList(ve, targetDirPath, targetFileName, context);
        LOG.fine("DONE.\n");
    }

    private static void generateFileCreationList(VelocityEngine ve, String templateFileName, String targetDirPath, String targetFileName, VelocityContext context) throws IOException {
        File fileCreationList = new File(targetDirPath + File.separator + targetFileName);
        SchemaToTemplate.ensureParentFolders(fileCreationList);
        try (FileWriter listout = new FileWriter(fileCreationList);){
            String encoding = "utf-8";
            ve.mergeTemplate(templateFileName, encoding, (Context)context, (Writer)listout);
        }
    }

    private static void processFileCreationList(VelocityEngine ve, String targetDirPath, String targetFileName, VelocityContext context) throws ParserConfigurationException, IOException, SAXException {
        File outputFileList = new File(targetDirPath + File.separator + targetFileName);
        List<FileCreationListEntry> fl = FileCreationListHandler.readFileListFile(outputFileList);
        for (FileCreationListEntry f : fl) {
            String param;
            LOG.log(Level.INFO, "Processing line {0}: \n\tGenerating file:\n\t\t{1}\n\t\t{2}", new Object[]{f.getLineNumber(), targetDirPath + File.separator, Paths.get(f.getAttribute("path"), new String[0]).normalize()});
            String contextAttrValue = f.getAttribute("contextNode");
            if (contextAttrValue != null) {
                context.put("contextNode", (Object)contextAttrValue);
                LOG.log(Level.INFO, "Added to context: contextNode : {0}", contextAttrValue);
            }
            if ((param = f.getAttribute("param")) != null) {
                context.put("param", (Object)param);
                LOG.log(Level.INFO, "adding param: {0}", f.getAttribute("param"));
            }
            File out = new File(targetDirPath + File.separator + Paths.get(f.getAttribute("path"), new String[0]).normalize()).getCanonicalFile();
            SchemaToTemplate.ensureParentFolders(out);
            try (FileWriter fileout = new FileWriter(out);){
                String encoding = "utf-8";
                ve.mergeTemplate(f.getAttribute("template"), encoding, (Context)context, (Writer)fileout);
            }
        }
    }

    private static void ensureParentFolders(File newFile) {
        File parent = newFile.getParentFile();
        if (parent != null && !parent.exists()) {
            try {
                parent.mkdirs();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not create parent directory {0}", parent.getAbsolutePath());
            }
        }
    }
}

