/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.ParentNode;
import org.json.JSONObject;
import org.odftoolkit.odfdom.changes.Component;
import org.odftoolkit.odfdom.changes.JsonOperationConsumer;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHandoutMasterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableContentValidationsElement;
import org.odftoolkit.odfdom.dom.element.table.TableCoveredTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableShapesElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextNoteElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.element.text.TextTrackedChangesElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfAlienElement;
import org.odftoolkit.odfdom.pkg.OdfAttribute;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class OdfElement
extends ElementNSImpl {
    private static final long serialVersionUID = -4939293285696678939L;
    private boolean isComponentRoot = false;
    private boolean mIsIgnoredComponent = false;
    private Component mComponent = null;
    private int mComponentSize = 0;

    public OdfElement(OdfFileDom ownerDocument, String namespaceURI, String qualifiedName) throws DOMException {
        super((CoreDocumentImpl)ownerDocument, namespaceURI, qualifiedName);
    }

    public OdfElement(OdfFileDom ownerDocument, OdfName aName) throws DOMException {
        super((CoreDocumentImpl)ownerDocument, aName.getUri(), aName.getQName());
    }

    public abstract OdfName getOdfName();

    protected <T extends OdfElement> T getParentAs(Class<T> clazz) {
        Node parent = this.getParentNode();
        if (parent != null && clazz.isInstance(parent)) {
            return (T)((Object)((OdfElement)((Object)clazz.cast(parent))));
        }
        return null;
    }

    protected <T extends OdfElement> T getAncestorAs(Class<T> clazz) {
        for (Node node = this.getParentNode(); node != null; node = node.getParentNode()) {
            if (!clazz.isInstance(node)) continue;
            return (T)((Object)((OdfElement)((Object)clazz.cast(node))));
        }
        return null;
    }

    public boolean hasAncestor(Node potentialParent) {
        Node parentNode = this.getParentNode();
        boolean isParent = false;
        while (parentNode != null) {
            if (parentNode.equals(potentialParent)) {
                isParent = true;
                break;
            }
            if ((parentNode = parentNode.getParentNode()) != null) continue;
        }
        return isParent;
    }

    public String toString() {
        return OdfElement.mapNode((Node)((Object)this), new StringBuilder()).toString();
    }

    private static StringBuilder mapNodeTree(Node node, StringBuilder xml) {
        while (node != null) {
            xml = OdfElement.mapNode(node, xml);
            node = node.getNextSibling();
        }
        return xml;
    }

    private static StringBuilder mapNode(Node node, StringBuilder xml) {
        if (node instanceof Element) {
            xml = OdfElement.mapElementNode(node, xml);
        } else if (node instanceof Text) {
            xml = OdfElement.mapTextNode(node, xml);
        }
        return xml;
    }

    private static StringBuilder mapTextNode(Node node, StringBuilder xml) {
        if (node != null) {
            xml = xml.append(node.getTextContent());
        }
        return xml;
    }

    private static StringBuilder mapElementNode(Node node, StringBuilder xml) {
        if (node != null) {
            xml = xml.append("<");
            xml = xml.append(node.getNodeName());
            xml = OdfElement.mapAttributeNode(node, xml);
            xml = xml.append(">");
            xml = OdfElement.mapNodeTree(node.getFirstChild(), xml);
            xml = xml.append("</");
            xml = xml.append(node.getNodeName());
            xml = xml.append(">");
        }
        return xml;
    }

    private static StringBuilder mapAttributeNode(Node node, StringBuilder xml) {
        int length;
        NamedNodeMap attrs = null;
        attrs = node.getAttributes();
        if (attrs != null && (length = attrs.getLength()) > 0) {
            for (int i = 0; length > i; ++i) {
                xml = xml.append(" ");
                xml = xml.append(attrs.item(i).getNodeName());
                xml = xml.append("=\"");
                xml = xml.append(attrs.item(i).getNodeValue());
                xml = xml.append("\"");
            }
        }
        return xml;
    }

    public void setOdfAttributeValue(OdfName name, String value) {
        this.setAttributeNS(name.getUri(), name.getQName(), value);
    }

    public void setOdfAttribute(OdfAttribute attribute) {
        this.setAttributeNodeNS((Attr)((Object)attribute));
    }

    public String getOdfAttributeValue(OdfName name) {
        return this.getAttributeNS(name.getUri(), name.getLocalName());
    }

    public OdfAttribute getOdfAttribute(OdfName name) {
        return (OdfAttribute)((Object)this.getAttributeNodeNS(name.getUri(), name.getLocalName()));
    }

    public OdfAttribute getOdfAttribute(NamespaceName namespace, String localname) {
        return (OdfAttribute)((Object)this.getAttributeNodeNS(namespace.getUri(), localname));
    }

    public boolean hasOdfAttribute(OdfName name) {
        return this.hasAttributeNS(name.getUri(), name.getLocalName());
    }

    public static <T extends OdfElement> T findFirstChildNode(Class<T> clazz, Node parentNode) {
        if (parentNode != null && parentNode instanceof ParentNode) {
            Node node;
            for (node = ((ParentNode)parentNode).getFirstChild(); node != null && !clazz.isInstance(node); node = node.getNextSibling()) {
            }
            if (node != null) {
                return (T)((Object)((OdfElement)((Object)node)));
            }
        }
        return null;
    }

    public static <T extends OdfElement> T findNextChildNode(Class<T> clazz, Node refNode) {
        if (refNode != null) {
            Node node;
            for (node = refNode.getNextSibling(); node != null && !clazz.isInstance(node); node = node.getNextSibling()) {
            }
            if (node != null) {
                return (T)((Object)((OdfElement)((Object)node)));
            }
        }
        return null;
    }

    public static <T extends OdfElement> T findPreviousChildNode(Class<T> clazz, Node refNode) {
        if (refNode != null) {
            Node node;
            for (node = refNode.getPreviousSibling(); node != null && !clazz.isInstance(node); node = node.getPreviousSibling()) {
            }
            if (node != null) {
                return (T)((Object)((OdfElement)((Object)node)));
            }
        }
        return null;
    }

    public OdfElement cloneElement() {
        Object cloneElement = ((OdfFileDom)this.ownerDocument).newOdfElement(((Object)((Object)this)).getClass());
        if (cloneElement == null) {
            cloneElement = new OdfAlienElement((OdfFileDom)((Object)this.getOwnerDocument()), OdfName.newName(OdfNamespace.getNamespace(this.getNamespaceURI()), this.getTagName()));
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                Node item = this.attributes.item(i);
                Object qname = null;
                String prefix = item.getPrefix();
                if (prefix == null) {
                    qname = item.getLocalName();
                    cloneElement.setAttribute((String)qname, item.getNodeValue());
                    continue;
                }
                qname = prefix + ":" + item.getLocalName();
                cloneElement.setAttributeNS(item.getNamespaceURI(), (String)qname, item.getNodeValue());
            }
        }
        if (this.isComponentRoot) {
            ((OdfElement)((Object)cloneElement)).markAsComponentRoot(true);
            ((OdfElement)((Object)cloneElement)).mComponentSize = this.mComponentSize;
            ((OdfElement)((Object)cloneElement)).mIsIgnoredComponent = this.mIsIgnoredComponent;
            if (!this.mIsIgnoredComponent) {
                Component.createComponent(this.getComponent().getParent(), (OdfElement)((Object)cloneElement));
            }
        }
        for (Node childNode = this.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            ((OdfElement)((Object)cloneElement)).appendChild(childNode.cloneNode(true));
        }
        if (this.selfAndDescendantTextIgnoredAsComponent()) {
            ((OdfElement)((Object)cloneElement)).ignoredComponent(true);
        }
        ((OdfElement)((Object)cloneElement)).mComponentSize = this.mComponentSize;
        ((OdfElement)((Object)cloneElement)).mIsIgnoredComponent = this.mIsIgnoredComponent;
        return cloneElement;
    }

    protected OdfElement cloneOdfElement() {
        return ((OdfFileDom)this.ownerDocument).newOdfElement(((Object)((Object)this)).getClass());
    }

    public Node cloneNode(boolean deep) {
        OdfElement cloneElement = this.cloneOdfElement();
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                Node item = this.attributes.item(i);
                Object qname = null;
                String prefix = item.getPrefix();
                if (prefix == null) {
                    qname = item.getLocalName();
                    cloneElement.setAttribute((String)qname, item.getNodeValue());
                    continue;
                }
                qname = prefix + ":" + item.getLocalName();
                if (((String)qname).equals("xml:id") || ((String)qname).equals("office:value") || ((String)qname).equals("calcext:value-type") || ((String)qname).equals("office:value-type")) continue;
                cloneElement.setAttributeNS(item.getNamespaceURI(), (String)qname, item.getNodeValue());
            }
        }
        if (this.isComponentRoot) {
            cloneElement.markAsComponentRoot(true);
            cloneElement.mComponentSize = this.mComponentSize;
            cloneElement.mIsIgnoredComponent = this.mIsIgnoredComponent;
            if (!this.mIsIgnoredComponent) {
                Component.createComponent(this.getComponent().getParent(), cloneElement);
            }
        }
        if (deep) {
            for (Node childNode = this.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                cloneElement.appendChild(childNode.cloneNode(true));
            }
        }
        if (this.selfAndDescendantTextIgnoredAsComponent()) {
            cloneElement.ignoredComponent(true);
        }
        cloneElement.mComponentSize = this.mComponentSize;
        cloneElement.mIsIgnoredComponent = this.mIsIgnoredComponent;
        return cloneElement;
    }

    public Node cloneNode(int depth) {
        Object cloneElement = ((OdfFileDom)this.ownerDocument).newOdfElement(((Object)((Object)this)).getClass());
        if (cloneElement == null) {
            cloneElement = new OdfAlienElement((OdfFileDom)((Object)this.getOwnerDocument()), OdfName.newName(OdfNamespace.getNamespace(this.getNamespaceURI()), this.getTagName()));
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                Node item = this.attributes.item(i);
                Object qname = null;
                String prefix = item.getPrefix();
                if (prefix == null) {
                    qname = item.getLocalName();
                    cloneElement.setAttribute((String)qname, item.getNodeValue());
                    continue;
                }
                qname = prefix + ":" + item.getLocalName();
                if (((String)qname).equals("xml:id") || ((String)qname).equals("office:value") || ((String)qname).equals("calcext:value-type") || ((String)qname).equals("office:value-type")) continue;
                cloneElement.setAttributeNS(item.getNamespaceURI(), (String)qname, item.getNodeValue());
            }
        }
        if (this.isComponentRoot) {
            ((OdfElement)((Object)cloneElement)).markAsComponentRoot(true);
            ((OdfElement)((Object)cloneElement)).mComponentSize = this.mComponentSize;
            ((OdfElement)((Object)cloneElement)).mIsIgnoredComponent = this.mIsIgnoredComponent;
            if (!this.mIsIgnoredComponent) {
                Component.createComponent(this.getComponent().getParent(), (OdfElement)((Object)cloneElement));
            }
        }
        if (depth > 0) {
            for (Node childNode = this.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                if (!(childNode instanceof OdfElement)) continue;
                ((OdfElement)((Object)cloneElement)).appendChild(((OdfElement)((Object)childNode)).cloneNode(depth - 1));
            }
        }
        if (this.selfAndDescendantTextIgnoredAsComponent()) {
            ((OdfElement)((Object)cloneElement)).ignoredComponent(true);
        }
        ((OdfElement)((Object)cloneElement)).mComponentSize = this.mComponentSize;
        return cloneElement;
    }

    public static OdfElement cloneNode(OdfElement source, OdfElement target, boolean deep) {
        NamedNodeMap attributes = source.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Object qname;
                Node item = attributes.item(i);
                String prefix = item.getPrefix();
                if (prefix == null) {
                    qname = item.getLocalName();
                    target.setAttribute((String)qname, item.getNodeValue());
                    continue;
                }
                qname = prefix + ":" + item.getLocalName();
                target.setAttributeNS(item.getNamespaceURI(), (String)qname, item.getNodeValue());
            }
        }
        if (source.isComponentRoot) {
            target.markAsComponentRoot(true);
            target.mComponentSize = source.mComponentSize;
            target.mComponent = source.mComponent;
        }
        if (deep) {
            for (Node childNode = source.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                Node newNode = childNode instanceof OdfElement ? ((OdfElement)((Object)childNode)).cloneNode(true) : childNode.cloneNode(true);
                target.appendChild(newNode);
            }
        }
        if (source.selfAndDescendantTextIgnoredAsComponent()) {
            target.ignoredComponent(true);
        }
        target.mComponentSize = source.mComponentSize;
        return target;
    }

    public Node appendChild(Node node) {
        if (node instanceof OdfElement) {
            OdfElement odfElement = (OdfElement)((Object)node);
        }
        return super.appendChild(node);
    }

    private static int descendantsCount(Node parent, int size) {
        if (!OdfElement.isIgnoredElement((Element)parent)) {
            NodeList children = parent.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child instanceof Text) {
                    size += ((Text)child).getLength();
                    continue;
                }
                if (!(child instanceof OdfElement)) continue;
                OdfElement element = (OdfElement)((Object)child);
                if (Component.isTextSelection((Node)((Object)element))) {
                    size += OdfElement.descendantsCount((Node)((Object)element), size);
                    continue;
                }
                if (!element.isComponentRoot()) continue;
                size += element.componentSize();
            }
        }
        return size;
    }

    public int componentSize() {
        return this.mComponentSize;
    }

    public boolean equals(Object obj) {
        int i;
        int i2;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OdfElement)) {
            return false;
        }
        OdfElement compare = (OdfElement)((Object)obj);
        if (!this.localName.equals(compare.localName)) {
            return false;
        }
        if (!this.namespaceURI.equals(compare.namespaceURI)) {
            return false;
        }
        if (this.attributes == compare.attributes) {
            return true;
        }
        if (this.attributes == null || compare.attributes == null) {
            return false;
        }
        int attr_count1 = this.attributes.getLength();
        int attr_count2 = compare.attributes.getLength();
        ArrayList<Node> attr1 = new ArrayList<Node>();
        for (int i3 = 0; i3 < attr_count1; ++i3) {
            Node node = this.attributes.item(i3);
            if (node.getNodeValue().length() == 0) continue;
            attr1.add(node);
        }
        ArrayList<Node> attr2 = new ArrayList<Node>();
        for (i2 = 0; i2 < attr_count2; ++i2) {
            Node node = compare.attributes.item(i2);
            if (node.getNodeValue().length() == 0) continue;
            attr2.add(node);
        }
        if (attr1.size() != attr2.size()) {
            return false;
        }
        for (i2 = 0; i2 < attr1.size(); ++i2) {
            Node n1 = (Node)attr1.get(i2);
            if (n1.getLocalName().equals("name") && n1.getNamespaceURI().equals(OdfDocumentNamespace.STYLE.getUri())) continue;
            Node n2 = null;
            int j = 0;
            for (j = 0; j < attr2.size(); ++j) {
                n2 = (Node)attr2.get(j);
                if (!n1.getLocalName().equals(n2.getLocalName())) continue;
                String ns1 = n1.getNamespaceURI();
                String ns2 = n2.getNamespaceURI();
                if (ns1 != null && ns2 != null && ns1.equals(ns2)) break;
            }
            if (j == attr2.size()) {
                return false;
            }
            if (n1.getTextContent().equals(n2.getTextContent())) continue;
            return false;
        }
        NodeList childs1 = this.getChildNodes();
        NodeList childs2 = compare.getChildNodes();
        int child_count1 = childs1.getLength();
        int child_count2 = childs2.getLength();
        if (child_count1 == 0 && child_count2 == 0) {
            return true;
        }
        ArrayList<Node> nodes1 = new ArrayList<Node>();
        for (int i4 = 0; i4 < child_count1; ++i4) {
            Node node = childs1.item(i4);
            if (node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0) continue;
            nodes1.add(node);
        }
        ArrayList<Node> nodes2 = new ArrayList<Node>();
        for (i = 0; i < child_count2; ++i) {
            Node node = childs2.item(i);
            if (node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0) continue;
            nodes2.add(node);
        }
        if (nodes1.size() != nodes2.size()) {
            return false;
        }
        for (i = 0; i < nodes1.size(); ++i) {
            Node n2;
            Node n1 = (Node)nodes1.get(i);
            if (n1.equals(n2 = (Node)nodes2.get(i))) continue;
            return false;
        }
        return true;
    }

    protected void onRemoveNode(Node node) {
        if (node != null) {
            for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.onRemoveNode(child);
            }
            if (OdfElement.class.isInstance(node)) {
                ((OdfElement)((Object)node)).onRemoveNode();
            }
        }
    }

    protected void onInsertNode(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.onInsertNode(child);
        }
        if (OdfElement.class.isInstance(node)) {
            ((OdfElement)((Object)node)).onInsertNode();
        }
    }

    protected void onRemoveNode() {
    }

    protected void onInsertNode() {
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        Node n = null;
        this.onInsertNode(newChild);
        n = super.insertBefore(newChild, refChild);
        this.raiseComponentSize(newChild);
        return n;
    }

    public static Element removeSingleElement(Element oldElement) throws DOMException {
        Element parent = (Element)oldElement.getParentNode();
        if (parent != null) {
            NodeList children = oldElement.getChildNodes();
            int childCount = children.getLength();
            Node lastChild = children.item(childCount - 1);
            parent.replaceChild(lastChild, oldElement);
            for (int i = childCount - 2; i >= 0; --i) {
                Node newChild = children.item(i);
                parent.insertBefore(newChild, lastChild);
                lastChild = newChild;
            }
        }
        return parent;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        this.onRemoveNode(oldChild);
        this.reduceComponentSize(oldChild);
        return super.removeChild(oldChild);
    }

    private void reduceComponentSize(Node child) {
        if (child instanceof Text) {
            this.changeSize(-1 * ((Text)child).getLength());
        } else if (child instanceof Element) {
            if (Component.isTextComponentRoot(child)) {
                this.changeSize(-1);
            } else {
                this.changeSize(-1 * OdfElement.descendantsCount(child, 0));
            }
        }
    }

    private boolean isIgnoredText(OdfElement parent) {
        boolean isIgnored = true;
        while (parent != null) {
            if (parent.isComponentRoot() || parent.selfAndDescendantTextIgnoredAsComponent()) {
                if (parent.selfAndDescendantTextIgnoredAsComponent()) {
                    isIgnored = true;
                    break;
                }
                isIgnored = false;
                break;
            }
            parent = parent.getParentAs(OdfElement.class);
        }
        return isIgnored;
    }

    public boolean isRepeatable() {
        return Boolean.FALSE;
    }

    public int getRepetition() {
        return 1;
    }

    private void raiseComponentSize(Node child) {
        if (child instanceof Text) {
            if (!this.isIgnoredText((OdfElement)((Object)child.getParentNode()))) {
                this.changeSize(((Text)child).getLength());
            }
        } else if (child instanceof Element) {
            if (child instanceof OdfElement && ((OdfElement)((Object)child)).isComponentRoot()) {
                if (!((OdfElement)((Object)child)).selfAndDescendantTextIgnoredAsComponent()) {
                    int repetition = ((OdfElement)((Object)child)).getRepetition();
                    if (repetition != 1) {
                        this.changeSize(repetition);
                    } else {
                        this.changeSize(1);
                    }
                }
            } else {
                this.changeSize(OdfElement.descendantsCount(child, 0));
            }
        }
    }

    private int changeSize(int sizeDifference) {
        int size = 0;
        if (sizeDifference != 0) {
            OdfElement element = this;
            if (!element.isComponentRoot() && !OdfElement.isIgnoredElement(element)) {
                while ((element = element.getParentAs(OdfElement.class)) != null && !element.isComponentRoot() && !OdfElement.isIgnoredElement(element)) {
                }
            }
            if (element.isComponentRoot()) {
                size = element.mComponentSize = element.componentSize() + sizeDifference;
            }
        }
        return size;
    }

    public void removeContent() {
        for (int i = 0; i < this.mComponent.size(); ++i) {
            this.mComponent.remove(i);
        }
        this.mComponentSize = 0;
        NodeList children = this.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            Node child = children.item(i);
            if (child == null) continue;
            this.removeChild(child);
        }
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.raiseComponentSize(newChild);
        this.onRemoveNode(oldChild);
        this.onInsertNode(newChild);
        return super.replaceChild(newChild, oldChild);
    }

    public void accept(ElementVisitor visitor) {
        visitor.visit(this);
    }

    public OdfElement getComponentRoot() {
        OdfElement element = this;
        if (!element.isComponentRoot()) {
            while ((element = element.getParentAs(OdfElement.class)) != null && !element.isComponentRoot()) {
            }
        }
        return element;
    }

    public void markAsComponentRoot(boolean isRoot) {
        this.isComponentRoot = true;
        OdfElement parent = (OdfElement)((Object)this.getParentNode());
    }

    public Component getComponent() {
        return this.mComponent;
    }

    public void setComponent(Component component) {
        this.mComponent = component;
    }

    public boolean isComponentRoot() {
        return this.isComponentRoot;
    }

    public boolean selfAndDescendantTextIgnoredAsComponent() {
        return this.mIsIgnoredComponent;
    }

    public void ignoredComponent(boolean isIngoredComponent) {
        this.mIsIgnoredComponent = isIngoredComponent;
    }

    protected static void appendUsingWhitespaceHandling(Node precedingNode, OdfElement parent, Node followingNode, String newString) {
        if (parent != null) {
            int spaceCount = 0;
            int startPos = 0;
            int endPos = 0;
            for (int i = 0; i < newString.length(); ++i) {
                char c = newString.charAt(i);
                if (c == ' ' || c == '\t' || c == '\r' || c == '\n') {
                    if (++spaceCount <= 1) continue;
                    if (endPos - startPos > 0) {
                        precedingNode = OdfElement.addTextNode(precedingNode, parent, followingNode, newString.substring(startPos, endPos));
                    }
                    startPos = endPos;
                    continue;
                }
                if (spaceCount > 1 || i == 1 && spaceCount == 1) {
                    TextSElement s = new TextSElement((OdfFileDom)((Object)parent.getOwnerDocument()));
                    if (spaceCount > 1) {
                        s.setTextCAttribute(spaceCount);
                    }
                    precedingNode = OdfElement.addElementNode(precedingNode, parent, followingNode, s);
                    startPos = endPos += spaceCount;
                    spaceCount = 0;
                } else if (spaceCount == 1) {
                    ++endPos;
                    spaceCount = 0;
                }
                ++endPos;
            }
            if (spaceCount > 1) {
                TextSElement s = new TextSElement((OdfFileDom)((Object)parent.getOwnerDocument()));
                if (spaceCount > 1) {
                    s.setTextCAttribute(spaceCount);
                }
                precedingNode = OdfElement.addElementNode(precedingNode, parent, followingNode, s);
                startPos = endPos += spaceCount;
                spaceCount = 0;
            }
            if (endPos - startPos > 0) {
                precedingNode = OdfElement.addTextNode(precedingNode, parent, followingNode, newString.substring(startPos, endPos));
            }
            if (spaceCount == 1) {
                TextSElement s = new TextSElement((OdfFileDom)((Object)parent.getOwnerDocument()));
                OdfElement.addElementNode(precedingNode, parent, followingNode, s);
            }
        } else {
            Logger.getLogger(OdfElement.class.getName()).log(Level.SEVERE, "Node parent should not be NULL!");
        }
    }

    private static Node addElementNode(Node precedingNode, OdfElement parent, Node followingNode, Element newElement) {
        Node newNode = null;
        if (followingNode == null) {
            newNode = parent.appendChild(newElement);
        } else if (followingNode != null) {
            newNode = parent.insertBefore(newElement, followingNode);
        }
        return newNode;
    }

    private static Node addTextNode(Node precedingNode, OdfElement parent, Node followingNode, String newString) {
        Node newNode = null;
        if (precedingNode == null && followingNode == null || precedingNode != null && precedingNode instanceof Element && followingNode == null) {
            newNode = parent.appendChild(parent.getOwnerDocument().createTextNode(newString));
        } else if (precedingNode != null && precedingNode instanceof Text) {
            ((Text)precedingNode).appendData(newString);
            newNode = precedingNode;
        } else if (followingNode != null) {
            newNode = parent.insertBefore(parent.getOwnerDocument().createTextNode(newString), followingNode);
        }
        return newNode;
    }

    private static Node addElementNode(Node precedingNode, OdfElement parent, Node followingNode, OdfElement newElement) {
        Node newNode = null;
        newNode = followingNode == null ? parent.appendChild((Node)((Object)newElement)) : parent.insertBefore((Node)((Object)newElement), followingNode);
        return newNode;
    }

    public OdfElement split(int posStart) {
        OdfElement newSecondElement = this;
        if (posStart > -1) {
            Node _nextSibling;
            newSecondElement = (OdfElement)((Object)this.cloneNode(true));
            int size = OdfElement.getContentSize((Node)((Object)this));
            Element parent = (Element)this.getParentNode();
            if (size > posStart) {
                this.delete(posStart, size);
            }
            if ((_nextSibling = this.getNextSibling()) != null) {
                parent.insertBefore((Node)((Object)newSecondElement), _nextSibling);
            } else {
                parent.appendChild((Node)((Object)newSecondElement));
            }
            if (posStart != 0) {
                newSecondElement.delete(0, posStart - 1);
            }
        }
        return newSecondElement;
    }

    public Node receiveNode(int textPosStart) {
        if (textPosStart < 0) {
            Logger.getLogger(OdfElement.class.getName()).warning("A negative index " + textPosStart + " was given to insert text into the paragraph!");
        }
        ArrayList nodeContainer = new ArrayList(1);
        boolean withinTextContainer = this instanceof TextPElement || this instanceof TextHElement;
        TextContentTraverser.traverseSiblings(this.getFirstChild(), 0, textPosStart, textPosStart + 1, TextContentTraverser.Algorithm.RECEIVE, nodeContainer, withinTextContainer);
        Node receivedNode = null;
        if (nodeContainer.size() == 1) {
            receivedNode = (Node)nodeContainer.get(0);
        }
        return receivedNode;
    }

    public void markText(int textPosStart, int textPosEnd, JSONObject formatChanges) {
        if (formatChanges != null) {
            if (textPosStart < 0) {
                Logger.getLogger(OdfElement.class.getName()).warning("A negative index " + textPosStart + " was given to insert text into the paragraph!");
            }
            if (textPosEnd < textPosStart) {
                Logger.getLogger(OdfElement.class.getName()).warning("The start index " + textPosStart + " shall not be higher than the end index " + textPosEnd + "!");
            }
            TextContentTraverser.traverseSiblings(this.getFirstChild(), 0, textPosStart, textPosEnd + 1, TextContentTraverser.Algorithm.MARK, formatChanges, new HashMap());
        }
    }

    public int countDescendantComponents() {
        return TextContentTraverser.traverseSiblings(this.getFirstChild(), 0, 0, Integer.MAX_VALUE, TextContentTraverser.Algorithm.COUNT, Integer.MAX_VALUE, Boolean.TRUE);
    }

    public int countChildComponents(Boolean hasTextComponents) {
        return TextContentTraverser.traverseSiblings(this.getFirstChild(), 0, 0, Integer.MAX_VALUE, TextContentTraverser.Algorithm.COUNT, Integer.MAX_VALUE, hasTextComponents);
    }

    public void moveChildrenTo(Element newParent) {
        this.moveNodes(this.getFirstChild(), newParent);
    }

    private void moveNodes(Node node, Element newParent) {
        while (node != null) {
            Node _nextSibling = node.getNextSibling();
            if (node instanceof Element) {
                newParent.appendChild(node);
            } else if (node instanceof Text) {
                this.moveTextNode((Text)node, newParent);
            }
            node = _nextSibling;
        }
    }

    private void moveTextNode(Text node, Element newParent) {
        if (node != null) {
            newParent.appendChild(node);
        }
    }

    public void insert(String newString, int textPosStart) {
        if (newString != null && !newString.isEmpty()) {
            this.insertContent(newString, textPosStart);
        }
    }

    public void insert(Node newNode, int textPosStart) {
        if (newNode != null) {
            this.insertContent(newNode, textPosStart);
        }
    }

    private void insertContent(Object content, int textPosStart) {
        Node firstChild;
        if (textPosStart < 0) {
            Logger.getLogger(OdfElement.class.getName()).warning("A negative index " + textPosStart + " was given to insert text into the paragraph!");
        }
        if ((firstChild = this.getFirstChild()) == null) {
            if (content instanceof String) {
                OdfElement.appendUsingWhitespaceHandling(null, this, null, (String)content);
            } else if (content instanceof Element) {
                this.appendChild((Element)content);
            }
        } else {
            ArrayList<Object> newData = new ArrayList<Object>(2);
            newData.add(content);
            int currentPos = TextContentTraverser.traverseSiblings(firstChild, 0, textPosStart, textPosStart, TextContentTraverser.Algorithm.INSERT, newData);
            if (newData.size() == 1) {
                if (content instanceof String) {
                    OdfElement.appendUsingWhitespaceHandling(null, this, null, (String)content);
                } else if (content instanceof Element) {
                    this.appendChild((Element)content);
                }
            }
        }
    }

    public void delete(int textPosStart, int textPosEnd) {
        if (textPosStart < 0) {
            Logger.getLogger(OdfElement.class.getName()).warning("A negative index " + textPosStart + " was given to insert text into the paragraph!");
        }
        if (textPosEnd < textPosStart) {
            Logger.getLogger(OdfElement.class.getName()).warning("The start index " + textPosStart + " have to be higher than the end index " + textPosEnd + "!");
        }
        ArrayList deleteStatus = new ArrayList(1);
        TextContentTraverser.traverseSiblings(this.getFirstChild(), 0, textPosStart, textPosEnd + 1, TextContentTraverser.Algorithm.DELETE, deleteStatus);
    }

    private static boolean isIgnoredText(Text text) {
        boolean isIgnored = true;
        Node parentNode = text.getParentNode();
        if (parentNode instanceof OdfElement) {
            isIgnored = OdfElement.isIgnoredElement((OdfElement)((Object)parentNode));
        }
        return isIgnored;
    }

    private static boolean isIgnoredElement(OdfElement element) {
        boolean isIgnored;
        block0: {
            block2: {
                block1: {
                    isIgnored = true;
                    if (element.mIsIgnoredComponent || element == null) break block0;
                    if (!element.isComponentRoot() || element.selfAndDescendantTextIgnoredAsComponent()) break block1;
                    isIgnored = false;
                    break block0;
                }
                if (!element.selfAndDescendantTextIgnoredAsComponent()) break block2;
                isIgnored = true;
                break block0;
            }
            OdfElement parent = element.getParentAs(OdfElement.class);
            if (!(parent instanceof OdfElement)) break block0;
            isIgnored = OdfElement.isIgnoredElement(parent);
        }
        return isIgnored;
    }

    private static int getContentSize(Node currentNode) {
        int contentLength = 0;
        for (Node nextChild = currentNode.getFirstChild(); nextChild != null; nextChild = nextChild.getNextSibling()) {
            contentLength += OdfElement.getNodeWidth(nextChild);
        }
        return contentLength;
    }

    private static TextAElement getAnchorElement(Node content, OdfFileDom ownerDoc, String url, Map<OdfName, OdfElement> formatElementHolder) {
        TextAElement newAnchor = null;
        if (formatElementHolder != null) {
            if (formatElementHolder.containsKey(TextAElement.ELEMENT_NAME)) {
                newAnchor = (TextAElement)formatElementHolder.get(TextAElement.ELEMENT_NAME);
            } else {
                if (content instanceof TextAElement) {
                    newAnchor = (TextAElement)((Object)content);
                    newAnchor.setXlinkHrefAttribute(url);
                } else {
                    newAnchor = OdfElement.createAnchorElement(ownerDoc, url);
                }
                formatElementHolder.put(TextAElement.ELEMENT_NAME, newAnchor);
            }
        }
        return newAnchor;
    }

    private static TextAElement createAnchorElement(OdfFileDom ownerDoc, String url) {
        TextAElement containerElement = new TextAElement(ownerDoc);
        containerElement.setXlinkHrefAttribute(url);
        return containerElement;
    }

    private static TextSpanElement getSpanElement(OdfFileDom ownerDoc, JSONObject formatChanges, Map<OdfName, OdfElement> formatElementHolder) {
        TextSpanElement newNode = null;
        if (formatElementHolder != null) {
            if (formatElementHolder.containsKey(TextSpanElement.ELEMENT_NAME)) {
                newNode = (TextSpanElement)formatElementHolder.get(TextSpanElement.ELEMENT_NAME);
            } else {
                newNode = OdfElement.createSpanElement(ownerDoc, formatChanges);
                formatElementHolder.put(TextSpanElement.ELEMENT_NAME, newNode);
            }
        }
        return newNode;
    }

    private static TextSpanElement createSpanElement(OdfFileDom ownerDoc, JSONObject formatChanges) {
        TextSpanElement spanElement = null;
        spanElement = new TextSpanElement(ownerDoc);
        JsonOperationConsumer.addStyle(formatChanges, spanElement, ownerDoc);
        return spanElement;
    }

    private static int getNodeWidth(Node currentNode) {
        int contentLength = 0;
        if (currentNode instanceof Text) {
            if (!OdfElement.isIgnoredText((Text)currentNode)) {
                contentLength = ((Text)currentNode).getLength();
            }
        } else if (currentNode instanceof OdfElement) {
            if (Component.isComponentRoot((Element)((Object)((OdfElement)((Object)currentNode)))) || currentNode instanceof TextSElement) {
                contentLength = OdfElement.isIgnoredElement((OdfElement)((Object)currentNode)) ? 0 : ((OdfElement)((Object)currentNode)).getRepetition();
            } else {
                for (Object nextChild = ((OdfElement)((Object)currentNode)).firstChild; nextChild != null; nextChild = nextChild.getNextSibling()) {
                    contentLength += OdfElement.getNodeWidth((Node)nextChild);
                }
            }
        }
        return contentLength;
    }

    public static void copyAttributes(OdfElement from, OdfElement to) {
        NamedNodeMap attributes = from.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr node = (Attr)attributes.item(i);
            to.setAttributeNS(node.getNamespaceURI(), node.getNodeName(), node.getValue());
        }
    }

    public Element getChildElement(String uri, String localName) {
        return this.getChildElement(uri, localName, 0);
    }

    public Element getChildElement(String uri, String localName, int position) {
        NodeList childList = this.getElementsByTagNameNS(uri, localName);
        return (Element)childList.item(position);
    }

    public static boolean isIgnoredElement(Element element) {
        return OdfElement.isIgnoredElement(element.getNamespaceURI(), element.getLocalName());
    }

    public static boolean isIgnoredElement(String uri, String localName) {
        boolean isIgnored = false;
        if (uri != null && uri.equals(TextNoteElement.ELEMENT_NAME.getUri()) && localName.equals(TextNoteElement.ELEMENT_NAME.getLocalName())) {
            isIgnored = true;
        }
        if (uri != null && uri.equals(TextTrackedChangesElement.ELEMENT_NAME.getUri()) && localName.equals(TextTrackedChangesElement.ELEMENT_NAME.getLocalName())) {
            isIgnored = true;
        }
        if (uri != null && uri.equals(TableShapesElement.ELEMENT_NAME.getUri())) {
            if (localName.equals(TableShapesElement.ELEMENT_NAME.getLocalName())) {
                isIgnored = true;
            }
            if (localName.equals(TableCoveredTableCellElement.ELEMENT_NAME.getLocalName())) {
                isIgnored = true;
            }
        }
        if (uri != null && uri.equals(TableContentValidationsElement.ELEMENT_NAME.getUri()) && localName.equals(TableContentValidationsElement.ELEMENT_NAME.getLocalName())) {
            isIgnored = true;
        }
        if (uri != null && uri.equals(StyleHandoutMasterElement.ELEMENT_NAME.getUri()) && localName.equals(StyleHandoutMasterElement.ELEMENT_NAME.getLocalName())) {
            isIgnored = true;
        }
        return isIgnored;
    }

    public static OdfElement getNextSiblingElement(Node node) {
        OdfElement nextElement = null;
        Node _nextSibling = node.getNextSibling();
        if (_nextSibling instanceof OdfElement) {
            nextElement = (OdfElement)((Object)_nextSibling);
        } else if (_nextSibling instanceof Text) {
            nextElement = OdfElement.getNextSiblingElement(_nextSibling);
        }
        return nextElement;
    }

    public static OdfElement getPreviousSiblingElement(Node node) {
        OdfElement previousElement = null;
        Node _previousElement = node.getPreviousSibling();
        if (_previousElement instanceof OdfElement) {
            previousElement = (OdfElement)((Object)_previousElement);
        } else if (_previousElement instanceof Text) {
            previousElement = OdfElement.getPreviousSiblingElement(_previousElement);
        }
        return previousElement;
    }

    public OdfElement getFirstChildElement() {
        OdfElement firstElementChild = null;
        NodeList nodeList = this.getChildNodes();
        Node node = nodeList.item(0);
        if (node != null) {
            firstElementChild = node instanceof OdfElement ? (OdfElement)((Object)node) : OdfElement.getNextSiblingElement(node);
        }
        return firstElementChild;
    }

    public OdfElement getLastChildElement() {
        OdfElement lastElementChild = null;
        NodeList nodeList = this.getChildNodes();
        Node node = nodeList.item(0);
        for (int i = nodeList.getLength(); i >= 0; --i) {
            if (!(node instanceof OdfElement)) continue;
            lastElementChild = (OdfElement)((Object)node);
            break;
        }
        return lastElementChild;
    }

    public int countPrecedingSiblingElements() {
        int i = 0;
        Node node = this.getPreviousSibling();
        while (node != null) {
            if (!((node = node.getPreviousSibling()) instanceof Element)) continue;
            ++i;
        }
        return i;
    }

    public void setRepetition(int repetition) {
    }

    public String getTextContent() {
        StringBuilder buffer = new StringBuilder();
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                buffer.append(node.getNodeValue());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node instanceof TextSpanElement) {
                buffer.append(((TextSpanElement)((Object)node)).getTextContent());
                continue;
            }
            if (node.getNodeName().equals("text:s")) {
                Integer count = ((TextSElement)((Object)node)).getTextCAttribute();
                for (int j = 0; j < (count != null ? count : 1); ++j) {
                    buffer.append(' ');
                }
                continue;
            }
            if (node.getNodeName().equals("text:tab")) {
                buffer.append('\t');
                continue;
            }
            if (node.getNodeName().equals("text:line-break")) {
                String lineseperator = System.getProperty("line.separator");
                buffer.append(lineseperator);
                continue;
            }
            if (!node.getNodeName().equals("text:a")) continue;
            buffer.append(((TextAElement)((Object)node)).getTextContent());
        }
        return buffer.toString();
    }

    private static class TextContentTraverser {
        private TextContentTraverser() {
        }

        private static int traverseSiblings(Node node, int currentPos, int posStart, int posEnd, Algorithm algorithm, Object ... data) {
            if (algorithm.equals((Object)Algorithm.DELETE)) {
                while (node != null && currentPos <= posEnd) {
                    Node _nextSibling = node.getNextSibling();
                    if (node instanceof Element) {
                        currentPos = TextContentTraverser.checkElementNode((Element)node, currentPos, posStart, posEnd, algorithm, data[0]);
                    } else if (node instanceof Text) {
                        currentPos = algorithm.execute(node, currentPos, posStart, posEnd, data[0]);
                    }
                    node = _nextSibling;
                }
            } else if (algorithm.equals((Object)Algorithm.INSERT)) {
                while (node != null && (currentPos < posEnd || posEnd == 0 && currentPos == 0)) {
                    Node _nextSibling = node.getNextSibling();
                    if (node instanceof Element) {
                        currentPos = TextContentTraverser.checkElementNode((Element)node, currentPos, posStart, posEnd, algorithm, data[0]);
                    } else if (node instanceof Text) {
                        currentPos = algorithm.execute(node, currentPos, posStart, posEnd, data[0]);
                    }
                    node = _nextSibling;
                }
            } else if (algorithm.equals((Object)Algorithm.COUNT)) {
                while (node != null && (currentPos < posEnd || posEnd == 0 && currentPos == 0)) {
                    Node _nextSibling = node.getNextSibling();
                    if (node instanceof Element) {
                        currentPos = TextContentTraverser.checkElementNode((Element)node, currentPos, posStart, posEnd, algorithm, data[0], data[1]);
                    } else if (node instanceof Text && ((Boolean)data[1]).booleanValue()) {
                        currentPos = algorithm.execute(node, currentPos, posStart, posEnd, data[0], data[1]);
                    }
                    node = _nextSibling;
                }
            } else if (algorithm.equals((Object)Algorithm.MARK)) {
                while (node != null && currentPos < posEnd) {
                    Node _nextSibling = node.getNextSibling();
                    currentPos = algorithm.execute(node, currentPos, posStart, posEnd, data[0], data[1]);
                    node = _nextSibling;
                }
            } else {
                boolean withinTextContainer = (Boolean)data[1];
                while (node != null && currentPos < posEnd) {
                    Node _nextSibling = node.getNextSibling();
                    if (node instanceof Element) {
                        if (!withinTextContainer && (node instanceof TextPElement || node instanceof TextHElement)) {
                            data[1] = Boolean.TRUE;
                        }
                        currentPos = TextContentTraverser.checkElementNode((Element)node, currentPos, posStart, posEnd, algorithm, data);
                    } else if (node instanceof Text && withinTextContainer) {
                        currentPos = algorithm.execute(node, currentPos, posStart, posEnd, data);
                    }
                    node = _nextSibling;
                }
            }
            return currentPos;
        }

        private static int checkElementNode(Element currentNode, int currentPos, int posStart, int posEnd, Algorithm algorithm, Object ... data) {
            if (currentNode != null && !OdfElement.isIgnoredElement(currentNode)) {
                if (currentNode instanceof OdfElement && ((OdfElement)((Object)currentNode)).isComponentRoot() && !((OdfElement)((Object)currentNode)).mIsIgnoredComponent) {
                    currentPos = algorithm.execute(currentNode, currentPos, posStart, posEnd, data);
                } else {
                    Node firstChild = currentNode.getFirstChild();
                    if (firstChild != null) {
                        currentPos = TextContentTraverser.traverseSiblings(firstChild, currentPos, posStart, posEnd, algorithm, data);
                    }
                }
            }
            return currentPos;
        }

        private static void formatContent(Node content, Node _nextSibling, JSONObject formatChanges, Map<OdfName, OdfElement> formatElementHolder) {
            OdfFileDom xmlDoc = (OdfFileDom)((Object)content.getOwnerDocument());
            JSONObject charFormatChanges = formatChanges.optJSONObject("character");
            TextAElement newAElement = null;
            if (charFormatChanges != null && charFormatChanges.has("url") && !charFormatChanges.get("url").equals(JSONObject.NULL)) {
                newAElement = OdfElement.getAnchorElement(content, xmlDoc, charFormatChanges.optString("url"), formatElementHolder);
                if (!newAElement.equals(content)) {
                    TextContentTraverser.addNewParent(content, _nextSibling, newAElement);
                }
                _nextSibling = null;
            }
            if (newAElement != null && (xmlDoc.getDocument() instanceof OdfSpreadsheetDocument || TextContentTraverser.isOfficeAnnotationChild(newAElement))) {
                NodeList innerSpans = newAElement.getElementsByTagNameNS(OdfDocumentNamespace.TEXT.getUri(), "span");
                int spanCount = innerSpans.getLength();
                for (int i = spanCount - 1; i >= 0; --i) {
                    TextSpanElement innerSpan = (TextSpanElement)((Object)innerSpans.item(i));
                    OdfElement.removeSingleElement((Element)((Object)innerSpan));
                }
            } else {
                TextSpanElement newSpanElement = OdfElement.getSpanElement(xmlDoc, formatChanges, formatElementHolder);
                if (newSpanElement != null) {
                    if (!newSpanElement.hasAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name")) {
                        newSpanElement = null;
                    } else {
                        TextContentTraverser.addNewParent(content, _nextSibling, newSpanElement);
                    }
                }
                TextContentTraverser.formatDescendants(content, newSpanElement, charFormatChanges != null && charFormatChanges.has("url"), xmlDoc, formatChanges, formatElementHolder);
            }
        }

        private static boolean isOfficeAnnotationChild(NodeImpl element) {
            return TextContentTraverser.isOfficeAnnotationChild(element, 4);
        }

        private static boolean isOfficeAnnotationChild(NodeImpl element, int rec) {
            if (null != element) {
                if (element instanceof OfficeAnnotationElement) {
                    return true;
                }
                if (rec > 0 && element instanceof OdfElement) {
                    return TextContentTraverser.isOfficeAnnotationChild(((OdfElement)element).ownerNode, rec - 1);
                }
                return false;
            }
            return false;
        }

        private static void formatDescendants(Node content, TextSpanElement newSpan, boolean removeAnchors, OdfFileDom ownerDoc, JSONObject formatChanges, Map<OdfName, OdfElement> formatElementHolder) {
            if (content instanceof TextSpanElement) {
                TextContentTraverser.mergeSpans((TextSpanElement)((Object)content), newSpan, ownerDoc, formatChanges, formatElementHolder);
            }
            while (content instanceof TextAElement && removeAnchors) {
                if (!((content = TextContentTraverser.removeSingleNode(content, content.getNextSibling())) instanceof TextSpanElement)) continue;
                TextContentTraverser.mergeSpans((TextSpanElement)((Object)content), newSpan, ownerDoc, formatChanges, formatElementHolder);
            }
            if (content.hasChildNodes()) {
                NodeList children = content.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (!(child instanceof Element)) continue;
                    TextContentTraverser.formatDescendants(child, newSpan, removeAnchors, ownerDoc, formatChanges, formatElementHolder);
                }
            }
        }

        private static TextSpanElement mergeSpans(TextSpanElement content, TextSpanElement newSpan, OdfFileDom ownerDoc, JSONObject formatChanges, Map<OdfName, OdfElement> formatElementHolder) {
            if (newSpan != null && content != newSpan) {
                String originalStyleName = newSpan.getStyleName();
                content = (TextSpanElement)OdfStyle.mergeSelectionWithSameRange(newSpan, content);
                String mergedStyleName = newSpan.getStyleName();
                if (!originalStyleName.equals(mergedStyleName)) {
                    TextSpanElement originSpan = new TextSpanElement(ownerDoc);
                    originSpan.setAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "text:style-name", originalStyleName);
                    formatElementHolder.put(TextSpanElement.ELEMENT_NAME, originSpan);
                }
            }
            JsonOperationConsumer.addStyle(formatChanges, content, ownerDoc);
            return content;
        }

        private static void addNewParent(Node existingChild, Node _nextSibling, OdfElement newParent) {
            Node parent = existingChild.getParentNode();
            parent.removeChild(existingChild);
            newParent.appendChild(existingChild);
            if (_nextSibling != null) {
                parent.insertBefore((Node)((Object)newParent), _nextSibling);
            } else {
                parent.appendChild((Node)((Object)newParent));
            }
        }

        private static Node removeSingleNode(Node oldNode, Node _nextSibling) {
            Node parent = oldNode.getParentNode();
            Node _firstChild = null;
            if (oldNode.hasChildNodes()) {
                NodeList children = oldNode.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (i == 0) {
                        _firstChild = child;
                    }
                    if (_nextSibling != null) {
                        parent.insertBefore(child, _nextSibling);
                        continue;
                    }
                    parent.appendChild(child);
                }
            }
            parent.removeChild(oldNode);
            return _firstChild;
        }

        static enum Algorithm {
            INSERT(1),
            DELETE(2),
            MARK(3),
            RECEIVE(4),
            MOVE(5),
            COUNT(6);

            private int mId;

            private Algorithm(int id) {
                this.mId = id;
            }

            int execute(Node currentNode, int currentPos, int posStart, int posEnd, Object ... content) {
                switch (this.mId) {
                    case 1: {
                        currentPos = this.insert(currentNode, currentPos, posStart, posEnd, (List)content[0]);
                        break;
                    }
                    case 2: {
                        currentPos = this.delete(currentNode, currentPos, posStart, posEnd, (List)content[0]);
                        break;
                    }
                    case 3: {
                        currentPos = this.mark(currentNode, currentPos, posStart, posEnd, (JSONObject)content[0], (Map)content[1]);
                        break;
                    }
                    case 4: {
                        currentPos = this.receive(currentNode, currentPos, posStart, posEnd, (ArrayList)content[0]);
                        break;
                    }
                    case 5: {
                        this.moveChildrenTo(currentNode, currentPos, posStart, posEnd, (Element)content[0]);
                        break;
                    }
                    case 6: {
                        currentPos = this.count(currentNode, currentPos, (Boolean)content[1]);
                    }
                }
                return currentPos;
            }

            int mark(Node currentNode, int currentPos, int posStart, int posEnd, JSONObject formatChanges, Map<OdfName, OdfElement> formatElementHolder) {
                if (currentNode != null) {
                    boolean needsSplit;
                    Integer nextSplitPos = currentPos >= posStart ? Integer.valueOf(posEnd) : Integer.valueOf(posStart);
                    Integer contentLength = OdfElement.getNodeWidth(currentNode);
                    boolean isTotalSelection = currentPos + contentLength == nextSplitPos && nextSplitPos == posEnd;
                    boolean isFirstPart = currentPos >= posStart && currentPos + contentLength < posEnd;
                    boolean bl = needsSplit = currentPos + contentLength > nextSplitPos;
                    if (isTotalSelection || isFirstPart) {
                        Node _nextSibling = currentNode.getNextSibling();
                        TextContentTraverser.formatContent(currentNode, _nextSibling, formatChanges, formatElementHolder);
                        currentPos += contentLength.intValue();
                    } else if (needsSplit) {
                        boolean reachedStartPosition;
                        int secondPartLength = 1;
                        Object secondPart = null;
                        if (currentNode instanceof Text) {
                            secondPart = ((Text)currentNode).splitText(nextSplitPos - currentPos);
                            secondPartLength = secondPart.getLength();
                        } else {
                            secondPart = ((OdfElement)((Object)currentNode)).split(nextSplitPos - currentPos);
                            secondPartLength = OdfElement.getNodeWidth((Node)secondPart);
                        }
                        boolean bl2 = reachedStartPosition = nextSplitPos != posEnd;
                        if (reachedStartPosition) {
                            if (currentPos + (contentLength - secondPartLength) == posEnd) {
                                TextContentTraverser.formatContent((Node)secondPart, secondPart.getNextSibling(), formatChanges, formatElementHolder);
                                currentPos += contentLength.intValue();
                            } else {
                                currentPos += contentLength - secondPartLength;
                                currentPos = this.mark((Node)secondPart, currentPos, posStart, posEnd, formatChanges, formatElementHolder);
                            }
                        } else {
                            TextContentTraverser.formatContent(currentNode, (Node)secondPart, formatChanges, formatElementHolder);
                            currentPos += contentLength - secondPartLength;
                        }
                    } else {
                        currentPos += contentLength.intValue();
                    }
                }
                return currentPos;
            }

            int insert(Node currentNode, int currentPos, int posStart, int posEnd, List content) {
                if (currentNode != null) {
                    Integer contentLength = 1;
                    contentLength = currentNode instanceof Text ? Integer.valueOf(((Text)currentNode).getLength()) : Integer.valueOf(((OdfElement)((Object)currentNode)).getRepetition());
                    if (currentPos == posStart) {
                        Node parent = currentNode.getParentNode();
                        Object newData = content.get(0);
                        if (newData instanceof String) {
                            OdfElement.appendUsingWhitespaceHandling(null, (OdfElement)((Object)parent), currentNode, (String)newData);
                        } else if (content.get(0) instanceof Element) {
                            OdfElement.addElementNode(null, (OdfElement)((Object)parent), currentNode, (Element)content.get(0));
                        }
                        content.add(Boolean.TRUE);
                        currentPos += contentLength.intValue();
                    } else if (currentPos + contentLength >= posStart) {
                        if (currentPos + contentLength == posStart) {
                            Object newData = content.get(0);
                            if (newData instanceof String) {
                                OdfElement.appendUsingWhitespaceHandling(currentNode, (OdfElement)((Object)currentNode.getParentNode()), currentNode.getNextSibling(), (String)newData);
                            } else if (newData instanceof Element) {
                                OdfElement.addElementNode(currentNode, (OdfElement)((Object)currentNode.getParentNode()), currentNode.getNextSibling(), (Element)newData);
                            }
                            content.add(Boolean.TRUE);
                            currentPos = posStart;
                        } else {
                            Object secondPart = null;
                            if (currentNode instanceof Text) {
                                secondPart = ((Text)currentNode).splitText(posStart - currentPos);
                                Object newData = content.get(0);
                                if (newData instanceof String) {
                                    OdfElement.appendUsingWhitespaceHandling(currentNode, (OdfElement)((Object)currentNode.getParentNode()), secondPart, (String)newData);
                                } else if (content instanceof Element) {
                                    OdfElement.addElementNode(currentNode, (OdfElement)((Object)currentNode.getParentNode()), (Node)secondPart, (Element)((Object)content));
                                }
                                content.add(Boolean.TRUE);
                            } else {
                                secondPart = ((OdfElement)((Object)currentNode)).split(posStart - currentPos);
                                Node parent = currentNode.getParentNode();
                                Object newData = content.get(0);
                                if (newData instanceof String) {
                                    OdfElement.appendUsingWhitespaceHandling(currentNode, (OdfElement)((Object)parent), secondPart, (String)newData);
                                } else if (content instanceof Element) {
                                    OdfElement.addElementNode(currentNode, (OdfElement)((Object)parent), (Node)secondPart, (Element)((Object)content));
                                }
                                content.add(Boolean.TRUE);
                            }
                            currentPos += contentLength.intValue();
                        }
                    } else {
                        currentPos += contentLength.intValue();
                    }
                }
                return currentPos;
            }

            int delete(Node currentNode, int currentPos, int posStart, int posEnd, List deleteStatus) {
                if (currentNode != null) {
                    boolean needsSplit;
                    Integer nextSplitPos = currentPos >= posStart ? Integer.valueOf(posEnd) : Integer.valueOf(posStart);
                    Integer contentLength = OdfElement.getNodeWidth(currentNode);
                    boolean inExecutionMode = currentPos >= posStart && contentLength + currentPos > posStart && currentPos + contentLength <= posEnd;
                    boolean bl = needsSplit = currentPos + contentLength > nextSplitPos && nextSplitPos - currentPos != 0;
                    if (inExecutionMode) {
                        OdfElement grandParent;
                        OdfElement parent = (OdfElement)((Object)currentNode.getParentNode());
                        parent.removeChild(currentNode);
                        deleteStatus.add(0, Boolean.TRUE);
                        int childCount = parent.countDescendantComponents();
                        while (!parent.isComponentRoot() && childCount == 0 && !((grandParent = (OdfElement)((Object)parent.getParentNode())) instanceof OfficeBodyElement)) {
                            String styleName = parent.getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name");
                            if (parent instanceof TextSpanElement && grandParent instanceof TextParagraphElementBase && childCount == 0 && grandParent.getChildNodes().getLength() == 1 && styleName != null) {
                                this.copyTextProperties(styleName, grandParent);
                            }
                            grandParent.removeChild((Node)((Object)parent));
                            parent = grandParent;
                            childCount = parent.countDescendantComponents();
                        }
                        currentPos += contentLength.intValue();
                    } else if (needsSplit) {
                        boolean reachedStartPosition;
                        int secondPartLength = 1;
                        Object secondPart = null;
                        if (currentNode instanceof Text) {
                            secondPart = ((Text)currentNode).splitText(nextSplitPos - currentPos);
                            secondPartLength = secondPart.getLength();
                        } else {
                            secondPart = ((OdfElement)((Object)currentNode)).split(nextSplitPos - currentPos);
                            secondPartLength = OdfElement.getNodeWidth((Node)secondPart);
                        }
                        boolean bl2 = reachedStartPosition = nextSplitPos != posEnd;
                        if (reachedStartPosition) {
                            if (currentPos + (contentLength - secondPartLength) == posEnd) {
                                OdfElement grandParent;
                                OdfElement parent = (OdfElement)((Object)currentNode.getParentNode());
                                parent.removeChild((Node)secondPart);
                                deleteStatus.add(0, Boolean.TRUE);
                                while (!parent.isComponentRoot() && parent.countDescendantComponents() == 0 && !((grandParent = (OdfElement)((Object)parent.getParentNode())) instanceof OfficeBodyElement)) {
                                    grandParent.removeChild((Node)((Object)parent));
                                    parent = grandParent;
                                }
                                currentPos += contentLength.intValue();
                            } else {
                                currentPos += contentLength - secondPartLength;
                                currentPos = this.delete((Node)secondPart, currentPos, posStart, posEnd, deleteStatus);
                            }
                        } else {
                            OdfElement grandParent;
                            OdfElement parent = (OdfElement)((Object)currentNode.getParentNode());
                            parent.removeChild(currentNode);
                            deleteStatus.add(0, Boolean.TRUE);
                            while (!parent.isComponentRoot() && parent.countDescendantComponents() == 0 && !((grandParent = (OdfElement)((Object)parent.getParentNode())) instanceof OfficeBodyElement)) {
                                grandParent.removeChild((Node)((Object)parent));
                                parent = grandParent;
                            }
                            currentPos += contentLength - secondPartLength;
                        }
                    } else {
                        currentPos += contentLength.intValue();
                    }
                }
                return currentPos;
            }

            private void copyTextProperties(String sourceStyleName, OdfElement targetElement) {
                OdfStylePropertiesBase textProps;
                OdfOfficeAutomaticStyles autoStyles = null;
                autoStyles = targetElement.ownerDocument instanceof OdfContentDom ? ((OdfContentDom)targetElement.ownerDocument).getAutomaticStyles() : ((OdfStylesDom)targetElement.ownerDocument).getAutomaticStyles();
                OdfStyle spanStyle = autoStyles.getStyle(sourceStyleName, OdfStyleFamily.Text);
                if (spanStyle != null && (textProps = spanStyle.getPropertiesElement(OdfStylePropertiesSet.TextProperties)) != null && ((OdfElement)textProps).attributes != null && ((OdfElement)textProps).attributes.getLength() > 0) {
                    StyleStyleElement paraStyle = ((TextParagraphElementBase)targetElement).getOrCreateUnqiueAutomaticStyle();
                    OdfStylePropertiesBase paraTextProps = paraStyle.getPropertiesElement(OdfStylePropertiesSet.TextProperties);
                    if (paraTextProps == null) {
                        paraTextProps = ((OdfFileDom)targetElement.ownerDocument).newOdfElement(StyleTextPropertiesElement.class);
                        paraStyle.appendChild((Node)((Object)paraTextProps));
                    }
                    for (int i = 0; i < ((OdfElement)textProps).attributes.getLength(); ++i) {
                        Attr attr = (Attr)((OdfElement)textProps).attributes.item(i);
                        String ns = attr.getNamespaceURI();
                        String prefix = attr.getPrefix();
                        String localName = attr.getLocalName();
                        paraTextProps.setAttributeNS(ns, prefix + ":" + localName, attr.getValue());
                    }
                }
            }

            private int receive(Node currentNode, int currentPos, int posStart, int posEnd, ArrayList newNodeContainer) {
                if (currentNode != null) {
                    Integer contentLength = 1;
                    contentLength = currentNode instanceof Text ? Integer.valueOf(((Text)currentNode).getLength()) : Integer.valueOf(((OdfElement)((Object)currentNode)).getRepetition());
                    if (currentPos == posStart && (contentLength == 1 || currentNode instanceof Text)) {
                        newNodeContainer.add(currentNode);
                        currentPos = posEnd;
                    } else if (currentPos + contentLength > posStart) {
                        Object secondPart = null;
                        if (currentNode instanceof Text) {
                            secondPart = ((Text)currentNode).splitText(posStart - currentPos);
                            newNodeContainer.add(secondPart);
                        } else {
                            OdfElement thirdPart = null;
                            Node parent = ((OdfElement)((Object)currentNode)).getParentNode();
                            secondPart = ((OdfElement)((Object)currentNode)).split(posStart - currentPos);
                            if (((OdfElement)((Object)secondPart)).getRepetition() > 1) {
                                thirdPart = ((OdfElement)((Object)secondPart)).split(1);
                            }
                            newNodeContainer.add(secondPart);
                        }
                        currentPos = posEnd;
                    } else {
                        currentPos += contentLength.intValue();
                    }
                }
                return currentPos;
            }

            private void moveChildrenTo(Node currentNode, int currentPos, int posStart, int posEnd, Element newParent) {
                if (currentNode != null) {
                    newParent.appendChild(currentNode);
                }
            }

            private int count(Node currentNode, int currentPos, Boolean isTextCounting) {
                if (currentNode != null) {
                    Integer contentLength = 1;
                    if (!(currentNode instanceof Text)) {
                        contentLength = ((OdfElement)((Object)currentNode)).getRepetition();
                    } else if ((isTextCounting == null || isTextCounting.booleanValue()) && ((Text)currentNode).toString().trim().length() > 0) {
                        contentLength = ((Text)currentNode).getLength();
                    }
                    currentPos += contentLength.intValue();
                }
                return currentPos;
            }
        }
    }
}

