/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.office;

import java.util.ArrayList;
import java.util.HashMap;
import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.draw.DrawFillImageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawGradientElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawHatchElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawMarkerElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawOpacityElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawStrokeDashElement;
import org.odftoolkit.odfdom.dom.element.number.NumberBooleanStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberCurrencyStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberDateStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberNumberStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberPercentageStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTextStyleElement;
import org.odftoolkit.odfdom.dom.element.number.NumberTimeStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StylePresentationPageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgLinearGradientElement;
import org.odftoolkit.odfdom.dom.element.svg.SvgRadialGradientElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableTemplateElement;
import org.odftoolkit.odfdom.dom.element.text.TextBibliographyConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.TextLinenumberingConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.TextListStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextNotesConfigurationElement;
import org.odftoolkit.odfdom.dom.element.text.TextOutlineStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfStylesBase;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextOutlineStyle;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class OdfOfficeStyles
extends OdfStylesBase {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.OFFICE, "styles");
    private static final long serialVersionUID = 700763983193326060L;
    private HashMap<OdfStyleFamily, OdfDefaultStyle> mDefaultStyles;
    private HashMap<String, DrawMarkerElement> mMarker;
    private HashMap<String, DrawGradientElement> mGradients;
    private HashMap<String, DrawHatchElement> mHatches;
    private HashMap<String, DrawFillImageElement> mFillImages;
    private OdfTextOutlineStyle mOutlineStyle;

    public OdfOfficeStyles(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    @Override
    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public OdfDefaultStyle getOrCreateDefaultStyle(OdfStyleFamily family) {
        OdfDefaultStyle style = this.getDefaultStyle(family);
        if (style == null) {
            style = ((OdfFileDom)this.ownerDocument).newOdfElement(OdfDefaultStyle.class);
            style.setStyleFamilyAttribute(family.getName());
            this.appendChild((Node)((Object)style));
        }
        return style;
    }

    public OdfTextListStyle newListStyle(String name) {
        OdfTextListStyle newStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(OdfTextListStyle.class);
        newStyle.setStyleNameAttribute(name);
        this.appendChild((Node)((Object)newStyle));
        return newStyle;
    }

    public OdfTextOutlineStyle getOrCreateOutlineStyle() {
        if (this.mOutlineStyle == null) {
            this.appendChild((Node)((Object)((OdfFileDom)this.ownerDocument).newOdfElement(OdfTextOutlineStyle.class)));
        }
        return this.mOutlineStyle;
    }

    public OdfTextOutlineStyle getOutlineStyle() {
        return this.mOutlineStyle;
    }

    public OdfDefaultStyle getDefaultStyle(OdfStyleFamily familyType) {
        if (this.mDefaultStyles != null) {
            return this.mDefaultStyles.get(familyType);
        }
        return null;
    }

    public Iterable<OdfDefaultStyle> getDefaultStyles() {
        if (this.mDefaultStyles != null) {
            return this.mDefaultStyles.values();
        }
        return new ArrayList<OdfDefaultStyle>();
    }

    public DrawMarkerElement getMarker(String name) {
        if (this.mMarker != null) {
            return this.mMarker.get(name);
        }
        return null;
    }

    public Iterable<DrawMarkerElement> getMarker() {
        if (this.mMarker != null) {
            return this.mMarker.values();
        }
        return new ArrayList<DrawMarkerElement>();
    }

    public DrawGradientElement getGradient(String name) {
        if (this.mGradients != null) {
            return this.mGradients.get(name);
        }
        return null;
    }

    public Iterable<DrawGradientElement> getGradients() {
        if (this.mGradients != null) {
            return this.mGradients.values();
        }
        return new ArrayList<DrawGradientElement>();
    }

    public DrawHatchElement getHatch(String name) {
        if (this.mHatches != null) {
            return this.mHatches.get(name);
        }
        return null;
    }

    public Iterable<DrawHatchElement> getHatches() {
        if (this.mHatches != null) {
            return this.mHatches.values();
        }
        return new ArrayList<DrawHatchElement>();
    }

    public DrawFillImageElement getFillImage(String name) {
        if (this.mFillImages != null) {
            return this.mFillImages.get(name);
        }
        return null;
    }

    public Iterable<DrawFillImageElement> getFillImages() {
        if (this.mFillImages != null) {
            return this.mFillImages.values();
        }
        return new ArrayList<DrawFillImageElement>();
    }

    @Override
    public void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof OdfDefaultStyle) {
            OdfDefaultStyle defaultStyle = (OdfDefaultStyle)node;
            if (this.mDefaultStyles == null) {
                this.mDefaultStyles = new HashMap();
            }
            this.mDefaultStyles.put(defaultStyle.getFamily(), defaultStyle);
        } else if (node instanceof DrawMarkerElement) {
            DrawMarkerElement marker = (DrawMarkerElement)node;
            if (this.mMarker == null) {
                this.mMarker = new HashMap();
            }
            this.mMarker.put(marker.getDrawNameAttribute(), marker);
        } else if (node instanceof DrawGradientElement) {
            DrawGradientElement gradient = (DrawGradientElement)node;
            if (this.mGradients == null) {
                this.mGradients = new HashMap();
            }
            this.mGradients.put(gradient.getDrawNameAttribute(), gradient);
        } else if (node instanceof DrawHatchElement) {
            DrawHatchElement hatch = (DrawHatchElement)node;
            if (this.mHatches == null) {
                this.mHatches = new HashMap();
            }
            this.mHatches.put(hatch.getDrawNameAttribute(), hatch);
        } else if (node instanceof DrawFillImageElement) {
            DrawFillImageElement fillImage = (DrawFillImageElement)node;
            if (this.mFillImages == null) {
                this.mFillImages = new HashMap();
            }
            this.mFillImages.put(fillImage.getDrawNameAttribute(), fillImage);
        } else if (node instanceof OdfTextOutlineStyle) {
            this.mOutlineStyle = (OdfTextOutlineStyle)node;
        } else {
            super.onOdfNodeInserted(node, refNode);
        }
    }

    @Override
    public void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof OdfDefaultStyle) {
            if (this.mDefaultStyles != null) {
                OdfDefaultStyle defaultStyle = (OdfDefaultStyle)node;
                this.mDefaultStyles.remove(defaultStyle.getFamily());
            }
        } else if (node instanceof DrawMarkerElement) {
            if (this.mMarker != null) {
                DrawMarkerElement marker = (DrawMarkerElement)node;
                this.mMarker.remove(marker.getDrawNameAttribute());
            }
        } else if (node instanceof DrawGradientElement) {
            if (this.mGradients != null) {
                DrawGradientElement gradient = (DrawGradientElement)node;
                this.mGradients.remove(gradient.getDrawNameAttribute());
            }
        } else if (node instanceof DrawHatchElement) {
            if (this.mHatches != null) {
                DrawHatchElement hatch = (DrawHatchElement)node;
                this.mHatches.remove(hatch.getDrawNameAttribute());
            }
        } else if (node instanceof DrawFillImageElement) {
            if (this.mFillImages != null) {
                DrawFillImageElement fillImage = (DrawFillImageElement)node;
                this.mFillImages.remove(fillImage.getDrawNameAttribute());
            }
        } else if (node instanceof OdfTextOutlineStyle) {
            if (this.mOutlineStyle == (OdfTextOutlineStyle)node) {
                this.mOutlineStyle = null;
            }
        } else {
            super.onOdfNodeRemoved(node);
        }
    }

    @Override
    protected <T extends OdfElement> T getStylesElement(OdfFileDom dom, Class<T> clazz) throws Exception {
        OdfElement stylesRoot = dom.getRootElement();
        OdfOfficeStyles contentBody = OdfElement.findFirstChildNode(OdfOfficeStyles.class, (Node)((Object)stylesRoot));
        NodeList childs = contentBody.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node cur = childs.item(i);
            if (cur == null || !clazz.isInstance(cur)) continue;
            return (T)((Object)((OdfElement)((Object)cur)));
        }
        return null;
    }

    public DrawFillImageElement newDrawFillImageElement(String drawNameValue, String xlinkHrefValue, String xlinkTypeValue) {
        DrawFillImageElement drawFillImage = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawFillImageElement.class);
        drawFillImage.setDrawNameAttribute(drawNameValue);
        drawFillImage.setXlinkHrefAttribute(xlinkHrefValue);
        drawFillImage.setXlinkTypeAttribute(xlinkTypeValue);
        this.appendChild((Node)((Object)drawFillImage));
        return drawFillImage;
    }

    public DrawGradientElement newDrawGradientElement(String drawStyleValue) {
        DrawGradientElement drawGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawGradientElement.class);
        drawGradient.setDrawStyleAttribute(drawStyleValue);
        this.appendChild((Node)((Object)drawGradient));
        return drawGradient;
    }

    public DrawHatchElement newDrawHatchElement(String drawNameValue, String drawStyleValue) {
        DrawHatchElement drawHatch = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawHatchElement.class);
        drawHatch.setDrawNameAttribute(drawNameValue);
        drawHatch.setDrawStyleAttribute(drawStyleValue);
        this.appendChild((Node)((Object)drawHatch));
        return drawHatch;
    }

    public DrawMarkerElement newDrawMarkerElement(String drawNameValue, String svgDValue, int svgViewBoxValue) {
        DrawMarkerElement drawMarker = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawMarkerElement.class);
        drawMarker.setDrawNameAttribute(drawNameValue);
        drawMarker.setSvgDAttribute(svgDValue);
        drawMarker.setSvgViewBoxAttribute(svgViewBoxValue);
        this.appendChild((Node)((Object)drawMarker));
        return drawMarker;
    }

    public DrawOpacityElement newDrawOpacityElement(String drawStyleValue) {
        DrawOpacityElement drawOpacity = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawOpacityElement.class);
        drawOpacity.setDrawStyleAttribute(drawStyleValue);
        this.appendChild((Node)((Object)drawOpacity));
        return drawOpacity;
    }

    public DrawStrokeDashElement newDrawStrokeDashElement(String drawNameValue) {
        DrawStrokeDashElement drawStrokeDash = ((OdfFileDom)this.ownerDocument).newOdfElement(DrawStrokeDashElement.class);
        drawStrokeDash.setDrawNameAttribute(drawNameValue);
        this.appendChild((Node)((Object)drawStrokeDash));
        return drawStrokeDash;
    }

    public NumberBooleanStyleElement newNumberBooleanStyleElement(String styleNameValue) {
        NumberBooleanStyleElement numberBooleanStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberBooleanStyleElement.class);
        numberBooleanStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberBooleanStyle));
        return numberBooleanStyle;
    }

    public NumberCurrencyStyleElement newNumberCurrencyStyleElement(String styleNameValue) {
        NumberCurrencyStyleElement numberCurrencyStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberCurrencyStyleElement.class);
        numberCurrencyStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberCurrencyStyle));
        return numberCurrencyStyle;
    }

    public NumberDateStyleElement newNumberDateStyleElement(String styleNameValue) {
        NumberDateStyleElement numberDateStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberDateStyleElement.class);
        numberDateStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberDateStyle));
        return numberDateStyle;
    }

    public NumberNumberStyleElement newNumberNumberStyleElement(String styleNameValue) {
        NumberNumberStyleElement numberNumberStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberNumberStyleElement.class);
        numberNumberStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberNumberStyle));
        return numberNumberStyle;
    }

    public NumberPercentageStyleElement newNumberPercentageStyleElement(String styleNameValue) {
        NumberPercentageStyleElement numberPercentageStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberPercentageStyleElement.class);
        numberPercentageStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberPercentageStyle));
        return numberPercentageStyle;
    }

    public NumberTextStyleElement newNumberTextStyleElement(String styleNameValue) {
        NumberTextStyleElement numberTextStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTextStyleElement.class);
        numberTextStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberTextStyle));
        return numberTextStyle;
    }

    public NumberTimeStyleElement newNumberTimeStyleElement(String styleNameValue) {
        NumberTimeStyleElement numberTimeStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(NumberTimeStyleElement.class);
        numberTimeStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)numberTimeStyle));
        return numberTimeStyle;
    }

    public StyleDefaultPageLayoutElement newStyleDefaultPageLayoutElement() {
        StyleDefaultPageLayoutElement styleDefaultPageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleDefaultPageLayoutElement.class);
        this.appendChild((Node)((Object)styleDefaultPageLayout));
        return styleDefaultPageLayout;
    }

    public StyleDefaultStyleElement newStyleDefaultStyleElement(String styleFamilyValue) {
        StyleDefaultStyleElement styleDefaultStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleDefaultStyleElement.class);
        styleDefaultStyle.setStyleFamilyAttribute(styleFamilyValue);
        this.appendChild((Node)((Object)styleDefaultStyle));
        return styleDefaultStyle;
    }

    public StylePresentationPageLayoutElement newStylePresentationPageLayoutElement(String styleNameValue) {
        StylePresentationPageLayoutElement stylePresentationPageLayout = ((OdfFileDom)this.ownerDocument).newOdfElement(StylePresentationPageLayoutElement.class);
        stylePresentationPageLayout.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)stylePresentationPageLayout));
        return stylePresentationPageLayout;
    }

    public StyleStyleElement newStyleStyleElement(String styleFamilyValue, String styleNameValue) {
        StyleStyleElement styleStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleStyleElement.class);
        styleStyle.setStyleFamilyAttribute(styleFamilyValue);
        styleStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)styleStyle));
        return styleStyle;
    }

    public SvgLinearGradientElement newSvgLinearGradientElement(String drawNameValue) {
        SvgLinearGradientElement svgLinearGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(SvgLinearGradientElement.class);
        svgLinearGradient.setDrawNameAttribute(drawNameValue);
        this.appendChild((Node)((Object)svgLinearGradient));
        return svgLinearGradient;
    }

    public SvgRadialGradientElement newSvgRadialGradientElement(String drawNameValue) {
        SvgRadialGradientElement svgRadialGradient = ((OdfFileDom)this.ownerDocument).newOdfElement(SvgRadialGradientElement.class);
        svgRadialGradient.setDrawNameAttribute(drawNameValue);
        this.appendChild((Node)((Object)svgRadialGradient));
        return svgRadialGradient;
    }

    public TableTableTemplateElement newTableTableTemplateElement(String tableFirstRowEndColumnValue, String tableFirstRowStartColumnValue, String tableLastRowEndColumnValue, String tableLastRowStartColumnValue, String tableNameValue) {
        TableTableTemplateElement tableTableTemplate = ((OdfFileDom)this.ownerDocument).newOdfElement(TableTableTemplateElement.class);
        tableTableTemplate.setTableFirstRowEndColumnAttribute(tableFirstRowEndColumnValue);
        tableTableTemplate.setTableFirstRowStartColumnAttribute(tableFirstRowStartColumnValue);
        tableTableTemplate.setTableLastRowEndColumnAttribute(tableLastRowEndColumnValue);
        tableTableTemplate.setTableLastRowStartColumnAttribute(tableLastRowStartColumnValue);
        tableTableTemplate.setTableNameAttribute(tableNameValue);
        this.appendChild((Node)((Object)tableTableTemplate));
        return tableTableTemplate;
    }

    public TextBibliographyConfigurationElement newTextBibliographyConfigurationElement() {
        TextBibliographyConfigurationElement textBibliographyConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextBibliographyConfigurationElement.class);
        this.appendChild((Node)((Object)textBibliographyConfiguration));
        return textBibliographyConfiguration;
    }

    public TextLinenumberingConfigurationElement newTextLinenumberingConfigurationElement(String styleNumFormatValue) {
        TextLinenumberingConfigurationElement textLinenumberingConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextLinenumberingConfigurationElement.class);
        textLinenumberingConfiguration.setStyleNumFormatAttribute(styleNumFormatValue);
        this.appendChild((Node)((Object)textLinenumberingConfiguration));
        return textLinenumberingConfiguration;
    }

    public TextListStyleElement newTextListStyleElement(String styleNameValue) {
        TextListStyleElement textListStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextListStyleElement.class);
        textListStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)textListStyle));
        return textListStyle;
    }

    public TextNotesConfigurationElement newTextNotesConfigurationElement(String styleNumFormatValue, String textNoteClassValue) {
        TextNotesConfigurationElement textNotesConfiguration = ((OdfFileDom)this.ownerDocument).newOdfElement(TextNotesConfigurationElement.class);
        textNotesConfiguration.setStyleNumFormatAttribute(styleNumFormatValue);
        textNotesConfiguration.setTextNoteClassAttribute(textNoteClassValue);
        this.appendChild((Node)((Object)textNotesConfiguration));
        return textNotesConfiguration;
    }

    public TextOutlineStyleElement newTextOutlineStyleElement(String styleNameValue) {
        TextOutlineStyleElement textOutlineStyle = ((OdfFileDom)this.ownerDocument).newOdfElement(TextOutlineStyleElement.class);
        textOutlineStyle.setStyleNameAttribute(styleNameValue);
        this.appendChild((Node)((Object)textOutlineStyle));
        return textOutlineStyle;
    }

    @Override
    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

