/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.odftoolkit.odfdom.doc.OdfChartDocument;
import org.odftoolkit.odfdom.doc.OdfGraphicsDocument;
import org.odftoolkit.odfdom.doc.OdfImageDocument;
import org.odftoolkit.odfdom.doc.OdfPresentationDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorTypeAttribute;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentContentElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfTextProperties;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawFrame;
import org.odftoolkit.odfdom.incubator.doc.draw.OdfDrawImage;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfDefaultStyle;
import org.odftoolkit.odfdom.incubator.meta.OdfOfficeMeta;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfdom.type.Duration;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class OdfDocument
extends OdfSchemaDocument {
    private static final String SLASH = "/";
    private OdfMediaType mMediaType;
    private OdfOfficeMeta mOfficeMeta;
    private long documentOpeningTime;
    private static final Pattern CONTROL_CHAR_PATTERN = Pattern.compile("\\p{Cntrl}");
    private static final String EMPTY_STRING = "";
    private Calendar mCreationDate;
    private static final String FORMER_OPEN_OFFICE_VERSION = "StarOffice/8$Win32 OpenOffice.org_project/680m18$Build-9161";
    protected Boolean mHasCollaboration = null;
    private static final HashSet<String> CJKLanguage = new HashSet();
    private static final HashSet<String> CTLLanguage = new HashSet();
    private Set<String> mFontNames;
    private Map<String, OfficeAnnotationElement> annotations;

    protected OdfDocument(OdfPackage pkg, String internalPath, OdfMediaType mediaType) throws SAXException {
        super(pkg, internalPath, mediaType.getMediaTypeString());
        CJKLanguage.add("zh");
        CJKLanguage.add("ja");
        CJKLanguage.add("ko");
        CTLLanguage.add("am");
        CTLLanguage.add("ar");
        CTLLanguage.add("as");
        CTLLanguage.add("bn");
        CTLLanguage.add("bo");
        CTLLanguage.add("brx");
        CTLLanguage.add("dgo");
        CTLLanguage.add("dv");
        CTLLanguage.add("dz");
        CTLLanguage.add("fa");
        CTLLanguage.add("gu");
        CTLLanguage.add("he");
        CTLLanguage.add("hi");
        CTLLanguage.add("km");
        CTLLanguage.add("kn");
        CTLLanguage.add("ks");
        CTLLanguage.add("ku");
        CTLLanguage.add("lo");
        CTLLanguage.add("mai");
        CTLLanguage.add("ml");
        CTLLanguage.add("mn");
        CTLLanguage.add("mni");
        CTLLanguage.add("mr");
        CTLLanguage.add("my");
        CTLLanguage.add("ne");
        CTLLanguage.add("or");
        CTLLanguage.add("pa");
        CTLLanguage.add("sa");
        CTLLanguage.add("sd");
        CTLLanguage.add("si");
        CTLLanguage.add("syr");
        CTLLanguage.add("ta");
        CTLLanguage.add("te");
        CTLLanguage.add("th");
        CTLLanguage.add("ug");
        CTLLanguage.add("ur");
        CTLLanguage.add("yi");
        this.mFontNames = null;
        this.annotations = null;
        this.mMediaType = mediaType;
        this.documentOpeningTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OdfDocument loadTemplate(OdfPackageDocument.Resource res, OdfMediaType odfMediaType) throws Exception {
        OdfPackage pkg = null;
        try (InputStream in = res.createInputStream();){
            pkg = OdfPackage.loadPackage(in);
        }
        OdfDocument newDocument = OdfDocument.newDocument(pkg, EMPTY_STRING, odfMediaType, Boolean.FALSE);
        newDocument.mCreationDate = Calendar.getInstance();
        return newDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OdfDocument loadTemplate(OdfPackageDocument.Resource res, OdfMediaType odfMediaType, Boolean enableCollaboration) throws Exception {
        OdfPackage pkg = null;
        try (InputStream in = res.createInputStream();){
            pkg = OdfPackage.loadPackage(in);
        }
        OdfDocument newDocument = OdfDocument.newDocument(pkg, EMPTY_STRING, odfMediaType, enableCollaboration);
        newDocument.mCreationDate = Calendar.getInstance();
        return newDocument;
    }

    public static OdfDocument loadDocument(String documentPath) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(documentPath));
    }

    public static OdfDocument loadDocument(InputStream inStream, Map<String, Object> configuration) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(inStream, configuration));
    }

    public static OdfDocument loadDocument(InputStream inStream, Map<String, Object> configuration, Boolean enableCollaboration) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(inStream, configuration), enableCollaboration);
    }

    public static OdfDocument loadDocument(InputStream inStream) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(inStream));
    }

    public static OdfDocument loadDocument(InputStream inStream, Boolean enableCollaboration) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(inStream), enableCollaboration);
    }

    public static OdfDocument loadDocument(File file) throws Exception {
        return OdfDocument.loadDocument(OdfPackage.loadPackage(file));
    }

    public static OdfDocument loadDocument(OdfPackage odfPackage) throws Exception {
        return OdfDocument.loadDocument(odfPackage, EMPTY_STRING);
    }

    public static OdfDocument loadDocument(OdfPackage odfPackage, Boolean enableCollaboration) throws Exception {
        return OdfDocument.loadDocument(odfPackage, EMPTY_STRING, enableCollaboration);
    }

    public static OdfDocument loadDocument(OdfPackage odfPackage, String internalPath) throws Exception {
        return OdfDocument.loadDocument(odfPackage, internalPath, Boolean.FALSE);
    }

    public static OdfDocument loadDocument(OdfPackage odfPackage, String internalPath, Boolean enableCollaboration) throws Exception {
        String documentMediaType = odfPackage.getMediaTypeString(internalPath);
        OdfMediaType odfMediaType = null;
        try {
            odfMediaType = OdfMediaType.getOdfMediaType(documentMediaType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (odfMediaType == null) {
            Matcher matcherCTRL;
            ErrorHandler errorHandler = odfPackage.getErrorHandler();
            if (documentMediaType != null && (matcherCTRL = CONTROL_CHAR_PATTERN.matcher(documentMediaType)).find()) {
                documentMediaType = matcherCTRL.replaceAll(EMPTY_STRING);
            }
            OdfValidationException ve = new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_WITHOUT_ODF_MIMETYPE, internalPath, documentMediaType);
            if (errorHandler != null) {
                errorHandler.fatalError(ve);
            }
            throw ve;
        }
        return OdfDocument.newDocument(odfPackage, internalPath, odfMediaType, enableCollaboration);
    }

    private static OdfDocument loadDocumentFromTemplate(OdfMediaType odfMediaType) throws Exception {
        OdfPackageDocument.Resource documentTemplate;
        switch (odfMediaType) {
            case TEXT: 
            case TEXT_TEMPLATE: 
            case TEXT_MASTER: 
            case TEXT_WEB: {
                documentTemplate = OdfTextDocument.EMPTY_TEXT_DOCUMENT_RESOURCE;
                break;
            }
            case SPREADSHEET: 
            case SPREADSHEET_TEMPLATE: {
                documentTemplate = OdfSpreadsheetDocument.EMPTY_SPREADSHEET_DOCUMENT_RESOURCE;
                break;
            }
            case PRESENTATION: 
            case PRESENTATION_TEMPLATE: {
                documentTemplate = OdfPresentationDocument.EMPTY_PRESENTATION_DOCUMENT_RESOURCE;
                break;
            }
            case GRAPHICS: 
            case GRAPHICS_TEMPLATE: {
                documentTemplate = OdfGraphicsDocument.EMPTY_GRAPHICS_DOCUMENT_RESOURCE;
                break;
            }
            case CHART: 
            case CHART_TEMPLATE: {
                documentTemplate = OdfChartDocument.EMPTY_CHART_DOCUMENT_RESOURCE;
                break;
            }
            case IMAGE: 
            case IMAGE_TEMPLATE: {
                documentTemplate = OdfImageDocument.EMPTY_IMAGE_DOCUMENT_RESOURCE;
                break;
            }
            default: {
                Object documentTemplate2 = null;
                throw new IllegalArgumentException("Given mediaType '" + odfMediaType.mMediaType + "' is not yet supported!");
            }
        }
        return OdfDocument.loadTemplate(documentTemplate, odfMediaType);
    }

    private static OdfDocument newDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType, Boolean enableCollaboration) throws SAXException {
        OdfDocument newDoc = null;
        switch (odfMediaType) {
            case TEXT: {
                newDoc = new OdfTextDocument(pkg, internalPath, OdfTextDocument.OdfMediaType.TEXT, enableCollaboration);
                break;
            }
            case TEXT_TEMPLATE: {
                newDoc = new OdfTextDocument(pkg, internalPath, OdfTextDocument.OdfMediaType.TEXT_TEMPLATE, enableCollaboration);
                break;
            }
            case TEXT_MASTER: {
                newDoc = new OdfTextDocument(pkg, internalPath, OdfTextDocument.OdfMediaType.TEXT_MASTER, enableCollaboration);
                break;
            }
            case TEXT_WEB: {
                newDoc = new OdfTextDocument(pkg, internalPath, OdfTextDocument.OdfMediaType.TEXT_WEB, enableCollaboration);
                break;
            }
            case SPREADSHEET: {
                newDoc = new OdfSpreadsheetDocument(pkg, internalPath, OdfSpreadsheetDocument.OdfMediaType.SPREADSHEET);
                break;
            }
            case SPREADSHEET_TEMPLATE: {
                newDoc = new OdfSpreadsheetDocument(pkg, internalPath, OdfSpreadsheetDocument.OdfMediaType.SPREADSHEET_TEMPLATE);
                break;
            }
            case PRESENTATION: {
                newDoc = new OdfPresentationDocument(pkg, internalPath, OdfPresentationDocument.OdfMediaType.PRESENTATION);
                break;
            }
            case PRESENTATION_TEMPLATE: {
                newDoc = new OdfPresentationDocument(pkg, internalPath, OdfPresentationDocument.OdfMediaType.PRESENTATION_TEMPLATE);
                break;
            }
            case GRAPHICS: {
                newDoc = new OdfGraphicsDocument(pkg, internalPath, OdfGraphicsDocument.OdfMediaType.GRAPHICS);
                break;
            }
            case GRAPHICS_TEMPLATE: {
                newDoc = new OdfGraphicsDocument(pkg, internalPath, OdfGraphicsDocument.OdfMediaType.GRAPHICS_TEMPLATE);
                break;
            }
            case CHART: {
                newDoc = new OdfChartDocument(pkg, internalPath, OdfChartDocument.OdfMediaType.CHART);
                break;
            }
            case CHART_TEMPLATE: {
                newDoc = new OdfChartDocument(pkg, internalPath, OdfChartDocument.OdfMediaType.CHART_TEMPLATE);
                break;
            }
            case IMAGE: {
                newDoc = new OdfImageDocument(pkg, internalPath, OdfImageDocument.OdfMediaType.IMAGE);
                break;
            }
            case IMAGE_TEMPLATE: {
                newDoc = new OdfImageDocument(pkg, internalPath, OdfImageDocument.OdfMediaType.IMAGE_TEMPLATE);
                break;
            }
            default: {
                newDoc = null;
                throw new IllegalArgumentException("Given mediaType '" + odfMediaType.mMediaType + "' is not yet supported!");
            }
        }
        return newDoc;
    }

    @Override
    public OdfDocument loadSubDocument(String documentPath) {
        return (OdfDocument)super.loadSubDocument(documentPath);
    }

    public Map<String, OdfDocument> loadSubDocuments() {
        return this.loadSubDocuments(null);
    }

    public Map<String, OdfDocument> loadSubDocuments(OdfMediaType desiredMediaType) {
        String wantedMediaString = null;
        if (desiredMediaType != null) {
            wantedMediaString = desiredMediaType.getMediaTypeString();
        }
        HashMap<String, OdfDocument> embeddedObjectsMap = new HashMap<String, OdfDocument>();
        Set<String> manifestEntries = this.mPackage.getFilePaths();
        for (String path : manifestEntries) {
            String entryMediaType;
            if (path.length() <= 1 || !path.endsWith(SLASH) || (entryMediaType = this.mPackage.getFileEntry(path).getMediaTypeString()) == null) continue;
            if (wantedMediaString != null) {
                if (!entryMediaType.equals(wantedMediaString)) continue;
                path = OdfDocument.normalizeDocumentPath(path);
                embeddedObjectsMap.put(path, (OdfDocument)this.mPackage.loadDocument(path));
                continue;
            }
            for (OdfMediaType mediaType : OdfMediaType.values()) {
                if (!entryMediaType.equals(mediaType.getMediaTypeString())) continue;
                embeddedObjectsMap.put(path, (OdfDocument)this.mPackage.loadDocument(path));
            }
        }
        return embeddedObjectsMap;
    }

    protected void setOdfMediaType(OdfMediaType odfMediaType) {
        this.mMediaType = odfMediaType;
        super.setMediaTypeString(odfMediaType.getMediaTypeString());
    }

    protected OdfMediaType getOdfMediaType() {
        return this.mMediaType;
    }

    public OdfOfficeMeta getOfficeMetadata() {
        if (this.mOfficeMeta == null) {
            try {
                OdfMetaDom metaDom = this.getMetaDom();
                this.mOfficeMeta = new OdfOfficeMeta(metaDom);
            }
            catch (Exception ex) {
                Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.mOfficeMeta;
    }

    public void save(OutputStream out) throws Exception {
        this.updateMetaData();
        if (!this.isRootDocument()) {
            OdfDocument newDoc = OdfDocument.loadDocumentFromTemplate(this.getOdfMediaType());
            newDoc.insertDocument(this, EMPTY_STRING);
            newDoc.updateMetaData();
            newDoc.mPackage.save(out);
        } else {
            this.mPackage.save(out);
        }
    }

    @Override
    public void save(File file) throws Exception {
        this.updateMetaData();
        if (!this.isRootDocument()) {
            OdfDocument newDoc = OdfDocument.loadDocumentFromTemplate(this.getOdfMediaType());
            newDoc.insertDocument(this, EMPTY_STRING);
            newDoc.updateMetaData();
            newDoc.mPackage.save(file);
        } else {
            this.mPackage.save(file);
        }
    }

    @Override
    public void close() {
        this.mMediaType = null;
        this.mOfficeMeta = null;
        super.close();
    }

    <T extends OdfElement> T getContentRoot(Class<T> clazz) throws Exception {
        OfficeDocumentContentElement contentRoot = this.getContentDom().getRootElement();
        OfficeBodyElement contentBody = OdfElement.findFirstChildNode(OfficeBodyElement.class, (Node)((Object)contentRoot));
        NodeList childs = contentBody.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node cur = childs.item(i);
            if (cur == null || !clazz.isInstance(cur)) continue;
            return (T)((Object)((OdfElement)((Object)cur)));
        }
        return null;
    }

    public OdfElement getContentRoot() throws Exception {
        return this.getContentRoot(OdfElement.class);
    }

    public String toString() {
        return "\n" + this.getMediaTypeString() + " - ID: " + this.hashCode() + " " + this.getPackage().getBaseURI();
    }

    public String newImage(URI imageUri) {
        try {
            OdfContentDom contentDom = this.getContentDom();
            OdfDrawFrame drawFrame = contentDom.newOdfElement(OdfDrawFrame.class);
            XPath xpath = contentDom.getXPath();
            if (this instanceof OdfSpreadsheetDocument) {
                TableTableCellElement lastCell = (TableTableCellElement)xpath.evaluate("//table:table-cell[last()]", contentDom, XPathConstants.NODE);
                lastCell.appendChild((Node)((Object)drawFrame));
                drawFrame.removeAttribute("text:anchor-type");
            } else if (this instanceof OdfTextDocument) {
                TextPElement lastPara = (TextPElement)xpath.evaluate("//text:p[last()]", contentDom, XPathConstants.NODE);
                if (lastPara == null) {
                    lastPara = ((OdfTextDocument)this).newParagraph();
                }
                lastPara.appendChild((Node)((Object)drawFrame));
                drawFrame.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PARAGRAPH.toString());
            } else if (this instanceof OdfPresentationDocument) {
                DrawPageElement lastPage = (DrawPageElement)xpath.evaluate("//draw:page[last()]", contentDom, XPathConstants.NODE);
                lastPage.appendChild((Node)((Object)drawFrame));
            }
            OdfDrawImage image = (OdfDrawImage)drawFrame.newDrawImageElement();
            String imagePath = image.newImage(imageUri);
            return imagePath;
        }
        catch (Exception ex) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public OdfTable getTableByName(String name) {
        try {
            OfficeDocumentContentElement root = this.getContentDom().getRootElement();
            OfficeBodyElement officeBody = OdfElement.findFirstChildNode(OfficeBodyElement.class, (Node)((Object)root));
            OdfElement typedContent = OdfElement.findFirstChildNode(OdfElement.class, (Node)((Object)officeBody));
            NodeList childList = typedContent.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                TableTableElement table;
                if (!(childList.item(i) instanceof TableTableElement) || !(table = (TableTableElement)((Object)childList.item(i))).getOdfAttributeValue(OdfName.newName(OdfDocumentNamespace.TABLE, "name")).equals(name)) continue;
                return OdfTable.getInstance(table);
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, e);
        }
        return null;
    }

    public List<OdfTable> getTableList() {
        ArrayList<OdfTable> tableList = null;
        try {
            List<TableTableElement> tableElementList = this.getTables();
            tableList = new ArrayList<OdfTable>(tableElementList.size());
            for (int i = 0; i < tableElementList.size(); ++i) {
                tableList.add(OdfTable.getInstance(tableElementList.get(i)));
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, null, e);
        }
        return tableList;
    }

    public void updateMetaData() {
        if (this.getOfficeMetadata().hasAutomaticUpdate()) {
            OdfOfficeMeta metaData = this.getOfficeMetadata();
            metaData.setGenerator(FORMER_OPEN_OFFICE_VERSION);
            if (this.mCreationDate != null) {
                this.getOfficeMetadata().setCreationDate(this.mCreationDate);
            }
            Calendar calendar = Calendar.getInstance();
            metaData.setDate(calendar);
            Integer cycle = metaData.getEditingCycles();
            if (cycle != null) {
                cycle = cycle + 1;
                metaData.setEditingCycles(cycle);
            } else {
                metaData.setEditingCycles(1);
            }
            long editingDuration = calendar.getTimeInMillis() - this.documentOpeningTime;
            editingDuration = editingDuration < 1L ? 1L : editingDuration;
            try {
                DatatypeFactory aFactory = DatatypeFactory.newInstance();
                metaData.setEditingDuration(new Duration(aFactory.newDurationDayTime(editingDuration)));
            }
            catch (DatatypeConfigurationException e) {
                Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, "editing duration update fail as DatatypeFactory can not be instanced", e);
            }
        }
    }

    public void setLocale(Locale locale) {
        this.setLocale(locale, OdfDocument.getUnicodeGroup(locale));
    }

    public static UnicodeGroup getUnicodeGroup(Locale locale) {
        String language = locale.getLanguage();
        if (CJKLanguage.contains(language)) {
            return UnicodeGroup.CJK;
        }
        if (CTLLanguage.contains(language)) {
            return UnicodeGroup.CTL;
        }
        return UnicodeGroup.WESTERN;
    }

    private void setLocale(Locale locale, UnicodeGroup unicodeGroup) {
        try {
            switch (unicodeGroup) {
                case WESTERN: {
                    this.setDefaultWesternLanguage(locale);
                    break;
                }
                case CJK: {
                    this.setDefaultAsianLanguage(locale);
                    break;
                }
                case CTL: {
                    this.setDefaultComplexLanguage(locale);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, "Failed to set locale", e);
        }
    }

    public Locale getLocale(UnicodeGroup unicodeGroup) {
        try {
            switch (unicodeGroup) {
                case WESTERN: {
                    return this.getDefaultLanguageByProperty(OdfTextProperties.Country, OdfTextProperties.Language);
                }
                case CJK: {
                    return this.getDefaultLanguageByProperty(OdfTextProperties.CountryAsian, OdfTextProperties.LanguageAsian);
                }
                case CTL: {
                    return this.getDefaultLanguageByProperty(OdfTextProperties.CountryComplex, OdfTextProperties.LanguageComplex);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(OdfDocument.class.getName()).log(Level.SEVERE, "Failed to get locale", e);
        }
        return null;
    }

    private Locale getDefaultLanguageByProperty(OdfStyleProperty countryProp, OdfStyleProperty languageProp) throws Exception {
        String lang = null;
        String ctry = null;
        OdfOfficeStyles styles = this.getStylesDom().getOfficeStyles();
        OdfDefaultStyle defaultStyle = styles.getDefaultStyle(OdfStyleFamily.Paragraph);
        if (defaultStyle != null && defaultStyle.hasProperty(countryProp) && defaultStyle.hasProperty(languageProp)) {
            ctry = defaultStyle.getProperty(countryProp);
            lang = defaultStyle.getProperty(languageProp);
            return new Locale(lang, ctry);
        }
        Iterable<OdfDefaultStyle> defaultStyles = styles.getDefaultStyles();
        for (OdfDefaultStyle style : defaultStyles) {
            if (!style.hasProperty(countryProp) || !style.hasProperty(languageProp)) continue;
            ctry = style.getProperty(countryProp);
            lang = style.getProperty(languageProp);
            return new Locale(lang, ctry);
        }
        return null;
    }

    private void setDefaultWesternLanguage(Locale locale) throws Exception {
        OdfOfficeStyles styles = this.getStylesDom().getOfficeStyles();
        Iterable<OdfDefaultStyle> defaultStyles = styles.getDefaultStyles();
        if (defaultStyles != null) {
            for (OdfDefaultStyle style : defaultStyles) {
                if (!style.getFamily().getProperties().contains(OdfTextProperties.Language)) continue;
                style.setProperty(OdfTextProperties.Language, locale.getLanguage());
                style.setProperty(OdfTextProperties.Country, locale.getCountry());
            }
        }
    }

    private void setDefaultAsianLanguage(Locale locale) throws Exception {
        OdfOfficeStyles styles = this.getStylesDom().getOfficeStyles();
        Iterable<OdfDefaultStyle> defaultStyles = styles.getDefaultStyles();
        if (defaultStyles != null) {
            for (OdfDefaultStyle style : defaultStyles) {
                if (!style.getFamily().getProperties().contains(OdfTextProperties.LanguageAsian)) continue;
                style.setProperty(OdfTextProperties.LanguageAsian, locale.getLanguage());
                style.setProperty(OdfTextProperties.CountryAsian, locale.getCountry());
            }
        }
    }

    private void setDefaultComplexLanguage(Locale locale) throws Exception {
        OdfOfficeStyles styles = this.getStylesDom().getOfficeStyles();
        Iterable<OdfDefaultStyle> defaultStyles = styles.getDefaultStyles();
        if (defaultStyles != null) {
            for (OdfDefaultStyle style : defaultStyles) {
                if (!style.getFamily().getProperties().contains(OdfTextProperties.LanguageComplex)) continue;
                style.setProperty(OdfTextProperties.LanguageComplex, locale.getLanguage());
                style.setProperty(OdfTextProperties.CountryComplex, locale.getCountry());
            }
        }
    }

    public Set<String> getFontNames() {
        if (this.mFontNames == null) {
            this.mFontNames = new HashSet<String>();
        }
        return this.mFontNames;
    }

    public void addAnnotation(String name, OfficeAnnotationElement element) {
        if (this.annotations == null) {
            this.annotations = new HashMap<String, OfficeAnnotationElement>();
        }
        this.annotations.put(name, element);
    }

    public OfficeAnnotationElement getAnnotation(String name) {
        if (this.annotations == null || !this.annotations.containsKey(name)) {
            return null;
        }
        return this.annotations.get(name);
    }

    public void removeAnnotation(String name) {
        if (this.annotations != null && this.annotations.containsKey(name)) {
            this.annotations.remove(name);
        }
    }

    public String getUniqueAnnotationName() {
        String prefix = "CmtId";
        int freeIndex = 0;
        if (this.annotations != null) {
            while (this.annotations.containsKey(prefix + freeIndex)) {
                ++freeIndex;
            }
        }
        return prefix + freeIndex;
    }

    protected void removeCachedView() {
        this.mPackage = this.getPackage();
        this.mPackage.remove("Thumbnails/thumbnail.png");
    }

    public Boolean hasCollaboration() {
        return this.mHasCollaboration != null && this.mHasCollaboration != false;
    }

    public static enum UnicodeGroup {
        WESTERN,
        CJK,
        CTL;

    }

    public static enum OdfMediaType implements MediaType
    {
        CHART("application/vnd.oasis.opendocument.chart", "odc"),
        CHART_TEMPLATE("application/vnd.oasis.opendocument.chart-template", "otc"),
        FORMULA("application/vnd.oasis.opendocument.formula", "odf"),
        FORMULA_TEMPLATE("application/vnd.oasis.opendocument.formula-template", "otf"),
        DATABASE_FRONT_END("application/vnd.oasis.opendocument.base", "odb"),
        GRAPHICS("application/vnd.oasis.opendocument.graphics", "odg"),
        GRAPHICS_TEMPLATE("application/vnd.oasis.opendocument.graphics-template", "otg"),
        IMAGE("application/vnd.oasis.opendocument.image", "odi"),
        IMAGE_TEMPLATE("application/vnd.oasis.opendocument.image-template", "oti"),
        PRESENTATION("application/vnd.oasis.opendocument.presentation", "odp"),
        PRESENTATION_TEMPLATE("application/vnd.oasis.opendocument.presentation-template", "otp"),
        SPREADSHEET("application/vnd.oasis.opendocument.spreadsheet", "ods"),
        SPREADSHEET_TEMPLATE("application/vnd.oasis.opendocument.spreadsheet-template", "ots"),
        TEXT("application/vnd.oasis.opendocument.text", "odt"),
        TEXT_MASTER("application/vnd.oasis.opendocument.text-master", "odm"),
        TEXT_TEMPLATE("application/vnd.oasis.opendocument.text-template", "ott"),
        TEXT_WEB("application/vnd.oasis.opendocument.text-web", "oth");

        private final String mMediaType;
        private final String mSuffix;

        private OdfMediaType(String mediaType, String suffix) {
            this.mMediaType = mediaType;
            this.mSuffix = suffix;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType;
        }

        @Override
        public String getSuffix() {
            return this.mSuffix;
        }

        public static OdfMediaType getOdfMediaType(String mediaType) {
            OdfMediaType odfMediaType = null;
            if (mediaType != null) {
                String mediaTypeShort = mediaType.substring(mediaType.lastIndexOf(".") + 1, mediaType.length());
                mediaTypeShort = mediaTypeShort.replace('-', '_').toUpperCase();
                try {
                    odfMediaType = OdfMediaType.valueOf(mediaTypeShort);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Given mediaType '" + mediaType + "' is not an ODF mediatype!");
                }
            }
            return odfMediaType;
        }
    }
}

