/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.changes.CollabTextDocument;
import org.odftoolkit.odfdom.changes.JsonOperationNormalizer;

public class JarManifest {
    private static final String CURRENT_CLASS_RESOURCE_PATH = "org/odftoolkit/odfdom/JarManifest.class";
    private static final String INNER_JAR_MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static String ODFDOM_NAME;
    private static String ODFDOM_VERSION;
    private static String ODFDOM_WEBSITE;
    private static String ODFDOM_BUILD_DATE;
    private static String ODFDOM_SUPPORTED_ODF_VERSION;

    private static InputStream getManifestAsStream() {
        String versionRef = JarManifest.class.getClassLoader().getResource(CURRENT_CLASS_RESOURCE_PATH).toString();
        String manifestRef = versionRef.substring(0, versionRef.lastIndexOf(CURRENT_CLASS_RESOURCE_PATH)) + INNER_JAR_MANIFEST_PATH;
        URL manifestURL = null;
        InputStream in = null;
        try {
            manifestURL = new URL(manifestRef);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            in = manifestURL.openStream();
        }
        catch (IOException ex) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, ex);
        }
        return in;
    }

    private JarManifest() {
    }

    public static void main(String[] args) throws IOException, Exception {
        block15: {
            if (args == null || args.length == 0) {
                System.out.println(JarManifest.getOdfdomTitle() + " (build " + JarManifest.getOdfdomBuildDate() + ")\nfrom " + JarManifest.getOdfdomWebsite() + " supporting ODF " + JarManifest.getOdfdomSupportedOdfVersion());
            } else {
                if (args[0].endsWith(".odt")) {
                    try (CollabTextDocument doc1 = new CollabTextDocument(Files.newInputStream(Paths.get(args[0], new String[0]), new OpenOption[0]));){
                        System.out.println(JsonOperationNormalizer.asString(doc1.getDocumentAsChanges()).replace(",{\"name\"", ",\n{\"name\""));
                        break block15;
                    }
                    catch (FileNotFoundException e) {
                        try (CollabTextDocument doc2 = new CollabTextDocument(Files.newInputStream(Paths.get(System.getProperty("user.dir") + File.separator + args[0], new String[0]), new OpenOption[0]));){
                            System.out.println(JsonOperationNormalizer.asString(doc2.getDocumentAsChanges()).replace(",{\"name\"", ",\n{\"name\""));
                            break block15;
                        }
                    }
                }
                System.out.println("NOTE:\nThe first argument have to be the relative path to an OpenDocument Text document and therefore have to end with '.odt'!\nThe ODT will be transformed to equivalent user changes (in JSON) to standard output");
            }
        }
    }

    public static String getOdfdomName() {
        return ODFDOM_NAME;
    }

    public static String getOdfdomTitle() {
        return JarManifest.getOdfdomName() + " " + JarManifest.getOdfdomVersion();
    }

    public static String getOdfdomVersion() {
        return ODFDOM_VERSION;
    }

    public static String getOdfdomWebsite() {
        return ODFDOM_WEBSITE;
    }

    public static String getOdfdomBuildDate() {
        return ODFDOM_BUILD_DATE;
    }

    public static String getOdfdomSupportedOdfVersion() {
        return ODFDOM_SUPPORTED_ODF_VERSION;
    }

    static {
        try {
            Manifest manifest = new Manifest(JarManifest.getManifestAsStream());
            Attributes attr = manifest.getEntries().get("ODFDOM");
            ODFDOM_NAME = attr.getValue("ODFDOM-Name");
            ODFDOM_VERSION = attr.getValue("ODFDOM-Version");
            ODFDOM_WEBSITE = attr.getValue("ODFDOM-Website");
            ODFDOM_BUILD_DATE = attr.getValue("ODFDOM-Built-Date");
            ODFDOM_SUPPORTED_ODF_VERSION = attr.getValue("ODFDOM-Supported-Odf-Version");
        }
        catch (Exception e) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, e);
        }
    }
}

