/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class Color
implements OdfDataType {
    private static final Pattern sixHexRGBPattern = Pattern.compile("^#[0-9a-fA-F]{6}$");
    private static final Pattern threeHexRGBPattern = Pattern.compile("^#[0-9a-fA-F]{3}$");
    private static final Map<String, String> labeledColors = Map.ofEntries(Map.entry("aqua", "#00ffff"), Map.entry("black", "#000000"), Map.entry("blue", "#0000ff"), Map.entry("fuchsia", "#ff00ff"), Map.entry("gray", "#808080"), Map.entry("green", "#008000"), Map.entry("lime", "#00ff00"), Map.entry("maroon", "#800000"), Map.entry("navy", "#000080"), Map.entry("olive", "#808000"), Map.entry("orange", "#ffA500"), Map.entry("purple", "#800080"), Map.entry("red", "#ff0000"), Map.entry("silver", "#c0c0c0"), Map.entry("teal", "#008080"), Map.entry("white", "#ffffff"), Map.entry("yellow", "#ffff00"));
    private static final String COLOR_PREFIX = "#";
    private final String mColorAsSixHexRGB;
    public static final Color AQUA = new Color("#00ffff");
    public static final Color BLACK = new Color("#000000");
    public static final Color BLUE = new Color("#0000ff");
    public static final Color FUCHSIA = new Color("#ff00ff");
    public static final Color GRAY = new Color("#808080");
    public static final Color GREEN = new Color("#008000");
    public static final Color LIME = new Color("#00ff00");
    public static final Color MAROON = new Color("#800000");
    public static final Color NAVY = new Color("#000080");
    public static final Color OLIVE = new Color("#808000");
    public static final Color ORANGE = new Color("#ffA500");
    public static final Color PURPLE = new Color("#800080");
    public static final Color RED = new Color("#ff0000");
    public static final Color SILVER = new Color("#c0c0c0");
    public static final Color TEAL = new Color("#008080");
    public static final Color WHITE = new Color("#ffffff");
    public static final Color YELLOW = new Color("#ffff00");

    public Color(String color) {
        if (!Color.isValid(color)) {
            throw new IllegalArgumentException("parameter is invalid for datatype Color");
        }
        this.mColorAsSixHexRGB = color.length() == 4 ? Color.mapColorFromThreeToSixHex(color) : color;
    }

    public Color(int red, int green, int blue) {
        this(Color.mapColorIntegerToString(red, green, blue));
    }

    public Color(float red, float green, float blue) {
        this((int)((double)(red * 255.0f) + 0.5), (int)((double)(green * 255.0f) + 0.5), (int)((double)(blue * 255.0f) + 0.5));
    }

    public Color(java.awt.Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public String toString() {
        return this.mColorAsSixHexRGB;
    }

    public static Color valueOf(String colorValue) {
        return new Color(colorValue);
    }

    public static boolean isValid(String colorValue) {
        return colorValue != null && (threeHexRGBPattern.matcher(colorValue).matches() || sixHexRGBPattern.matcher(colorValue).matches());
    }

    public static String toSixDigitHexRGB(String colorValue) {
        if (colorValue == null) {
            throw new IllegalArgumentException("parameter should not be null.");
        }
        if (sixHexRGBPattern.matcher(colorValue = colorValue.toLowerCase().trim()).matches()) {
            return colorValue;
        }
        if (threeHexRGBPattern.matcher(colorValue).matches()) {
            return Color.mapColorFromThreeToSixHex(colorValue);
        }
        if (colorValue.startsWith("rgb")) {
            colorValue = colorValue.substring(3);
            String[] rgbValues = (colorValue = colorValue.substring(colorValue.indexOf("(") + 1, colorValue.indexOf(")"))).split(",");
            if (rgbValues.length == 3) {
                int r = Color.mapColorValueToInteger(rgbValues[0].trim());
                int g = Color.mapColorValueToInteger(rgbValues[1].trim());
                int b = Color.mapColorValueToInteger(rgbValues[2].trim());
                String rs = Integer.toHexString(r);
                String gs = Integer.toHexString(g);
                String bs = Integer.toHexString(b);
                Object hexColor = COLOR_PREFIX;
                if (r < 16) {
                    hexColor = (String)hexColor + "0";
                }
                hexColor = (String)hexColor + rs;
                if (g < 16) {
                    hexColor = (String)hexColor + "0";
                }
                hexColor = (String)hexColor + gs;
                if (b < 16) {
                    hexColor = (String)hexColor + "0";
                }
                hexColor = (String)hexColor + bs;
                return hexColor;
            }
            throw new IllegalArgumentException("parameter: " + colorValue + " can't be converted six-digit hex RGB.");
        }
        String hexColor = labeledColors.get(colorValue);
        if (hexColor != null) {
            return hexColor;
        }
        throw new IllegalArgumentException("parameter: " + colorValue + " can't be converted six-digit hex RGB.");
    }

    public java.awt.Color getAWTColor() {
        return Color.mapColorToAWTColor(this);
    }

    public static java.awt.Color mapColorToAWTColor(Color color) {
        int rgb = Integer.decode("0x" + color.mColorAsSixHexRGB.substring(1));
        return new java.awt.Color(rgb);
    }

    private static String mapColorIntegerToString(int red, int green, int blue) {
        String rs = Integer.toHexString(red);
        String gs = Integer.toHexString(green);
        String bs = Integer.toHexString(blue);
        Object hexColor = COLOR_PREFIX;
        if (red < 16) {
            hexColor = (String)hexColor + "0";
        }
        hexColor = (String)hexColor + rs;
        if (green < 16) {
            hexColor = (String)hexColor + "0";
        }
        hexColor = (String)hexColor + gs;
        if (blue < 16) {
            hexColor = (String)hexColor + "0";
        }
        hexColor = (String)hexColor + bs;
        return hexColor;
    }

    private static String mapColorFromThreeToSixHex(String threeDigitcColor) {
        char[] colorData = threeDigitcColor.toCharArray();
        char[] sixDigitColor = new char[7];
        for (int i = 0; i < 7; ++i) {
            sixDigitColor[i] = colorData[(i + 1) / 2];
        }
        return new String(sixDigitColor);
    }

    private static int mapColorValueToInteger(String colorValue) {
        if (colorValue.endsWith("%")) {
            int value = Integer.parseInt(colorValue = colorValue.substring(0, colorValue.indexOf("%")));
            if (value < 0) {
                value = 0;
            }
            if (value > 100) {
                value = 100;
            }
            return 255 * value / 100;
        }
        int value = Integer.parseInt(colorValue);
        if (value < 0) {
            value = 0;
        }
        if (value > 255) {
            value = 255;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.mColorAsSixHexRGB, ((Color)obj).mColorAsSixHexRGB);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.mColorAsSixHexRGB != null ? this.mColorAsSixHexRGB.hashCode() : 0);
        return hash;
    }
}

