/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.odftoolkit.odfdom.incubator.search.Selection;
import org.odftoolkit.odfdom.incubator.search.TextSelection;
import org.odftoolkit.odfdom.pkg.OdfElement;

public class SelectionManager {
    private Map<OdfElement, ArrayList<Selection>> repository = new HashMap<OdfElement, ArrayList<Selection>>();

    public void registerItem(Selection item) {
        OdfElement element = item.getElement();
        if (this.repository.containsKey((Object)element)) {
            int i;
            ArrayList<Selection> selections = this.repository.get((Object)element);
            for (i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() <= item.getIndex()) continue;
                selections.add(i, item);
                break;
            }
            if (i == selections.size()) {
                selections.add(item);
            }
        } else {
            ArrayList<Selection> al = new ArrayList<Selection>();
            al.add(item);
            this.repository.put(element, al);
        }
    }

    public void refreshAfterCut(Selection cutItem) {
        OdfElement element = cutItem.getElement();
        if (this.repository.containsKey((Object)element)) {
            ArrayList<Selection> selections = this.repository.get((Object)element);
            for (Selection selection : selections) {
                if (selection.getIndex() <= cutItem.getIndex()) continue;
                selection.refreshAfterFrontalDelete(cutItem);
            }
        }
    }

    public void refreshAfterPasteAtFrontOf(Selection item, Selection positionItem) {
        OdfElement element = positionItem.getElement();
        if (this.repository.containsKey((Object)element)) {
            ArrayList<Selection> selections = this.repository.get((Object)element);
            for (Selection selection : selections) {
                if (selection.getIndex() < positionItem.getIndex()) continue;
                selection.refreshAfterFrontalInsert(item);
            }
        }
    }

    public void refreshAfterPasteAtEndOf(Selection item, Selection positionItem) {
        OdfElement element = positionItem.getElement();
        int positionIndex = positionItem instanceof TextSelection ? positionItem.getIndex() + ((TextSelection)positionItem).getText().length() : positionItem.getIndex();
        if (this.repository.containsKey((Object)element)) {
            ArrayList<Selection> selections = this.repository.get((Object)element);
            for (Selection selection : selections) {
                if (selection.getIndex() < positionIndex) continue;
                selection.refreshAfterFrontalInsert(item);
            }
        }
    }

    public void unregisterItem(Selection item) {
        OdfElement element = item.getElement();
        if (this.repository.containsKey((Object)element)) {
            ArrayList<Selection> selections = this.repository.get((Object)element);
            selections.remove(item);
        }
    }

    public void unregisterAll() {
        this.repository.clear();
    }

    public void refresh(OdfElement containerElement, int offset, int positionIndex) {
        if (this.repository.containsKey((Object)containerElement)) {
            ArrayList<Selection> selections = this.repository.get((Object)containerElement);
            for (Selection selection : selections) {
                if (selection.getIndex() < positionIndex) continue;
                selection.refresh(offset);
            }
        }
    }
}

