/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.text;

import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.text.TextLineBreakElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextTabElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OdfWhitespaceProcessor {
    public void append(Element element, String content) {
        StringBuilder partial = new StringBuilder();
        int spaces = 0;
        OdfFileDom owner = (OdfFileDom)((Object)element.getOwnerDocument());
        for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (ch == ' ') {
                if (spaces == 0) {
                    partial.append(' ');
                }
                ++spaces;
                continue;
            }
            if (ch == '\n') {
                this.emitPartial(element, partial, spaces, owner);
                spaces = 0;
                element.appendChild((Node)((Object)new TextLineBreakElement(owner)));
                continue;
            }
            if (ch == '\t') {
                this.emitPartial(element, partial, spaces, owner);
                spaces = 0;
                element.appendChild((Node)((Object)new TextTabElement(owner)));
                continue;
            }
            if (ch == '\r') continue;
            if (spaces > 1) {
                this.emitPartial(element, partial, spaces, owner);
            }
            partial.append(ch);
            spaces = 0;
        }
        this.emitPartial(element, partial, spaces, owner);
    }

    private void emitPartial(Element element, StringBuilder partial, int spaces, OdfFileDom owner) {
        if (partial.length() != 0) {
            element.appendChild(owner.createTextNode(partial.toString()));
        }
        if (spaces > 1) {
            TextSElement spaceElement = new TextSElement(owner);
            spaceElement.setTextCAttribute(spaces - 1);
            element.appendChild((Node)((Object)spaceElement));
        }
        partial.delete(0, partial.length());
    }

    public String getText(Node element) {
        Object result = "";
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 3) {
                result = (String)result + node.getNodeValue();
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                int spaceCount;
                try {
                    spaceCount = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                }
                catch (Exception e) {
                    spaceCount = 1;
                }
                for (int i = 0; i < spaceCount; ++i) {
                    result = (String)result + " ";
                }
                continue;
            }
            result = node.getLocalName().equals("line-break") ? (String)result + "\n" : (node.getLocalName().equals("tab") ? (String)result + "\t" : (String)result + this.getText(node));
        }
        return result;
    }

    public static void appendText(Element element, String content) {
        OdfWhitespaceProcessor processor = new OdfWhitespaceProcessor();
        processor.append(element, content);
    }
}

