/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.doc.office;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.draw.DrawLayerSetElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHandoutMasterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfStylesBase;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class OdfOfficeMasterStyles
extends OdfStylesBase
implements Iterable<StyleMasterPageElement> {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.OFFICE, "master-styles");
    private static final long serialVersionUID = 6598785919980862801L;
    private DrawLayerSetElement mLayerSet;
    private StyleHandoutMasterElement mHandoutMaster;
    private Map<String, StyleMasterPageElement> mMasterPages;

    public OdfOfficeMasterStyles(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    protected OdfOfficeMasterStyles(OdfFileDom ownerDoc, OdfName elementName) {
        super(ownerDoc, elementName);
    }

    @Override
    public OdfName getOdfName() {
        return null;
    }

    public StyleHandoutMasterElement getHandoutMaster() {
        return this.mHandoutMaster;
    }

    public DrawLayerSetElement getLayerSet() {
        return this.mLayerSet;
    }

    public StyleMasterPageElement getMasterPage(String name) {
        if (this.mMasterPages != null) {
            return this.mMasterPages.get(name);
        }
        return null;
    }

    @Override
    protected <T extends OdfElement> T getStylesElement(OdfFileDom dom, Class<T> clazz) throws Exception {
        OdfElement stylesRoot = dom.getRootElement();
        OdfOfficeMasterStyles contentBody = OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, (Node)((Object)stylesRoot));
        NodeList childs = contentBody.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node cur = childs.item(i);
            if (cur == null || !clazz.isInstance(cur)) continue;
            return (T)((Object)((OdfElement)((Object)cur)));
        }
        return null;
    }

    public StyleMasterPageElement getOrCreateMasterPage(String name) {
        StyleMasterPageElement masterPage = this.getMasterPage(name);
        if (masterPage == null) {
            masterPage = new StyleMasterPageElement((OdfFileDom)((Object)this.getOwnerDocument()));
            masterPage.setStyleNameAttribute(name);
            this.appendChild((Node)((Object)masterPage));
        }
        return masterPage;
    }

    public Map<String, StyleMasterPageElement> getMasterPages() {
        if (this.mMasterPages != null) {
            return this.mMasterPages;
        }
        return null;
    }

    @Override
    public void onOdfNodeInserted(OdfElement node, Node refNode) {
        if (node instanceof DrawLayerSetElement) {
            this.mLayerSet = (DrawLayerSetElement)node;
        } else if (node instanceof StyleHandoutMasterElement) {
            this.mHandoutMaster = (StyleHandoutMasterElement)node;
        } else if (node instanceof StyleMasterPageElement) {
            StyleMasterPageElement masterPage = (StyleMasterPageElement)node;
            if (this.mMasterPages == null) {
                this.mMasterPages = new HashMap<String, StyleMasterPageElement>();
            }
            this.mMasterPages.put(masterPage.getStyleNameAttribute(), masterPage);
        }
    }

    @Override
    public void onOdfNodeRemoved(OdfElement node) {
        if (node instanceof DrawLayerSetElement) {
            if (this.mLayerSet == (DrawLayerSetElement)node) {
                this.mLayerSet = null;
            }
        } else if (node instanceof StyleHandoutMasterElement) {
            if (this.mHandoutMaster == (StyleHandoutMasterElement)node) {
                this.mHandoutMaster = null;
            }
        } else if (node instanceof StyleMasterPageElement && this.mMasterPages != null) {
            StyleMasterPageElement masterPage = (StyleMasterPageElement)node;
            this.mMasterPages.remove(masterPage.getStyleNameAttribute());
        }
    }

    @Override
    public Iterator<StyleMasterPageElement> iterator() {
        Iterator<StyleMasterPageElement> iter = null;
        Map<String, StyleMasterPageElement> masterPages = this.getMasterPages();
        if (masterPages != null) {
            iter = masterPages.values().iterator();
        }
        if (iter == null) {
            iter = Collections.emptyIterator();
        }
        return iter;
    }
}

