/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;

public class JsonOperationNormalizer {
    private static final Logger LOG = Logger.getLogger(JsonOperationNormalizer.class.getName());
    private static final String[] SORTING_SEQUENCE_OF_KEYS = new String[]{"name", "start", "end", "type", "styleId"};

    public static String asString(JSONObject jsonObject, Boolean isTest) {
        if (jsonObject.has("changes")) {
            jsonObject.remove("version");
            jsonObject.remove("version-time");
            jsonObject.remove("version-branch");
            jsonObject.remove("editor");
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<String> keys = JsonOperationNormalizer.getSortedIterator(jsonObject);
        while (keys.hasNext()) {
            String key = keys.next();
            if (key.equals("changes")) {
                sb.append("\"changes\":[\n");
                try {
                    JSONArray ops = jsonObject.getJSONArray("changes");
                    sb.append(JsonOperationNormalizer.normalizeOperations(ops));
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
                sb.append("\n]");
                continue;
            }
            try {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(key);
                sb.append('\"');
                sb.append(':');
                Object value = jsonObject.get(key);
                JsonOperationNormalizer.appendValueAsString(value, sb);
            }
            catch (JSONException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public static String asString(JSONObject jsonObject) {
        return JsonOperationNormalizer.asString(jsonObject, Boolean.FALSE);
    }

    static String asString(JSONArray array) {
        try {
            return "[" + JsonOperationNormalizer.normalizeOperations(array) + "]";
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
            return null;
        }
    }

    private static Iterator<String> getSortedIterator(JSONObject jsonObject) {
        HashSet keySet = new HashSet(jsonObject.keySet());
        ArrayList<String> firstListedKeys = null;
        for (String SORTING_SEQUENCE_OF_KEYS1 : SORTING_SEQUENCE_OF_KEYS) {
            if (!keySet.contains(SORTING_SEQUENCE_OF_KEYS1)) continue;
            if (firstListedKeys == null) {
                firstListedKeys = new ArrayList<String>(3);
            }
            firstListedKeys.add(SORTING_SEQUENCE_OF_KEYS1);
            keySet.remove(SORTING_SEQUENCE_OF_KEYS1);
        }
        ArrayList<String> list = new ArrayList<String>(keySet);
        Collections.sort(list);
        if (firstListedKeys != null) {
            for (int j = 0; j < firstListedKeys.size(); ++j) {
                list.add(j, (String)firstListedKeys.get(j));
            }
        }
        return list.iterator();
    }

    private static void appendValueAsString(Object value, StringBuilder sb) {
        if (value instanceof JSONObject) {
            sb.append(JsonOperationNormalizer.asString((JSONObject)value));
        } else if (value instanceof JSONArray) {
            sb.append(JsonOperationNormalizer.asString((JSONArray)value));
        } else if (value instanceof JSONString) {
            sb.append(((JSONString)value).toJSONString());
        } else if (value instanceof Number) {
            sb.append(JsonOperationNormalizer.numberToString((Number)value));
        } else if (value instanceof Boolean) {
            sb.append(value);
        } else if (value == null || value == JSONObject.NULL) {
            sb.append("null");
        } else if (value instanceof String) {
            JsonOperationNormalizer.quote((String)value, sb);
        } else {
            sb.append(value);
        }
    }

    private static StringBuilder quote(String string, StringBuilder sb) {
        if (string == null || string.isEmpty()) {
            sb.append("\"\"");
            return sb;
        }
        char c = '\u0000';
        int len = string.length();
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        sb.append("\\u");
                        String hhhh = Integer.toHexString(c);
                        sb.append("0000", 0, 4 - hhhh.length());
                        sb.append(hhhh);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb;
    }

    private static String numberToString(Number number) throws JSONException {
        if (number == null) {
            throw new JSONException("Null pointer");
        }
        JsonOperationNormalizer.testValidity(number);
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private static void testValidity(Object o) throws JSONException {
        if (o != null && (o instanceof Double ? ((Double)o).isInfinite() || ((Double)o).isNaN() : o instanceof Float && (((Float)o).isInfinite() || ((Float)o).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    private static String normalizeOperations(JSONArray array) {
        int len = array.length();
        StringBuilder sb = new StringBuilder(len);
        boolean opsCollected = false;
        TreeSet<JSONObject> sameTypOperations = null;
        for (int i = 0; i < len; ++i) {
            if (i > 0 && !opsCollected) {
                sb.append(',');
            }
            String lastOperationName = null;
            try {
                Object o = array.get(i);
                if (o instanceof JSONObject) {
                    JSONObject operation = (JSONObject)o;
                    if (operation.has("name")) {
                        String newOperationName = operation.getString("name");
                        if (lastOperationName == null) {
                            lastOperationName = newOperationName;
                        }
                        if (newOperationName.equals("addStyle") && lastOperationName.equals(newOperationName)) {
                            if (sameTypOperations == null) {
                                sameTypOperations = new TreeSet<JSONObject>(new OperationSorter());
                            }
                            sameTypOperations.add(operation);
                            opsCollected = true;
                            continue;
                        }
                        if (opsCollected) {
                            for (JSONObject sortedOperation : sameTypOperations) {
                                JsonOperationNormalizer.appendValueAsString(sortedOperation, sb);
                                sb.append(',');
                            }
                            sameTypOperations.clear();
                            opsCollected = false;
                        }
                        JsonOperationNormalizer.appendValueAsString(operation, sb);
                        lastOperationName = null;
                        continue;
                    }
                    JsonOperationNormalizer.appendValueAsString(operation, sb);
                    lastOperationName = null;
                    continue;
                }
                JsonOperationNormalizer.appendValueAsString(o, sb);
                continue;
            }
            catch (JSONException ex) {
                sb.append("null");
                ex.printStackTrace();
            }
        }
        if (opsCollected) {
            Iterator iter = sameTypOperations.iterator();
            while (iter.hasNext()) {
                JsonOperationNormalizer.appendValueAsString(iter.next(), sb);
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
        }
        return sb.toString();
    }

    static class OperationSorter
    implements Comparator<JSONObject> {
        private static Collator mCollator = null;

        OperationSorter() {
        }

        @Override
        public int compare(JSONObject op1, JSONObject op2) {
            int returnValue = 0;
            if (op1 instanceof JSONObject && op2 instanceof JSONObject) {
                try {
                    String op1Name = op1.getString("name");
                    String op2Name = op2.getString("name");
                    if (op1Name.equals("addStyle") && op1Name.equals(op2Name)) {
                        String uniqueStyleName1 = op1.getString("type") + op1.getString("styleId");
                        String uniqueStyleName2 = op2.getString("type") + op2.getString("styleId");
                        if (mCollator == null) {
                            mCollator = Collator.getInstance(Locale.US);
                        }
                        return mCollator.compare(uniqueStyleName1, uniqueStyleName2);
                    }
                }
                catch (JSONException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            return returnValue;
        }
    }
}

