/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageConstraint;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

class ZipHelper {
    private ZipFile mZipFile = null;
    private byte[] mZipBuffer = null;
    private OdfPackage mPackage = null;

    public ZipHelper(OdfPackage pkg, ZipFile zipFile) {
        this.mZipFile = zipFile;
        this.mZipBuffer = null;
        this.mPackage = pkg;
    }

    public ZipHelper(OdfPackage pkg, byte[] buffer) {
        this.mZipBuffer = buffer;
        this.mZipFile = null;
        this.mPackage = pkg;
    }

    public static ZipArchiveInputStream createZipInputStream(InputStream is) {
        return new ZipArchiveInputStream(is, StandardCharsets.UTF_8.toString(), true, true);
    }

    String entriesToMap(Map<String, ZipArchiveEntry> zipEntries) throws IOException, SAXException {
        String firstEntryName = null;
        if (this.mZipFile != null) {
            ZipArchiveEntry zipEntry;
            Enumeration entries = this.mZipFile.getEntries();
            if (entries.hasMoreElements() && (zipEntry = (ZipArchiveEntry)entries.nextElement()) != null) {
                firstEntryName = zipEntry.getName();
                this.addZipEntry(zipEntry, zipEntries);
                while (entries.hasMoreElements()) {
                    zipEntry = (ZipArchiveEntry)entries.nextElement();
                    this.addZipEntry(zipEntry, zipEntries);
                }
            }
        } else {
            ZipArchiveInputStream inputStream = ZipHelper.createZipInputStream(new ByteArrayInputStream(this.mZipBuffer));
            ZipArchiveEntry zipEntry = null;
            try {
                zipEntry = inputStream.getNextZipEntry();
            }
            catch (ZipException zipException) {
                // empty catch block
            }
            if (zipEntry != null) {
                firstEntryName = zipEntry.getName();
                this.addZipEntry(zipEntry, zipEntries);
                while (zipEntry != null) {
                    this.addZipEntry(zipEntry, zipEntries);
                    try {
                        zipEntry = inputStream.getNextZipEntry();
                    }
                    catch (ZipException e) {
                        if (e.getMessage().contains("only DEFLATED entries can have EXT descriptor")) {
                            Logger.getLogger(ZipHelper.class.getName()).finer("ZIP seems to contain encoded parts!");
                            throw e;
                        }
                        if (e.getMessage().contains("missing entry name") || "1.5.0".equals(System.getProperty("Java.version"))) continue;
                        Logger.getLogger(ZipHelper.class.getName()).finer("ZIP ENTRY not found");
                        throw e;
                    }
                }
            }
            inputStream.close();
        }
        return firstEntryName;
    }

    private void addZipEntry(ZipArchiveEntry zipEntry, Map<String, ZipArchiveEntry> zipEntries) {
        String filePath = OdfPackage.normalizePath(zipEntry.getName());
        ErrorHandler errorHandler = this.mPackage.getErrorHandler();
        if (errorHandler != null) {
            try {
                int zipMethod = zipEntry.getMethod();
                if (zipMethod != 0 && zipMethod != 8) {
                    this.mPackage.getErrorHandler().error(new OdfValidationException((ValidationConstraint)OdfPackageConstraint.PACKAGE_ENTRY_USING_INVALID_COMPRESSION, this.mPackage.getBaseURI(), filePath));
                }
            }
            catch (SAXException ex) {
                Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        zipEntries.put(filePath, zipEntry);
    }

    InputStream getInputStream(ZipArchiveEntry entry) throws IOException {
        if (this.mZipFile != null) {
            return this.mZipFile.getInputStream(entry);
        }
        ZipArchiveInputStream inputStream = ZipHelper.createZipInputStream(new ByteArrayInputStream(this.mZipBuffer));
        ZipArchiveEntry zipEntry = inputStream.getNextZipEntry();
        while (zipEntry != null) {
            if (zipEntry.getName().equalsIgnoreCase(entry.getName())) {
                return this.readAsInputStream(inputStream);
            }
            zipEntry = inputStream.getNextZipEntry();
        }
        return null;
    }

    private InputStream readAsInputStream(ZipArchiveInputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (outputStream != null) {
            byte[] buf = new byte[4096];
            int r = 0;
            while ((r = inputStream.read(buf, 0, 4096)) > -1) {
                outputStream.write(buf, 0, r);
            }
            inputStream.close();
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    void close() throws IOException {
        if (this.mZipFile != null) {
            this.mZipFile.close();
        } else {
            this.mZipBuffer = null;
        }
    }
}

