/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.util.HashMap;
import java.util.Map;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfPackageNamespace;

public class OdfNamespace
implements Comparable<OdfNamespace>,
NamespaceName {
    private static Map<String, OdfNamespace> mNamespacesByURI = new HashMap<String, OdfNamespace>();
    private String mUri;
    private String mPrefix;
    private static Map<String, String> mUrlToPrefix;

    private OdfNamespace() {
    }

    private OdfNamespace(String prefix, String uri) {
        this.mUri = uri;
        this.mPrefix = prefix;
    }

    public static OdfNamespace newNamespace(NamespaceName name) {
        OdfNamespace ns = null;
        if (name != null) {
            ns = OdfNamespace.newNamespace(name.getPrefix(), name.getUri());
        }
        return ns;
    }

    public static OdfNamespace newNamespace(String prefix, String uri) {
        OdfNamespace odfNamespace = null;
        if (prefix == null || prefix.isEmpty()) {
            if (mUrlToPrefix == null) {
                OdfNamespace.initializeUrl2DefaultPrefixMap();
            }
            prefix = mUrlToPrefix.get(uri);
        }
        if (uri != null && uri.length() > 0) {
            odfNamespace = mNamespacesByURI.get(uri);
            if (odfNamespace == null) {
                odfNamespace = new OdfNamespace(prefix, uri);
                mNamespacesByURI.put(uri, odfNamespace);
            } else if (prefix != null) {
                odfNamespace.mPrefix = prefix;
            }
        }
        return odfNamespace;
    }

    public static void initializeUrl2DefaultPrefixMap() {
        mUrlToPrefix = new HashMap<String, String>(32);
        for (OdfPackageNamespace odfPackageNamespace : OdfPackageNamespace.values()) {
            mUrlToPrefix.put(odfPackageNamespace.getUri(), odfPackageNamespace.getPrefix());
        }
        for (Enum enum_ : OdfDocumentNamespace.values()) {
            mUrlToPrefix.put(((OdfDocumentNamespace)enum_).getUri(), ((OdfDocumentNamespace)enum_).getPrefix());
        }
    }

    public static OdfNamespace getNamespace(String uri) {
        OdfNamespace ns = null;
        if (uri != null) {
            ns = mNamespacesByURI.get(uri);
        }
        return ns;
    }

    @Override
    public String getPrefix() {
        return this.mPrefix;
    }

    @Override
    public String getUri() {
        return this.mUri;
    }

    public boolean equals(Object obj) {
        if (this.mUri != null) {
            return this.mUri.equals(obj.toString());
        }
        return this.mUri == obj;
    }

    public int hashCode() {
        if (this.mUri != null) {
            return this.mUri.hashCode();
        }
        return 0;
    }

    public String toString() {
        return this.mUri;
    }

    public static String[] splitQName(String qname) throws IllegalArgumentException {
        String localpart = qname;
        String prefix = null;
        int colon = qname.indexOf(58);
        if (colon <= 0) {
            throw new IllegalArgumentException("A qualified name was required, but '" + qname + "' was given!");
        }
        localpart = qname.substring(colon + 1);
        prefix = qname.substring(0, colon);
        return new String[]{prefix, localpart};
    }

    public static String getPrefixPart(String qname) {
        return OdfNamespace.splitQName(qname)[0];
    }

    public static String getLocalPart(String qname) {
        return OdfNamespace.splitQName(qname)[1];
    }

    @Override
    public int compareTo(OdfNamespace namespace) {
        return this.toString().compareTo(namespace.toString());
    }
}

