/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.changes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odftoolkit.odfdom.changes.FieldMap;
import org.odftoolkit.odfdom.changes.TextSelection;
import org.odftoolkit.odfdom.dom.element.number.DataStyleElement;
import org.odftoolkit.odfdom.dom.element.text.TextUserFieldDeclElement;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberDateStyle;
import org.odftoolkit.odfdom.incubator.doc.number.OdfNumberTimeStyle;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;

public class TextFieldSelection
extends TextSelection
implements Comparable {
    private String mReplacementText;
    private final Map<String, Object> mAttrs = new HashMap<String, Object>();

    public TextFieldSelection(OdfElement fieldElement, List<Integer> startPosition, OdfOfficeAutomaticStyles autoStyles, Map<String, TextUserFieldDeclElement> userFieldDecls) {
        this.mSelectionElement = fieldElement;
        this.mStartPosition = startPosition;
        FieldMap currentMap = FieldMap.fieldMap.get(fieldElement.getLocalName());
        if (currentMap != null) {
            String attributeValue = null;
            if (currentMap.hasFixed() && !(attributeValue = this.mSelectionElement.getAttribute("text:fixed")).isEmpty()) {
                this.mAttrs.put("fixed", attributeValue.equals("true") ? "true" : "false");
            }
            if (currentMap.hasDateValue()) {
                String dataStyleName;
                String dateValue = this.mSelectionElement.getAttribute(currentMap.hasTimeStyle() ? "text:time-value" : "text:date-value");
                if (!dateValue.isEmpty()) {
                    this.mAttrs.put("dateValue", dateValue);
                }
                if (!(dataStyleName = this.mSelectionElement.getAttribute("style:data-style-name")).isEmpty()) {
                    OdfNumberDateStyle dateStyle = autoStyles.getDateStyle(dataStyleName);
                    DataStyleElement baseStyle = null;
                    if (dateStyle != null) {
                        baseStyle = dateStyle;
                        this.mAttrs.put("dateFormat", dateStyle.getFormat(true));
                    } else {
                        OdfNumberTimeStyle timeStyle = autoStyles.getTimeStyle(dataStyleName);
                        if (timeStyle != null) {
                            baseStyle = timeStyle;
                            this.mAttrs.put("dateFormat", timeStyle.getFormat(true));
                        }
                    }
                    if (baseStyle != null) {
                        Object language = baseStyle.getAttribute("number:language");
                        String country = baseStyle.getAttribute("number:country");
                        if (!((String)language).isEmpty()) {
                            if (!country.isEmpty()) {
                                language = (String)language + "-";
                                language = (String)language + country;
                            }
                            this.mAttrs.put("locale", language);
                        }
                    }
                }
            }
            if (currentMap.hasdbName() && !(attributeValue = this.mSelectionElement.getAttribute("text:database-name")).isEmpty()) {
                this.mAttrs.put("dbName", attributeValue);
            }
            if (currentMap.hasTableType() && !(attributeValue = this.mSelectionElement.getAttribute("text:table-type")).isEmpty()) {
                this.mAttrs.put("tableType", attributeValue);
            }
            if (currentMap.hasdbTable() && !(attributeValue = this.mSelectionElement.getAttribute("text:table-name")).isEmpty()) {
                this.mAttrs.put("dbTable", attributeValue);
            }
            if (currentMap.hasdbColumn() && !(attributeValue = this.mSelectionElement.getAttribute("text:column-name")).isEmpty()) {
                this.mAttrs.put("dbColumn", attributeValue);
            }
            if (currentMap.hasDisplay() && !(attributeValue = this.mSelectionElement.getAttribute("text:display")).isEmpty()) {
                this.mAttrs.put("display", attributeValue);
            }
            if (currentMap.hasRefFormat() && !(attributeValue = this.mSelectionElement.getAttribute("text:reference-format")).isEmpty()) {
                this.mAttrs.put("refFormat", attributeValue);
            }
            if (currentMap.hasRefName() && !(attributeValue = this.mSelectionElement.getAttribute("text:ref-name")).isEmpty()) {
                this.mAttrs.put("refName", attributeValue);
            }
            if (currentMap.hasOutlinelevel() && !(attributeValue = this.mSelectionElement.getAttribute("text:outline-level")).isEmpty()) {
                this.mAttrs.put("outlineLevel", attributeValue);
            }
            if (currentMap.hasPageNumFormat() && !(attributeValue = this.mSelectionElement.getAttribute("style:num-format")).isEmpty()) {
                this.mAttrs.put("pageNumFormat", attributeValue);
            }
            if (currentMap.hasNumLetterSync() && !(attributeValue = this.mSelectionElement.getAttribute("style:num-letter-sync")).isEmpty()) {
                this.mAttrs.put("numLetterSync", attributeValue);
            }
            if (currentMap.hasCondition() && !(attributeValue = this.mSelectionElement.getAttribute("text:condition")).isEmpty()) {
                this.mAttrs.put("condition", attributeValue);
            }
            if (currentMap.hasCurrentValue() && !(attributeValue = this.mSelectionElement.getAttribute("text:current-value")).isEmpty()) {
                this.mAttrs.put("currentValue", attributeValue);
            }
            if (currentMap.hasFalseValue() && !(attributeValue = this.mSelectionElement.getAttribute("text:string-value-if-false")).isEmpty()) {
                this.mAttrs.put("falseValue", attributeValue);
            }
            if (currentMap.hasTrueValue() && !(attributeValue = this.mSelectionElement.getAttribute("text:string-value-if-true")).isEmpty()) {
                this.mAttrs.put("trueValue", attributeValue);
            }
            if (currentMap.hasConnectionName() && !(attributeValue = this.mSelectionElement.getAttribute("text:connection-name")).isEmpty()) {
                this.mAttrs.put("connectionName", attributeValue);
            }
            if (currentMap.hasDuration() && !(attributeValue = this.mSelectionElement.getAttribute("text-duration")).isEmpty()) {
                this.mAttrs.put("duration", attributeValue);
            }
            if (currentMap.hasName() && !(attributeValue = this.mSelectionElement.getAttribute("text:name")).isEmpty()) {
                this.mAttrs.put("name", attributeValue);
            }
            if (currentMap.hasBoolValue() && !(attributeValue = this.mSelectionElement.getAttribute("office:boolean-value")).isEmpty()) {
                this.mAttrs.put("boolValue", attributeValue);
            }
            if (currentMap.hasCurrency() && !(attributeValue = this.mSelectionElement.getAttribute("office:currency")).isEmpty()) {
                this.mAttrs.put("currency", attributeValue);
            }
            if (currentMap.hasStringValue() && !(attributeValue = this.mSelectionElement.getAttribute("office:value")).isEmpty()) {
                this.mAttrs.put("stringValue", attributeValue);
            }
            if (currentMap.hasTimeValue() && !(attributeValue = this.mSelectionElement.getAttribute("text:time-value")).isEmpty()) {
                this.mAttrs.put("timeValue", attributeValue);
            }
            if (currentMap.hasTValue() && !(attributeValue = this.mSelectionElement.getAttribute("text:value")).isEmpty()) {
                this.mAttrs.put("value", attributeValue);
            }
            if (currentMap.hasOValue() && !(attributeValue = this.mSelectionElement.getAttribute("office:value")).isEmpty()) {
                this.mAttrs.put("value", attributeValue);
            }
            if (currentMap.hasValueType()) {
                if (fieldElement.getLocalName().equals("user-field-get")) {
                    TextUserFieldDeclElement fieldDecl = userFieldDecls.get(this.mAttrs.get("name"));
                    if (fieldDecl != null && !(attributeValue = fieldDecl.getAttribute("office:value-type")).isEmpty()) {
                        this.mAttrs.put("valueType", attributeValue);
                    }
                } else {
                    attributeValue = this.mSelectionElement.getAttribute("office:value-type");
                    if (!attributeValue.isEmpty()) {
                        this.mAttrs.put("valueType", attributeValue);
                    }
                }
            }
            if (currentMap.hasFormula() && !(attributeValue = this.mSelectionElement.getAttribute("text:formula")).isEmpty()) {
                this.mAttrs.put("formula", attributeValue);
            }
            if (currentMap.hasIsHidden() && !(attributeValue = this.mSelectionElement.getAttribute("xml:id")).isEmpty()) {
                this.mAttrs.put("isHidden", attributeValue);
            }
            if (currentMap.hasId() && !(attributeValue = this.mSelectionElement.getAttribute("xml:id")).isEmpty()) {
                this.mAttrs.put("id", attributeValue);
            }
            if (currentMap.hasDescription() && !(attributeValue = this.mSelectionElement.getAttribute("text:description")).isEmpty()) {
                this.mAttrs.put("description", attributeValue);
            }
            if (currentMap.hasActive() && !(attributeValue = this.mSelectionElement.getAttribute("text:active")).isEmpty()) {
                this.mAttrs.put("active", attributeValue);
            }
            if (currentMap.hasHref() && !(attributeValue = this.mSelectionElement.getAttribute("xlink:href")).isEmpty()) {
                this.mAttrs.put("href", attributeValue);
            }
            if (currentMap.hasPlaceHolderType() && !(attributeValue = this.mSelectionElement.getAttribute("text:placeholder-type")).isEmpty()) {
                this.mAttrs.put("placeHolderType", attributeValue);
            }
            if (currentMap.hasKind() && !(attributeValue = this.mSelectionElement.getAttribute("text:kind")).isEmpty()) {
                this.mAttrs.put("kind", attributeValue);
            }
            if (currentMap.hasLanguage() && !(attributeValue = this.mSelectionElement.getAttribute("script:language")).isEmpty()) {
                this.mAttrs.put("language", attributeValue);
            }
            if (currentMap.hasLinkType() && !(attributeValue = this.mSelectionElement.getAttribute("xlink:type")).isEmpty()) {
                this.mAttrs.put("linkType", attributeValue);
            }
            if (currentMap.hasNumFormat() && !(attributeValue = this.mSelectionElement.getAttribute("style:num-format")).isEmpty()) {
                this.mAttrs.put("numFormat", attributeValue);
            }
            if (currentMap.hasPageAdjust() && !(attributeValue = this.mSelectionElement.getAttribute("text:page-adjust")).isEmpty()) {
                this.mAttrs.put("pageAdjust", attributeValue);
            }
            if (currentMap.hasRowNumber() && !(attributeValue = this.mSelectionElement.getAttribute("text:row-number")).isEmpty()) {
                this.mAttrs.put("rowNumber", attributeValue);
            }
        }
    }

    public TextFieldSelection(OdfElement fieldElement, List<Integer> startPosition, String replacementText) {
        this.mSelectionElement = fieldElement;
        this.mStartPosition = startPosition;
        this.mReplacementText = replacementText;
    }

    TextFieldSelection(OdfElement fieldElement, List<Integer> startPosition, List<Integer> endPosition) {
        this.mSelectionElement = fieldElement;
        this.mStartPosition = startPosition;
        this.mEndPosition = endPosition;
    }

    public String getReplacementText() {
        return this.mReplacementText;
    }

    public Map<String, Object> getAttributes() {
        return this.mAttrs;
    }

    public String toString() {
        return this.mStartPosition.toString() + "-URL" + this.mUrl + "-" + this.mEndPosition.toString() + this.mSelectionElement.toString();
    }
}

